/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.mementos;

import brooklyn.entity.rebind.BrooklynObjectType;
import com.google.common.annotations.Beta;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;

@Beta
public class BrooklynMementoRawData {
    private final Map<String, String> entities;
    private final Map<String, String> locations;
    private final Map<String, String> policies;
    private final Map<String, String> enrichers;
    private final Map<String, String> feeds;
    private final Map<String, String> catalogItems;

    public static Builder builder() {
        return new Builder();
    }

    private BrooklynMementoRawData(Builder builder) {
        this.entities = builder.entities;
        this.locations = builder.locations;
        this.policies = builder.policies;
        this.enrichers = builder.enrichers;
        this.feeds = builder.feeds;
        this.catalogItems = builder.catalogItems;
    }

    public Map<String, String> getEntities() {
        return Collections.unmodifiableMap(this.entities);
    }

    public Map<String, String> getLocations() {
        return Collections.unmodifiableMap(this.locations);
    }

    public Map<String, String> getPolicies() {
        return Collections.unmodifiableMap(this.policies);
    }

    public Map<String, String> getEnrichers() {
        return Collections.unmodifiableMap(this.enrichers);
    }

    public Map<String, String> getFeeds() {
        return Collections.unmodifiableMap(this.feeds);
    }

    public Map<String, String> getCatalogItems() {
        return Collections.unmodifiableMap(this.catalogItems);
    }

    @Beta
    public void clearCatalogItems() {
        this.catalogItems.clear();
    }

    public boolean isEmpty() {
        return this.entities.isEmpty() && this.locations.isEmpty() && this.policies.isEmpty() && this.enrichers.isEmpty() && this.feeds.isEmpty() && this.catalogItems.isEmpty();
    }

    public Map<String, String> getObjectsOfType(BrooklynObjectType type) {
        switch (type) {
            case ENTITY: {
                return this.getEntities();
            }
            case LOCATION: {
                return this.getLocations();
            }
            case POLICY: {
                return this.getPolicies();
            }
            case ENRICHER: {
                return this.getEnrichers();
            }
            case FEED: {
                return this.getFeeds();
            }
            case CATALOG_ITEM: {
                return this.getCatalogItems();
            }
        }
        throw new IllegalArgumentException("Type " + (Object)((Object)type) + " not supported");
    }

    public static class Builder {
        protected String brooklynVersion;
        protected final Map<String, String> entities = Maps.newConcurrentMap();
        protected final Map<String, String> locations = Maps.newConcurrentMap();
        protected final Map<String, String> policies = Maps.newConcurrentMap();
        protected final Map<String, String> enrichers = Maps.newConcurrentMap();
        protected final Map<String, String> feeds = Maps.newConcurrentMap();
        protected final Map<String, String> catalogItems = Maps.newConcurrentMap();

        public Builder brooklynVersion(String val) {
            this.brooklynVersion = val;
            return this;
        }

        public Builder entity(String id, String val) {
            this.entities.put(id, val);
            return this;
        }

        public Builder entities(Map<String, String> vals) {
            this.entities.putAll(vals);
            return this;
        }

        public Builder location(String id, String val) {
            this.locations.put(id, val);
            return this;
        }

        public Builder locations(Map<String, String> vals) {
            this.locations.putAll(vals);
            return this;
        }

        public Builder policy(String id, String val) {
            this.policies.put(id, val);
            return this;
        }

        public Builder policies(Map<String, String> vals) {
            this.policies.putAll(vals);
            return this;
        }

        public Builder enricher(String id, String val) {
            this.enrichers.put(id, val);
            return this;
        }

        public Builder enrichers(Map<String, String> vals) {
            this.enrichers.putAll(vals);
            return this;
        }

        public Builder feed(String id, String val) {
            this.feeds.put(id, val);
            return this;
        }

        public Builder feeds(Map<String, String> vals) {
            this.feeds.putAll(vals);
            return this;
        }

        public Builder catalogItem(String id, String val) {
            this.catalogItems.put(id, val);
            return this;
        }

        public Builder catalogItems(Map<String, String> vals) {
            this.catalogItems.putAll(vals);
            return this;
        }

        public Builder put(BrooklynObjectType type, String id, String val) {
            switch (type) {
                case ENTITY: {
                    return this.entity(id, val);
                }
                case LOCATION: {
                    return this.location(id, val);
                }
                case POLICY: {
                    return this.policy(id, val);
                }
                case ENRICHER: {
                    return this.enricher(id, val);
                }
                case FEED: {
                    return this.feed(id, val);
                }
                case CATALOG_ITEM: {
                    return this.catalogItem(id, val);
                }
            }
            throw new IllegalArgumentException((Object)((Object)type) + " not supported");
        }

        public Builder putAll(BrooklynObjectType type, Map<String, String> vals) {
            switch (type) {
                case ENTITY: {
                    return this.entities(vals);
                }
                case LOCATION: {
                    return this.locations(vals);
                }
                case POLICY: {
                    return this.policies(vals);
                }
                case ENRICHER: {
                    return this.enrichers(vals);
                }
                case FEED: {
                    return this.feeds(vals);
                }
                case CATALOG_ITEM: {
                    return this.catalogItems(vals);
                }
            }
            throw new IllegalArgumentException((Object)((Object)type) + " not supported");
        }

        public BrooklynMementoRawData build() {
            return new BrooklynMementoRawData(this);
        }
    }
}

