/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.mementos;

import brooklyn.basic.BrooklynObject;
import brooklyn.catalog.CatalogItem;
import brooklyn.entity.Entity;
import brooklyn.entity.Feed;
import brooklyn.entity.rebind.BrooklynObjectType;
import brooklyn.entity.rebind.PersistenceExceptionHandler;
import brooklyn.entity.rebind.RebindExceptionHandler;
import brooklyn.location.Location;
import brooklyn.management.ManagementContext;
import brooklyn.mementos.BrooklynMemento;
import brooklyn.mementos.BrooklynMementoManifest;
import brooklyn.mementos.BrooklynMementoRawData;
import brooklyn.mementos.CatalogItemMemento;
import brooklyn.mementos.EnricherMemento;
import brooklyn.mementos.EntityMemento;
import brooklyn.mementos.FeedMemento;
import brooklyn.mementos.LocationMemento;
import brooklyn.mementos.Memento;
import brooklyn.mementos.PolicyMemento;
import brooklyn.policy.Enricher;
import brooklyn.policy.Policy;
import brooklyn.util.time.Duration;
import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

public interface BrooklynMementoPersister {
    public BrooklynMementoRawData loadMementoRawData(RebindExceptionHandler var1);

    public BrooklynMementoManifest loadMementoManifest(RebindExceptionHandler var1) throws IOException;

    public BrooklynMementoManifest loadMementoManifest(@Nullable BrooklynMementoRawData var1, RebindExceptionHandler var2) throws IOException;

    public BrooklynMemento loadMemento(LookupContext var1, RebindExceptionHandler var2) throws IOException;

    public BrooklynMemento loadMemento(@Nullable BrooklynMementoRawData var1, LookupContext var2, RebindExceptionHandler var3) throws IOException;

    @Deprecated
    public void checkpoint(BrooklynMemento var1, PersistenceExceptionHandler var2);

    public void checkpoint(BrooklynMementoRawData var1, PersistenceExceptionHandler var2);

    public void delta(Delta var1, PersistenceExceptionHandler var2);

    @Beta
    public void queueDelta(Delta var1);

    public void enableWriteAccess();

    public void disableWriteAccess(boolean var1);

    public void stop(boolean var1);

    @VisibleForTesting
    public void waitForWritesCompleted(Duration var1) throws InterruptedException, TimeoutException;

    @VisibleForTesting
    public void waitForWritesCompleted(long var1, TimeUnit var3) throws InterruptedException, TimeoutException;

    public String getBackingStoreDescription();

    @Beta
    public static interface MutableDelta
    extends Delta {
        public void add(BrooklynObjectType var1, Memento var2);

        public void addAll(BrooklynObjectType var1, Iterable<? extends Memento> var2);

        public void removed(BrooklynObjectType var1, Set<String> var2);
    }

    public static interface Delta {
        public Collection<LocationMemento> locations();

        public Collection<EntityMemento> entities();

        public Collection<PolicyMemento> policies();

        public Collection<EnricherMemento> enrichers();

        public Collection<FeedMemento> feeds();

        public Collection<CatalogItemMemento> catalogItems();

        public Collection<String> removedLocationIds();

        public Collection<String> removedEntityIds();

        public Collection<String> removedPolicyIds();

        public Collection<String> removedEnricherIds();

        public Collection<String> removedFeedIds();

        public Collection<String> removedCatalogItemIds();

        public Collection<? extends Memento> getObjectsOfType(BrooklynObjectType var1);

        public Collection<String> getRemovedIdsOfType(BrooklynObjectType var1);
    }

    public static interface LookupContext {
        public ManagementContext lookupManagementContext();

        public Entity lookupEntity(String var1);

        public Location lookupLocation(String var1);

        public Policy lookupPolicy(String var1);

        public Enricher lookupEnricher(String var1);

        public Feed lookupFeed(String var1);

        public CatalogItem<?, ?> lookupCatalogItem(String var1);

        public BrooklynObject lookup(BrooklynObjectType var1, String var2);

        public BrooklynObject peek(BrooklynObjectType var1, String var2);
    }
}

