/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location;

import brooklyn.basic.AbstractBrooklynObjectSpec;
import brooklyn.config.ConfigKey;
import brooklyn.location.Location;
import brooklyn.management.Task;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationSpec<T extends Location>
extends AbstractBrooklynObjectSpec<T, LocationSpec<T>> {
    private static final Logger log = LoggerFactory.getLogger(LocationSpec.class);
    private static final long serialVersionUID = 1L;
    private String id;
    private Location parent;
    private final Map<String, Object> flags = Maps.newLinkedHashMap();
    private final Map<ConfigKey<?>, Object> config = Maps.newLinkedHashMap();
    private final Map<Class<?>, Object> extensions = Maps.newLinkedHashMap();

    public static <T extends Location> LocationSpec<T> create(Class<T> type) {
        return new LocationSpec<T>(type);
    }

    public static <T extends Location> LocationSpec<T> create(Map<?, ?> config, Class<T> type) {
        return LocationSpec.create(type).configure(config);
    }

    public static <T extends Location> LocationSpec<T> create(LocationSpec<T> spec) {
        Class exactType = spec.getType();
        LocationSpec<T> result = ((LocationSpec)((LocationSpec)((LocationSpec)LocationSpec.create(exactType).displayName(spec.getDisplayName())).tags(spec.getTags())).configure(spec.getConfig()).configure(spec.getFlags()).catalogItemId(spec.getCatalogItemId())).extensions(spec.getExtensions());
        if (spec.getParent() != null) {
            result.parent(spec.getParent());
        }
        return result;
    }

    protected LocationSpec(Class<T> type) {
        super(type);
    }

    @Override
    protected void checkValidType(Class<? extends T> type) {
        this.checkIsImplementation(type, Location.class);
        this.checkIsNewStyleImplementation(type);
    }

    @Deprecated
    public LocationSpec<T> id(String val) {
        this.id = val;
        return this;
    }

    public LocationSpec<T> parent(Location val) {
        this.parent = (Location)Preconditions.checkNotNull((Object)val, (Object)"parent");
        return this;
    }

    public LocationSpec<T> configure(Map<?, ?> val) {
        for (Map.Entry<?, ?> entry : val.entrySet()) {
            if (entry.getKey() == null) {
                throw new NullPointerException("Null key not permitted");
            }
            if (entry.getKey() instanceof CharSequence) {
                this.flags.put(entry.getKey().toString(), entry.getValue());
                continue;
            }
            if (entry.getKey() instanceof ConfigKey) {
                this.config.put((ConfigKey)entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getKey() instanceof ConfigKey.HasConfigKey) {
                this.config.put(((ConfigKey.HasConfigKey)entry.getKey()).getConfigKey(), entry.getValue());
                continue;
            }
            log.warn("Spec " + this + " ignoring unknown config key " + entry.getKey());
        }
        return this;
    }

    public LocationSpec<T> configure(CharSequence key, Object val) {
        this.flags.put(((CharSequence)Preconditions.checkNotNull((Object)key, (Object)"key")).toString(), val);
        return this;
    }

    public <V> LocationSpec<T> configure(ConfigKey<V> key, V val) {
        this.config.put((ConfigKey<?>)Preconditions.checkNotNull(key, (Object)"key"), val);
        return this;
    }

    public <V> LocationSpec<T> configureIfNotNull(ConfigKey<V> key, V val) {
        return val != null ? this.configure(key, val) : this;
    }

    public <V> LocationSpec<T> configure(ConfigKey<V> key, Task<? extends V> val) {
        this.config.put((ConfigKey<?>)Preconditions.checkNotNull(key, (Object)"key"), val);
        return this;
    }

    public <V> LocationSpec<T> configure(ConfigKey.HasConfigKey<V> key, V val) {
        this.config.put(((ConfigKey.HasConfigKey)Preconditions.checkNotNull(key, (Object)"key")).getConfigKey(), val);
        return this;
    }

    public <V> LocationSpec<T> configure(ConfigKey.HasConfigKey<V> key, Task<? extends V> val) {
        this.config.put(((ConfigKey.HasConfigKey)Preconditions.checkNotNull(key, (Object)"key")).getConfigKey(), val);
        return this;
    }

    public <V> LocationSpec<T> removeConfig(ConfigKey<V> key) {
        this.config.remove(Preconditions.checkNotNull(key, (Object)"key"));
        return this;
    }

    public <E> LocationSpec<T> extension(Class<E> extensionType, E extension) {
        this.extensions.put((Class<?>)Preconditions.checkNotNull(extensionType, (Object)"extensionType"), Preconditions.checkNotNull(extension, (Object)"extension"));
        return this;
    }

    public <E> LocationSpec<T> extensions(Map<Class<?>, ?> extensions) {
        for (Map.Entry<Class<?>, ?> entry : extensions.entrySet()) {
            this.extension(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Deprecated
    public String getId() {
        return this.id;
    }

    public Location getParent() {
        return this.parent;
    }

    public Map<String, ?> getFlags() {
        return Collections.unmodifiableMap(this.flags);
    }

    public Map<ConfigKey<?>, Object> getConfig() {
        return Collections.unmodifiableMap(this.config);
    }

    public Map<Class<?>, Object> getExtensions() {
        return Collections.unmodifiableMap(this.extensions);
    }
}

