/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.rebind;

import brooklyn.basic.BrooklynObject;
import brooklyn.catalog.CatalogItem;
import brooklyn.entity.Entity;
import brooklyn.entity.Feed;
import brooklyn.location.Location;
import brooklyn.policy.Enricher;
import brooklyn.policy.Policy;
import com.google.common.annotations.Beta;
import com.google.common.base.CaseFormat;

@Beta
public enum BrooklynObjectType {
    ENTITY(Entity.class, "entities"),
    LOCATION(Location.class, "locations"),
    POLICY(Policy.class, "policies"),
    ENRICHER(Enricher.class, "enrichers"),
    FEED(Feed.class, "feeds"),
    CATALOG_ITEM(CatalogItem.class, "catalog"),
    UNKNOWN(null, "unknown");

    private Class<? extends BrooklynObject> interfaceType;
    private final String subPathName;

    private BrooklynObjectType(Class<? extends BrooklynObject> interfaceType, String subPathName) {
        this.interfaceType = interfaceType;
        this.subPathName = subPathName;
    }

    public String toCamelCase() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.name());
    }

    public String getSubPathName() {
        return this.subPathName;
    }

    public Class<? extends BrooklynObject> getInterfaceType() {
        return this.interfaceType;
    }

    public static BrooklynObjectType of(BrooklynObject instance) {
        for (BrooklynObjectType t : BrooklynObjectType.values()) {
            if (t.getInterfaceType() == null || !t.getInterfaceType().isInstance(instance)) continue;
            return t;
        }
        return UNKNOWN;
    }
}

