/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.proxying;

import brooklyn.basic.AbstractBrooklynObjectSpec;
import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.Group;
import brooklyn.entity.proxying.EntityInitializer;
import brooklyn.location.Location;
import brooklyn.management.Task;
import brooklyn.policy.Enricher;
import brooklyn.policy.EnricherSpec;
import brooklyn.policy.Policy;
import brooklyn.policy.PolicySpec;
import brooklyn.util.collections.MutableList;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitySpec<T extends Entity>
extends AbstractBrooklynObjectSpec<T, EntitySpec<T>> {
    private static final long serialVersionUID = -2247153452919128990L;
    private static final Logger log = LoggerFactory.getLogger(EntitySpec.class);
    private String id;
    private Class<? extends T> impl;
    private Entity parent;
    private final Map<String, Object> flags = Maps.newLinkedHashMap();
    private final Map<ConfigKey<?>, Object> config = Maps.newLinkedHashMap();
    private final List<Policy> policies = Lists.newArrayList();
    private final List<PolicySpec<?>> policySpecs = Lists.newArrayList();
    private final List<Enricher> enrichers = Lists.newArrayList();
    private final List<EnricherSpec<?>> enricherSpecs = Lists.newArrayList();
    private final List<Location> locations = Lists.newArrayList();
    private final Set<Class<?>> additionalInterfaces = Sets.newLinkedHashSet();
    private final List<EntityInitializer> entityInitializers = Lists.newArrayList();
    private final List<EntitySpec<?>> children = Lists.newArrayList();
    private final List<Entity> members = Lists.newArrayList();
    private final List<Group> groups = Lists.newArrayList();
    private volatile boolean immutable;

    public static <T extends Entity> EntitySpec<T> create(Class<T> type) {
        return new EntitySpec<T>(type);
    }

    public static <T extends Entity, U extends T> EntitySpec<T> create(Class<T> type, Class<U> implType) {
        return new EntitySpec<U>(type).impl(implType);
    }

    public static <T extends Entity> EntitySpec<T> create(Map<?, ?> config, Class<T> type) {
        return EntitySpec.create(type).configure(config);
    }

    public static <T extends Entity> EntitySpec<T> create(EntitySpec<T> spec) {
        EntitySpec<T> result = ((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(spec.getType()).displayName(spec.getDisplayName())).tags(spec.getTags())).additionalInterfaces(spec.getAdditionalInterfaces()).configure(spec.getConfig()).configure(spec.getFlags()).policySpecs(spec.getPolicySpecs()).policies(spec.getPolicies()).enricherSpecs(spec.getEnricherSpecs()).enrichers(spec.getEnrichers()).addInitializers(spec.getInitializers()).children(spec.getChildren()).members(spec.getMembers()).groups(spec.getGroups()).catalogItemId(spec.getCatalogItemId())).locations(spec.getLocations());
        if (spec.getParent() != null) {
            result.parent(spec.getParent());
        }
        if (spec.getImplementation() != null) {
            result.impl(spec.getImplementation());
        }
        return result;
    }

    public static <T extends Entity> EntitySpec<T> newInstance(Class<T> type) {
        return new EntitySpec<T>(type);
    }

    public EntitySpec(Class<T> type) {
        super(type);
    }

    @Override
    public Class<T> getType() {
        return super.getType();
    }

    @Override
    protected void checkValidType(Class<? extends T> type) {
    }

    @Deprecated
    public String getId() {
        return this.id;
    }

    @Nullable
    public Class<? extends T> getImplementation() {
        return this.impl;
    }

    public Set<Class<?>> getAdditionalInterfaces() {
        return this.additionalInterfaces;
    }

    public List<EntityInitializer> getInitializers() {
        return this.entityInitializers;
    }

    public List<EntitySpec<?>> getChildren() {
        return this.children;
    }

    public List<Entity> getMembers() {
        return this.members;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public Entity getParent() {
        return this.parent;
    }

    public Map<String, ?> getFlags() {
        return Collections.unmodifiableMap(this.flags);
    }

    public Map<ConfigKey<?>, Object> getConfig() {
        return Collections.unmodifiableMap(this.config);
    }

    public void clearConfig() {
        this.config.clear();
    }

    public List<PolicySpec<?>> getPolicySpecs() {
        return this.policySpecs;
    }

    public List<Policy> getPolicies() {
        return this.policies;
    }

    public List<EnricherSpec<?>> getEnricherSpecs() {
        return this.enricherSpecs;
    }

    public List<Enricher> getEnrichers() {
        return this.enrichers;
    }

    public List<Location> getLocations() {
        return this.locations;
    }

    @Deprecated
    public EntitySpec<T> id(String val) {
        this.checkMutable();
        this.id = val;
        return this;
    }

    public EntitySpec<T> impl(Class<? extends T> val) {
        this.checkMutable();
        this.checkIsImplementation((Class)Preconditions.checkNotNull(val, (Object)"impl"), this.getType());
        this.checkIsNewStyleImplementation(val);
        this.impl = val;
        return this;
    }

    public EntitySpec<T> additionalInterfaces(Class<?> ... vals) {
        this.checkMutable();
        for (Class<?> val : vals) {
            this.additionalInterfaces.add(val);
        }
        return this;
    }

    public EntitySpec<T> additionalInterfaces(Iterable<Class<?>> val) {
        this.checkMutable();
        this.additionalInterfaces.addAll(Sets.newLinkedHashSet(val));
        return this;
    }

    public EntitySpec<T> addInitializer(EntityInitializer initializer) {
        this.checkMutable();
        this.entityInitializers.add(initializer);
        return this;
    }

    public EntitySpec<T> addInitializers(Iterable<? extends EntityInitializer> initializers) {
        this.checkMutable();
        Iterables.addAll(this.entityInitializers, initializers);
        return this;
    }

    public EntitySpec<T> addInitializer(Class<? extends EntityInitializer> initializerType) {
        this.checkMutable();
        try {
            this.entityInitializers.add(initializerType.newInstance());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        return this;
    }

    public EntitySpec<T> children(Iterable<? extends EntitySpec<?>> children) {
        this.checkMutable();
        Iterables.addAll(this.children, children);
        return this;
    }

    public EntitySpec<T> child(EntitySpec<?> child) {
        this.checkMutable();
        this.children.add(child);
        return this;
    }

    public EntitySpec<T> members(Iterable<? extends Entity> members) {
        this.checkMutable();
        Iterables.addAll(this.members, members);
        return this;
    }

    public EntitySpec<T> member(Entity member) {
        this.checkMutable();
        this.members.add(member);
        return this;
    }

    public EntitySpec<T> groups(Iterable<? extends Group> groups) {
        this.checkMutable();
        Iterables.addAll(this.groups, groups);
        return this;
    }

    public EntitySpec<T> group(Group group) {
        this.checkMutable();
        this.groups.add(group);
        return this;
    }

    public EntitySpec<T> parent(Entity val) {
        this.checkMutable();
        this.parent = (Entity)Preconditions.checkNotNull((Object)val, (Object)"parent");
        return this;
    }

    public EntitySpec<T> configure(Map<?, ?> val) {
        this.checkMutable();
        for (Map.Entry<?, ?> entry : val.entrySet()) {
            if (entry.getKey() == null) {
                throw new NullPointerException("Null key not permitted");
            }
            if (entry.getKey() instanceof CharSequence) {
                this.flags.put(entry.getKey().toString(), entry.getValue());
                continue;
            }
            if (entry.getKey() instanceof ConfigKey) {
                this.config.put((ConfigKey)entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getKey() instanceof ConfigKey.HasConfigKey) {
                this.config.put(((ConfigKey.HasConfigKey)entry.getKey()).getConfigKey(), entry.getValue());
                continue;
            }
            log.warn("Spec " + this + " ignoring unknown config key " + entry.getKey());
        }
        return this;
    }

    public EntitySpec<T> configure(CharSequence key, Object val) {
        this.checkMutable();
        this.flags.put(((CharSequence)Preconditions.checkNotNull((Object)key, (Object)"key")).toString(), val);
        return this;
    }

    public <V> EntitySpec<T> configure(ConfigKey<V> key, V val) {
        this.checkMutable();
        this.config.put((ConfigKey<?>)Preconditions.checkNotNull(key, (Object)"key"), val);
        return this;
    }

    public <V> EntitySpec<T> configure(ConfigKey<V> key, Task<? extends V> val) {
        this.checkMutable();
        this.config.put((ConfigKey<?>)Preconditions.checkNotNull(key, (Object)"key"), val);
        return this;
    }

    public <V> EntitySpec<T> configure(ConfigKey<V> key, Supplier<? extends V> val) {
        this.checkMutable();
        this.config.put((ConfigKey<?>)Preconditions.checkNotNull(key, (Object)"key"), val);
        return this;
    }

    public <V> EntitySpec<T> configure(ConfigKey.HasConfigKey<V> key, V val) {
        this.checkMutable();
        this.config.put(((ConfigKey.HasConfigKey)Preconditions.checkNotNull(key, (Object)"key")).getConfigKey(), val);
        return this;
    }

    public <V> EntitySpec<T> configure(ConfigKey.HasConfigKey<V> key, Task<? extends V> val) {
        this.checkMutable();
        this.config.put(((ConfigKey.HasConfigKey)Preconditions.checkNotNull(key, (Object)"key")).getConfigKey(), val);
        return this;
    }

    public <V> EntitySpec<T> policy(Policy val) {
        this.checkMutable();
        this.policies.add((Policy)Preconditions.checkNotNull((Object)val, (Object)"policy"));
        return this;
    }

    public <V> EntitySpec<T> policy(PolicySpec<?> val) {
        this.checkMutable();
        this.policySpecs.add((PolicySpec<?>)Preconditions.checkNotNull(val, (Object)"policySpec"));
        return this;
    }

    public <V> EntitySpec<T> policySpecs(Iterable<? extends PolicySpec<?>> val) {
        this.checkMutable();
        this.policySpecs.addAll((Collection<PolicySpec<?>>)MutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(val, (Object)"policySpecs"))));
        return this;
    }

    public <V> EntitySpec<T> policies(Iterable<? extends Policy> val) {
        this.checkMutable();
        this.policies.addAll((Collection<Policy>)MutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(val, (Object)"policies"))));
        return this;
    }

    public <V> EntitySpec<T> enricher(Enricher val) {
        this.checkMutable();
        this.enrichers.add((Enricher)Preconditions.checkNotNull((Object)val, (Object)"enricher"));
        return this;
    }

    public <V> EntitySpec<T> enricher(EnricherSpec<?> val) {
        this.checkMutable();
        this.enricherSpecs.add((EnricherSpec<?>)Preconditions.checkNotNull(val, (Object)"enricherSpec"));
        return this;
    }

    public <V> EntitySpec<T> enricherSpecs(Iterable<? extends EnricherSpec<?>> val) {
        this.checkMutable();
        this.enricherSpecs.addAll((Collection<EnricherSpec<?>>)MutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(val, (Object)"enricherSpecs"))));
        return this;
    }

    public <V> EntitySpec<T> enrichers(Iterable<? extends Enricher> val) {
        this.checkMutable();
        this.enrichers.addAll((Collection<Enricher>)MutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(val, (Object)"enrichers"))));
        return this;
    }

    public <V> EntitySpec<T> location(Location val) {
        this.checkMutable();
        this.locations.add((Location)Preconditions.checkNotNull((Object)val, (Object)"location"));
        return this;
    }

    public <V> EntitySpec<T> locations(Iterable<? extends Location> val) {
        this.checkMutable();
        this.locations.addAll((Collection<Location>)MutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(val, (Object)"locations"))));
        return this;
    }

    public EntitySpec<T> immutable() {
        this.immutable = true;
        return this;
    }

    private void checkMutable() {
        if (this.immutable) {
            throw new IllegalStateException("Cannot modify immutable entity spec " + this);
        }
    }
}

