/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity;

import brooklyn.basic.BrooklynObject;
import brooklyn.config.ConfigKey;
import brooklyn.entity.Application;
import brooklyn.entity.Effector;
import brooklyn.entity.EntityType;
import brooklyn.entity.Feed;
import brooklyn.entity.Group;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.event.AttributeSensor;
import brooklyn.location.Location;
import brooklyn.management.Task;
import brooklyn.policy.Enricher;
import brooklyn.policy.EnricherSpec;
import brooklyn.policy.Policy;
import brooklyn.policy.PolicySpec;
import brooklyn.util.guava.Maybe;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface Entity
extends BrooklynObject {
    @Override
    public String getId();

    public long getCreationTime();

    @Override
    public String getDisplayName();

    @Nullable
    public String getIconUrl();

    public EntityType getEntityType();

    public Application getApplication();

    public String getApplicationId();

    public Entity getParent();

    public Collection<Entity> getChildren();

    public Entity setParent(Entity var1);

    public void clearParent();

    public <T extends Entity> T addChild(T var1);

    public <T extends Entity> T addChild(EntitySpec<T> var1);

    public boolean removeChild(Entity var1);

    public Collection<Policy> getPolicies();

    public Collection<Enricher> getEnrichers();

    public Collection<Group> getGroups();

    public void addGroup(Group var1);

    public void removeGroup(Group var1);

    public Collection<Location> getLocations();

    public <T> T getAttribute(AttributeSensor<T> var1);

    public <T> T getConfig(ConfigKey<T> var1);

    public <T> T getConfig(ConfigKey.HasConfigKey<T> var1);

    @Deprecated
    public Maybe<Object> getConfigRaw(ConfigKey<?> var1, boolean var2);

    @Deprecated
    public Maybe<Object> getConfigRaw(ConfigKey.HasConfigKey<?> var1, boolean var2);

    public <T> Task<T> invoke(Effector<T> var1, Map<String, ?> var2);

    public void addPolicy(Policy var1);

    public <T extends Policy> T addPolicy(PolicySpec<T> var1);

    public boolean removePolicy(Policy var1);

    public void addEnricher(Enricher var1);

    public <T extends Enricher> T addEnricher(EnricherSpec<T> var1);

    public boolean removeEnricher(Enricher var1);

    public <T extends Feed> T addFeed(T var1);

    @Deprecated
    public Set<Object> getTags();

    @Deprecated
    public boolean addTag(@Nonnull Object var1);

    @Deprecated
    public boolean removeTag(@Nonnull Object var1);

    @Deprecated
    public boolean containsTag(@Nonnull Object var1);
}

