/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.basic;

import brooklyn.basic.internal.ApiObjectsFactory;
import brooklyn.util.collections.MutableSet;
import brooklyn.util.exceptions.Exceptions;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.Set;

public abstract class AbstractBrooklynObjectSpec<T, K extends AbstractBrooklynObjectSpec<T, K>>
implements Serializable {
    private static final long serialVersionUID = 3010955277740333030L;
    private final Class<? extends T> type;
    private String displayName;
    private String catalogItemId;
    private Set<Object> tags = MutableSet.of();

    protected AbstractBrooklynObjectSpec(Class<? extends T> type) {
        this.checkValidType(type);
        this.type = type;
        this.catalogItemId = ApiObjectsFactory.get().getCatalogItemIdFromContext();
    }

    protected K self() {
        return (K)this;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("type", this.getType()).toString();
    }

    protected abstract void checkValidType(Class<? extends T> var1);

    public K displayName(String val) {
        this.displayName = val;
        return this.self();
    }

    public K catalogItemId(String val) {
        this.catalogItemId = val;
        return this.self();
    }

    public K tag(Object tag) {
        this.tags.add(tag);
        return this.self();
    }

    public K tags(Iterable<Object> tagsToAdd) {
        Iterables.addAll(this.tags, tagsToAdd);
        return this.self();
    }

    public Class<? extends T> getType() {
        return this.type;
    }

    public final String getDisplayName() {
        return this.displayName;
    }

    public final String getCatalogItemId() {
        return this.catalogItemId;
    }

    public final Set<Object> getTags() {
        return ImmutableSet.copyOf(this.tags);
    }

    protected final void checkIsNewStyleImplementation(Class<?> implClazz) {
        try {
            implClazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Implementation " + implClazz + " must have a no-argument constructor");
        }
        catch (SecurityException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        if (implClazz.isInterface()) {
            throw new IllegalStateException("Implementation " + implClazz + " is an interface, but must be a non-abstract class");
        }
        if (Modifier.isAbstract(implClazz.getModifiers())) {
            throw new IllegalStateException("Implementation " + implClazz + " is abstract, but must be a non-abstract class");
        }
    }

    protected final void checkIsImplementation(Class<?> val, Class<? super T> requiredInterface) {
        if (!requiredInterface.isAssignableFrom(val)) {
            throw new IllegalStateException("Implementation " + val + " does not implement " + requiredInterface.getName());
        }
        if (val.isInterface()) {
            throw new IllegalStateException("Implementation " + val + " is an interface, but must be a non-abstract class");
        }
        if (Modifier.isAbstract(val.getModifiers())) {
            throw new IllegalStateException("Implementation " + val + " is abstract, but must be a non-abstract class");
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        AbstractBrooklynObjectSpec other = (AbstractBrooklynObjectSpec)obj;
        if (!Objects.equal((Object)this.getDisplayName(), (Object)other.getDisplayName())) {
            return false;
        }
        if (!Objects.equal((Object)this.getCatalogItemId(), (Object)other.getCatalogItemId())) {
            return false;
        }
        if (!Objects.equal(this.getType(), other.getType())) {
            return false;
        }
        return Objects.equal(this.getTags(), other.getTags());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getCatalogItemId(), this.getDisplayName(), this.getType(), this.getTags()});
    }
}

