/*
 * Decompiled with CFR 0.152.
 */
package eu.seaclouds.modaclouds.dda;

import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.drivers.EntityDriver;
import brooklyn.entity.java.JavaSoftwareProcessSshDriver;
import brooklyn.event.AttributeSensor;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.net.Networking;
import brooklyn.util.os.Os;
import brooklyn.util.ssh.BashCommands;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import eu.seaclouds.modaclouds.dda.MODACloudsDeterministicDataAnalizerDriver;
import eu.seaclouds.modaclouds.dda.MODACloudsDeterministicDataAnalyzer;
import eu.seaclouds.modaclouds.dda.MODACloudsDeterministicDataAnalyzerImpl;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class MODACloudsDeterministicDataAnalizerSshDriver
extends JavaSoftwareProcessSshDriver
implements MODACloudsDeterministicDataAnalizerDriver {
    public MODACloudsDeterministicDataAnalizerSshDriver(MODACloudsDeterministicDataAnalyzerImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
    }

    protected String getLogFileLocation() {
        return Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "console.out"});
    }

    public void preInstall() {
        this.resolver = Entities.newDownloader((EntityDriver)this);
        this.setExpandedInstallDir(Os.mergePaths((String[])new String[]{this.getInstallDir(), this.resolver.getUnpackedDirectoryName(String.format("rsp-services-csparql-%s-modaclouds", this.getVersion()))}));
    }

    public void install() {
        List urls = this.resolver.getTargets();
        String saveAs = this.resolver.getFilename();
        ImmutableList commands = ImmutableList.builder().addAll((Iterable)BashCommands.commandsToDownloadUrlsAs((List)urls, (String)saveAs)).add((Object)BashCommands.INSTALL_TAR).add((Object)("tar xzfv " + saveAs)).build();
        this.newScript((String)"installing").body.append((Collection)commands).execute();
    }

    public void customize() {
        log.debug("Customizing {}", (Object)this.entity);
        Networking.checkPortsValid((Map)MutableMap.of((Object)"modacloudsDdaPort", (Object)this.getPort()));
        this.newScript((String)"customizing").body.append(new CharSequence[]{String.format("cp -R %s/* .", this.getExpandedInstallDir()), String.format("mkdir %s/modaclouds-dda", this.getRunDir())}).execute();
    }

    public String getPidFile() {
        return Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "modaclouds-dda.pid"});
    }

    public void launch() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), (String)"launching").failOnNonZeroResultCode().body.append((CharSequence)String.format("nohup java -jar rsp-services-csparql.jar > %s 2>&1 &", this.getLogFileLocation())).execute();
        String mainUri = String.format("http://%s:%d", this.entity.getAttribute(Attributes.HOSTNAME), this.entity.getAttribute((AttributeSensor)MODACloudsDeterministicDataAnalyzer.MODACLOUDS_DDA_PORT));
        this.entity.setAttribute(Attributes.MAIN_URI, (Object)URI.create(mainUri));
    }

    public boolean isRunning() {
        return this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), "check-running").execute() == 0;
    }

    public void stop() {
        this.newScript((Map)ImmutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), "stopping").execute();
    }

    @Override
    public Integer getPort() {
        return (Integer)this.entity.getAttribute((AttributeSensor)MODACloudsDeterministicDataAnalyzer.MODACLOUDS_DDA_PORT);
    }
}

