/*
 * Decompiled with CFR 0.152.
 */
package eu.seaclouds.dashboard;

import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.drivers.EntityDriver;
import brooklyn.entity.java.JavaSoftwareProcessSshDriver;
import brooklyn.event.AttributeSensor;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.net.Networking;
import brooklyn.util.net.Urls;
import brooklyn.util.os.Os;
import brooklyn.util.ssh.BashCommands;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import eu.seaclouds.dashboard.SeacloudsDashboard;
import eu.seaclouds.dashboard.SeacloudsDashboardDriver;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class SeacloudsDashboardSshDriver
extends JavaSoftwareProcessSshDriver
implements SeacloudsDashboardDriver {
    public SeacloudsDashboardSshDriver(EntityLocal entity, SshMachineLocation machine) {
        super(entity, machine);
    }

    protected String getLogFileLocation() {
        return Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "console.out"});
    }

    public void preInstall() {
        this.resolver = Entities.newDownloader((EntityDriver)this);
        this.setExpandedInstallDir(Os.mergePaths((String[])new String[]{this.getInstallDir(), this.resolver.getUnpackedDirectoryName(String.format("dashboard-%s", this.getVersion()))}));
    }

    public void install() {
        List urls = this.resolver.getTargets();
        String saveAs = this.resolver.getFilename();
        ImmutableList commands = ImmutableList.builder().addAll((Iterable)BashCommands.commandsToDownloadUrlsAs((List)urls, (String)saveAs)).build();
        this.newScript((String)"installing").body.append((Collection)commands).execute();
    }

    public void customize() {
        log.debug("Customizing {}", (Object)this.entity);
        Networking.checkPortsValid((Map)MutableMap.of((Object)"dashboardPort", (Object)this.getPort()));
        this.newScript((String)"customizing").body.append(new CharSequence[]{String.format("cp -R %s/* .", this.getInstallDir()), String.format("mkdir %s/seaclouds-dashboard", this.getRunDir())}).execute();
        this.copyTemplate((String)this.entity.getConfig(SeacloudsDashboard.CONFIG_URL), this.getConfigFileLocation());
    }

    public void launch() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), (String)"launching").failOnNonZeroResultCode().body.append((CharSequence)this.getCommand()).execute();
        String mainUri = String.format("http://%s:%d", this.entity.getAttribute(Attributes.HOSTNAME), this.entity.getAttribute((AttributeSensor)SeacloudsDashboard.DASHBOARD_PORT));
        this.entity.setAttribute(Attributes.MAIN_URI, (Object)URI.create(mainUri));
    }

    private String getCommand() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("nohup java -jar dashboard.jar server " + this.getFinalConfigName() + " > %s 2>&1 &", this.getLogFileLocation()));
        return sb.toString();
    }

    public String getPidFile() {
        return Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "seaclouds-dashboard.pid"});
    }

    public boolean isRunning() {
        return this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), "check-running").execute() == 0;
    }

    public void stop() {
        this.newScript((Map)ImmutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), "stopping").execute();
    }

    @Override
    public Integer getPort() {
        return (Integer)this.entity.getAttribute((AttributeSensor)SeacloudsDashboard.DASHBOARD_PORT);
    }

    protected String getConfigFileLocation() {
        return Urls.mergePaths((String[])new String[]{this.getRunDir(), this.getFinalConfigName()});
    }

    protected String getFinalConfigName() {
        return (String)this.entity.getConfig(SeacloudsDashboard.FINAL_CONFIG_NAME);
    }
}

