/*
 * Decompiled with CFR 0.152.
 */
package io.brooklyn.camp.brooklyn.spi.dsl.methods;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.EntityPredicates;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.event.basic.DependentConfiguration;
import brooklyn.event.basic.Sensors;
import brooklyn.management.Task;
import brooklyn.management.internal.EntityManagerInternal;
import brooklyn.util.guava.Maybe;
import brooklyn.util.task.TaskBuilder;
import brooklyn.util.task.Tasks;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.brooklyn.camp.brooklyn.BrooklynCampConstants;
import io.brooklyn.camp.brooklyn.spi.dsl.BrooklynDslDeferredSupplier;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;

public class DslComponent
extends BrooklynDslDeferredSupplier<Entity> {
    private static final long serialVersionUID = -7715984495268724954L;
    private final String componentId;
    private final DslComponent scopeComponent;
    private final Scope scope;

    public DslComponent(String componentId) {
        this(Scope.GLOBAL, componentId);
    }

    public DslComponent(Scope scope, String componentId) {
        this(null, scope, componentId);
    }

    public DslComponent(DslComponent scopeComponent, Scope scope, String componentId) {
        Preconditions.checkNotNull((Object)((Object)scope), (Object)"scope");
        this.scopeComponent = scopeComponent;
        this.componentId = componentId;
        this.scope = scope;
    }

    @Override
    public Task<Entity> newTask() {
        return TaskBuilder.builder().name("component(" + this.componentId + ")").body((Callable)new EntityInScopeFinder(this.scopeComponent, this.scope, this.componentId)).build();
    }

    public DslComponent entity(String scopeOrId) {
        return new DslComponent(this, Scope.GLOBAL, scopeOrId);
    }

    public DslComponent child(String scopeOrId) {
        return new DslComponent(this, Scope.CHILD, scopeOrId);
    }

    public DslComponent sibling(String scopeOrId) {
        return new DslComponent(this, Scope.SIBLING, scopeOrId);
    }

    public DslComponent descendant(String scopeOrId) {
        return new DslComponent(this, Scope.DESCENDANT, scopeOrId);
    }

    public DslComponent ancestor(String scopeOrId) {
        return new DslComponent(this, Scope.ANCESTOR, scopeOrId);
    }

    @Deprecated
    public DslComponent component(String scopeOrId) {
        return new DslComponent(this, Scope.GLOBAL, scopeOrId);
    }

    public DslComponent parent() {
        return new DslComponent(this, Scope.PARENT, "");
    }

    public DslComponent component(String scope, String id) {
        if (!Scope.isValid(scope)) {
            throw new IllegalArgumentException(scope + " is not a vlaid scope");
        }
        return new DslComponent(this, Scope.fromString(scope), id);
    }

    public BrooklynDslDeferredSupplier<?> attributeWhenReady(String sensorName) {
        return new AttributeWhenReady(this, sensorName);
    }

    public BrooklynDslDeferredSupplier<?> config(String keyName) {
        return new DslConfigSupplier(this, keyName);
    }

    public BrooklynDslDeferredSupplier<Sensor<?>> sensor(String sensorName) {
        return new DslSensorSupplier(this, sensorName);
    }

    public String toString() {
        return "$brooklyn:component(" + (this.scopeComponent == null ? "" : this.scopeComponent + ", ") + (this.scope == Scope.GLOBAL ? "" : (Object)((Object)this.scope) + ", ") + this.componentId + ")";
    }

    public static enum Scope {
        GLOBAL("global"),
        CHILD("child"),
        PARENT("parent"),
        SIBLING("sibling"),
        DESCENDANT("descendant"),
        ANCESTOR("ancestor"),
        THIS("this");

        public static final Set<Scope> VALUES;
        private final String name;

        private Scope(String name) {
            this.name = name;
        }

        public static Scope fromString(String name) {
            return (Scope)((Object)Scope.tryFromString(name).get());
        }

        public static Maybe<Scope> tryFromString(String name) {
            for (Scope scope : VALUES) {
                if (!scope.name.toLowerCase().equals(name.toLowerCase())) continue;
                return Maybe.of((Object)((Object)scope));
            }
            return Maybe.absent((Throwable)new IllegalArgumentException(name + " is not a valid scope"));
        }

        public static boolean isValid(String name) {
            for (Scope scope : VALUES) {
                if (!scope.name.toLowerCase().equals(name.toLowerCase())) continue;
                return true;
            }
            return false;
        }

        static {
            VALUES = ImmutableSet.of((Object)((Object)GLOBAL), (Object)((Object)CHILD), (Object)((Object)PARENT), (Object)((Object)SIBLING), (Object)((Object)DESCENDANT), (Object)((Object)ANCESTOR), (Object[])new Scope[]{THIS});
        }
    }

    protected static final class DslSensorSupplier
    extends BrooklynDslDeferredSupplier<Sensor<?>> {
        private final DslComponent component;
        private final String sensorName;
        private static final long serialVersionUID = -4735177561947722511L;

        public DslSensorSupplier(DslComponent component, String sensorName) {
            this.component = (DslComponent)Preconditions.checkNotNull((Object)component);
            this.sensorName = sensorName;
        }

        @Override
        public Task<Sensor<?>> newTask() {
            return Tasks.builder().name("looking up sensor for " + this.sensorName).dynamic(false).body(new Callable<Sensor<?>>(){

                @Override
                public Sensor<?> call() throws Exception {
                    Entity targetEntity = (Entity)DslSensorSupplier.this.component.get();
                    Sensor result = null;
                    if (targetEntity != null) {
                        result = targetEntity.getEntityType().getSensor(DslSensorSupplier.this.sensorName);
                    }
                    if (result != null) {
                        return result;
                    }
                    return Sensors.newSensor(Object.class, (String)DslSensorSupplier.this.sensorName);
                }
            }).build();
        }

        public String toString() {
            return this.component.toString() + "." + "sensor(" + this.sensorName + ")";
        }
    }

    protected static final class DslConfigSupplier
    extends BrooklynDslDeferredSupplier<Object> {
        private final DslComponent component;
        private final String keyName;
        private static final long serialVersionUID = -4735177561947722511L;

        public DslConfigSupplier(DslComponent component, String keyName) {
            this.component = (DslComponent)Preconditions.checkNotNull((Object)component);
            this.keyName = keyName;
        }

        @Override
        public Task<Object> newTask() {
            return Tasks.builder().name("retrieving config for " + this.keyName).dynamic(false).body((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Entity targetEntity = (Entity)DslConfigSupplier.this.component.get();
                    return targetEntity.getConfig(ConfigKeys.newConfigKey(Object.class, (String)DslConfigSupplier.this.keyName));
                }
            }).build();
        }

        public String toString() {
            return this.component.toString() + "." + "config(" + this.keyName + ")";
        }
    }

    protected static class AttributeWhenReady
    extends BrooklynDslDeferredSupplier<Object> {
        private static final long serialVersionUID = 1740899524088902383L;
        private final DslComponent component;
        private final String sensorName;

        public AttributeWhenReady(DslComponent component, String sensorName) {
            this.component = (DslComponent)Preconditions.checkNotNull((Object)component);
            this.sensorName = sensorName;
        }

        @Override
        public Task<Object> newTask() {
            Entity targetEntity = (Entity)this.component.get();
            Sensor targetSensor = targetEntity.getEntityType().getSensor(this.sensorName);
            if (!(targetSensor instanceof AttributeSensor)) {
                targetSensor = Sensors.newSensor(Object.class, (String)this.sensorName);
            }
            return DependentConfiguration.attributeWhenReady((Entity)targetEntity, (AttributeSensor)((AttributeSensor)targetSensor));
        }

        public String toString() {
            return this.component.toString() + "." + "attributeWhenReady(" + this.sensorName + ")";
        }
    }

    protected static class EntityInScopeFinder
    implements Callable<Entity> {
        protected final DslComponent scopeComponent;
        protected final Scope scope;
        protected final String componentId;

        public EntityInScopeFinder(DslComponent scopeComponent, Scope scope, String componentId) {
            this.scopeComponent = scopeComponent;
            this.scope = scope;
            this.componentId = componentId;
        }

        protected EntityInternal getEntity() {
            if (this.scopeComponent != null) {
                return (EntityInternal)this.scopeComponent.get();
            }
            return DslComponent.entity();
        }

        @Override
        public Entity call() throws Exception {
            Iterable entitiesToSearch = null;
            switch (this.scope) {
                case THIS: {
                    return this.getEntity();
                }
                case PARENT: {
                    return this.getEntity().getParent();
                }
                case GLOBAL: {
                    entitiesToSearch = ((EntityManagerInternal)this.getEntity().getManagementContext().getEntityManager()).getAllEntitiesInApplication(DslComponent.entity().getApplication());
                    break;
                }
                case DESCENDANT: {
                    entitiesToSearch = Entities.descendants((Entity)this.getEntity());
                    break;
                }
                case ANCESTOR: {
                    entitiesToSearch = Entities.ancestors((Entity)this.getEntity());
                    break;
                }
                case SIBLING: {
                    entitiesToSearch = this.getEntity().getParent().getChildren();
                    break;
                }
                case CHILD: {
                    entitiesToSearch = this.getEntity().getChildren();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected scope " + (Object)((Object)this.scope));
                }
            }
            Optional result = Iterables.tryFind((Iterable)entitiesToSearch, (Predicate)EntityPredicates.configEqualTo(BrooklynCampConstants.PLAN_ID, (Object)this.componentId));
            if (result.isPresent()) {
                return (Entity)result.get();
            }
            throw new NoSuchElementException("No entity matching id " + this.componentId + (this.scope == Scope.GLOBAL ? "" : ", in scope " + (Object)((Object)this.scope) + " wrt " + this.getEntity() + (this.scopeComponent != null ? " (" + this.scopeComponent + " from " + DslComponent.entity() + ")" : "")));
        }
    }
}

