/*
 * Decompiled with CFR 0.152.
 */
package io.brooklyn.camp.brooklyn.spi.dsl.methods;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.EntityDynamicType;
import brooklyn.entity.trait.Configurable;
import brooklyn.event.Sensor;
import brooklyn.event.basic.DependentConfiguration;
import brooklyn.management.Task;
import brooklyn.management.TaskAdaptable;
import brooklyn.management.TaskFactory;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.flags.ClassCoercionException;
import brooklyn.util.flags.FlagUtils;
import brooklyn.util.flags.TypeCoercions;
import brooklyn.util.javalang.Reflections;
import brooklyn.util.task.DeferredSupplier;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.brooklyn.camp.brooklyn.spi.creation.BrooklynYamlTypeInstantiator;
import io.brooklyn.camp.brooklyn.spi.creation.EntitySpecConfiguration;
import io.brooklyn.camp.brooklyn.spi.dsl.BrooklynDslDeferredSupplier;
import io.brooklyn.camp.brooklyn.spi.dsl.DslUtils;
import io.brooklyn.camp.brooklyn.spi.dsl.methods.DslComponent;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;

public class BrooklynDslCommon {
    public static DslComponent entity(String scopeOrId) {
        return new DslComponent(DslComponent.Scope.GLOBAL, scopeOrId);
    }

    public static DslComponent parent() {
        return new DslComponent(DslComponent.Scope.PARENT, null);
    }

    public static DslComponent child(String scopeOrId) {
        return new DslComponent(DslComponent.Scope.CHILD, scopeOrId);
    }

    public static DslComponent sibling(String scopeOrId) {
        return new DslComponent(DslComponent.Scope.SIBLING, scopeOrId);
    }

    public static DslComponent descendant(String scopeOrId) {
        return new DslComponent(DslComponent.Scope.DESCENDANT, scopeOrId);
    }

    public static DslComponent ancestor(String scopeOrId) {
        return new DslComponent(DslComponent.Scope.ANCESTOR, scopeOrId);
    }

    public static DslComponent component(String scopeOrId) {
        return BrooklynDslCommon.component("global", scopeOrId);
    }

    public static DslComponent component(String scope, String id) {
        if (!DslComponent.Scope.isValid(scope)) {
            throw new IllegalArgumentException(scope + " is not a valid scope");
        }
        return new DslComponent(DslComponent.Scope.fromString(scope), id);
    }

    public static BrooklynDslDeferredSupplier<?> config(String keyName) {
        return new DslComponent(DslComponent.Scope.THIS, "").config(keyName);
    }

    public static BrooklynDslDeferredSupplier<?> attributeWhenReady(String sensorName) {
        return new DslComponent(DslComponent.Scope.THIS, "").attributeWhenReady(sensorName);
    }

    public static BrooklynDslDeferredSupplier<Sensor<?>> sensor(String sensorName) {
        return new DslComponent(DslComponent.Scope.THIS, "").sensor(sensorName);
    }

    public static Sensor<?> sensor(String clazzName, String sensorName) {
        try {
            Sensor sensor;
            Class<?> clazz = Class.forName(clazzName);
            if (Entity.class.isAssignableFrom(clazz)) {
                sensor = new EntityDynamicType(clazz).getSensor(sensorName);
            } else {
                Map sensors = EntityDynamicType.findSensors(clazz, null);
                sensor = (Sensor)sensors.get(sensorName);
            }
            if (sensor == null) {
                throw new IllegalArgumentException("Sensor " + sensorName + " not found on class " + clazzName);
            }
            return sensor;
        }
        catch (ClassNotFoundException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public static EntitySpecConfiguration entitySpec(Map<String, Object> arguments) {
        return new EntitySpecConfiguration(arguments);
    }

    public static Object object(Map<String, Object> arguments) {
        ConfigBag config = ConfigBag.newInstance(arguments);
        String typeName = (String)BrooklynYamlTypeInstantiator.InstantiatorFromKey.extractTypeName("object", config).orNull();
        Map objectFields = (Map)config.getStringKeyMaybe("object.fields").or((Object)MutableMap.of());
        Map brooklynConfig = (Map)config.getStringKeyMaybe("brooklyn.config").or((Object)MutableMap.of());
        try {
            Class<?> type = Class.forName(typeName);
            if (!Reflections.hasNoArgConstructor(type)) {
                throw new IllegalStateException(String.format("Cannot construct %s bean: No public no-arg constructor available", type));
            }
            if ((objectFields.isEmpty() || DslUtils.resolved(objectFields.values())) && (brooklynConfig.isEmpty() || DslUtils.resolved(brooklynConfig.values()))) {
                return DslObject.create(type, objectFields, brooklynConfig);
            }
            return new DslObject(type, objectFields, brooklynConfig);
        }
        catch (ClassNotFoundException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public static Object literal(Object expression) {
        return expression;
    }

    public static Object formatString(String pattern, Object ... args) {
        if (DslUtils.resolved(args)) {
            return String.format(pattern, args);
        }
        return new DslFormatString(pattern, args);
    }

    protected static class DslObject
    extends BrooklynDslDeferredSupplier<Object> {
        private static final long serialVersionUID = 8878388748085419L;
        private Class<?> type;
        private Map<String, Object> fields;
        private Map<String, Object> config;

        public DslObject(Class<?> type, Map<String, Object> fields, Map<String, Object> config) {
            this.type = type;
            this.fields = MutableMap.copyOf(fields);
            this.config = MutableMap.copyOf(config);
        }

        @Override
        public Task<Object> newTask() {
            LinkedList tasks = Lists.newLinkedList();
            for (Object value : Iterables.concat(this.fields.values(), this.config.values())) {
                if (value instanceof TaskAdaptable) {
                    tasks.add((TaskAdaptable)value);
                    continue;
                }
                if (!(value instanceof TaskFactory)) continue;
                tasks.add(((TaskFactory)value).newTask());
            }
            MutableMap flags = MutableMap.of((Object)"displayName", (Object)("building '" + this.type + "' with " + tasks.size() + " task" + (tasks.size() != 1 ? "s" : "")));
            return DependentConfiguration.transformMultiple((Map)flags, (Function)new Function<List<Object>, Object>(){

                public Object apply(List<Object> input) {
                    Object value;
                    Iterator<Object> values = input.iterator();
                    for (String name : DslObject.this.fields.keySet()) {
                        value = DslObject.this.fields.get(name);
                        if (value instanceof TaskAdaptable || value instanceof TaskFactory) {
                            DslObject.this.fields.put(name, values.next());
                            continue;
                        }
                        if (!(value instanceof DeferredSupplier)) continue;
                        DslObject.this.fields.put(name, ((DeferredSupplier)value).get());
                    }
                    for (String name : DslObject.this.config.keySet()) {
                        value = DslObject.this.config.get(name);
                        if (value instanceof TaskAdaptable || value instanceof TaskFactory) {
                            DslObject.this.config.put(name, values.next());
                            continue;
                        }
                        if (!(value instanceof DeferredSupplier)) continue;
                        DslObject.this.config.put(name, ((DeferredSupplier)value).get());
                    }
                    return DslObject.create(DslObject.this.type, DslObject.this.fields, DslObject.this.config);
                }
            }, (Collection)tasks);
        }

        public static <T> T create(Class<T> type, Map<String, ?> fields, Map<String, ?> config) {
            try {
                Object bean;
                try {
                    bean = TypeCoercions.coerce(fields, type);
                }
                catch (ClassCoercionException ex) {
                    bean = Reflections.invokeConstructorWithArgs(type, (Object[])new Object[0]).get();
                    BeanUtils.populate((Object)bean, fields);
                }
                if (bean instanceof Configurable && config.size() > 0) {
                    ConfigBag brooklyn = ConfigBag.newInstance(config);
                    FlagUtils.setFieldsFromFlags((Object)bean, (ConfigBag)brooklyn);
                    FlagUtils.setAllConfigKeys((Configurable)((Configurable)bean), (ConfigBag)brooklyn, (boolean)true);
                }
                return (T)bean;
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }

        public String toString() {
            return "$brooklyn:object(" + this.type + ")";
        }
    }

    @Deprecated
    protected static class FormatString
    extends DslFormatString {
        public FormatString(String pattern, Object[] args) {
            super(pattern, args);
        }
    }

    protected static class DslFormatString
    extends BrooklynDslDeferredSupplier<String> {
        private static final long serialVersionUID = -4849297712650560863L;
        private String pattern;
        private Object[] args;

        public DslFormatString(String pattern, Object ... args) {
            this.pattern = pattern;
            this.args = args;
        }

        @Override
        public Task<String> newTask() {
            return DependentConfiguration.formatString((String)this.pattern, (Object[])this.args);
        }

        public String toString() {
            return "$brooklyn:formatString(" + this.pattern + ")";
        }
    }
}

