/*
 * Decompiled with CFR 0.152.
 */
package io.brooklyn.camp.brooklyn.spi.dsl;

import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.javalang.Reflections;
import brooklyn.util.text.Strings;
import com.google.common.base.Optional;
import io.brooklyn.camp.brooklyn.spi.dsl.methods.BrooklynDslCommon;
import io.brooklyn.camp.brooklyn.spi.dsl.parse.DslParser;
import io.brooklyn.camp.brooklyn.spi.dsl.parse.FunctionWithArgs;
import io.brooklyn.camp.brooklyn.spi.dsl.parse.QuotedString;
import io.brooklyn.camp.spi.resolve.PlanInterpreter;
import io.brooklyn.camp.spi.resolve.interpret.PlanInterpretationNode;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynDslInterpreter
extends PlanInterpreter.PlanInterpreterAdapter {
    private static final Logger log = LoggerFactory.getLogger(BrooklynDslInterpreter.class);
    private static ThreadLocal<PlanInterpretationNode> currentNode = new ThreadLocal();

    public boolean isInterestedIn(PlanInterpretationNode node) {
        return node.matchesPrefix("$brooklyn:") || node.getNewValue() instanceof FunctionWithArgs;
    }

    public static PlanInterpretationNode currentNode() {
        return currentNode.get();
    }

    public static void currentNode(PlanInterpretationNode node) {
        currentNode.set(node);
    }

    public static void currentNodeClear() {
        currentNode.set(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void applyYamlPrimitive(PlanInterpretationNode node) {
        String expression = node.getNewValue().toString();
        try {
            currentNode.set(node);
            Object parsedNode = new DslParser(expression).parse();
            if (parsedNode instanceof FunctionWithArgs && ((FunctionWithArgs)parsedNode).getArgs() == null) {
                if (node.getRoleInParent() != PlanInterpretationNode.Role.MAP_KEY) throw new IllegalStateException("Invalid function-only expression '" + ((FunctionWithArgs)parsedNode).getFunction() + "'");
                node.setNewValue(parsedNode);
                return;
            } else {
                node.setNewValue(this.evaluate(parsedNode, true));
            }
            return;
        }
        catch (Exception e) {
            log.warn("Error evaluating node (rethrowing) '" + expression + "': " + e);
            Exceptions.propagateIfFatal((Throwable)e);
            throw new IllegalArgumentException("Error evaluating node '" + expression + "'", e);
        }
        finally {
            BrooklynDslInterpreter.currentNodeClear();
        }
    }

    public boolean applyMapEntry(PlanInterpretationNode node, Map<Object, Object> mapIn, Map<Object, Object> mapOut, PlanInterpretationNode key, PlanInterpretationNode value) {
        if (key.getNewValue() instanceof FunctionWithArgs) {
            try {
                currentNode.set(node);
                FunctionWithArgs f = (FunctionWithArgs)key.getNewValue();
                if (f.getArgs() != null) {
                    throw new IllegalStateException("Invalid map key function " + f.getFunction() + "; should not have arguments if taking arguments from map");
                }
                ArrayList<Object> args = new ArrayList<Object>();
                if (value.getNewValue() instanceof Iterable) {
                    for (Object vi : (Iterable)value.getNewValue()) {
                        args.add(vi);
                    }
                } else {
                    args.add(value.getNewValue());
                }
                try {
                    if (mapIn.size() != 1) {
                        throw new IllegalStateException("Map-entry DSL syntax only supported with single item in map, not " + mapIn);
                    }
                    if (mapOut.size() != 0) {
                        throw new IllegalStateException("Map-entry DSL syntax only supported with empty output map-so-far, not " + mapOut);
                    }
                    node.setNewValue(this.evaluate(new FunctionWithArgs(f.getFunction(), args), false));
                    boolean i$ = false;
                    return i$;
                }
                catch (Exception e) {
                    log.warn("Error evaluating map-entry (rethrowing) '" + f.getFunction() + args + "': " + e);
                    Exceptions.propagateIfFatal((Throwable)e);
                    throw new IllegalArgumentException("Error evaluating map-entry '" + f.getFunction() + args + "'", e);
                }
            }
            finally {
                BrooklynDslInterpreter.currentNodeClear();
            }
        }
        return super.applyMapEntry(node, mapIn, mapOut, key, value);
    }

    public Object evaluate(Object f, boolean deepEvaluation) {
        if (f instanceof FunctionWithArgs) {
            return this.evaluateOn(BrooklynDslCommon.class, (FunctionWithArgs)f, deepEvaluation);
        }
        if (f instanceof List) {
            Object o = BrooklynDslCommon.class;
            for (Object i : (List)f) {
                o = this.evaluateOn(o, (FunctionWithArgs)i, deepEvaluation);
            }
            return o;
        }
        if (f instanceof QuotedString) {
            return ((QuotedString)f).unwrapped();
        }
        throw new IllegalArgumentException("Unexpected element in parse tree: '" + f + "' (type " + (f != null ? f.getClass() : null) + ")");
    }

    public Object evaluateOn(Object o, FunctionWithArgs f, boolean deepEvaluation) {
        if (f.getArgs() == null) {
            throw new IllegalStateException("Invalid function-only expression '" + f.getFunction() + "'");
        }
        Class<?> clazz = o instanceof Class ? (Class<?>)o : o.getClass();
        if (!clazz.getPackage().getName().startsWith(BrooklynDslCommon.class.getPackage().getName())) {
            throw new IllegalArgumentException("Not permitted to invoke function on '" + clazz + "' (outside allowed package scope)");
        }
        String fn = f.getFunction();
        fn = Strings.removeFromStart((String)fn, (String)"$brooklyn:");
        try {
            ArrayList<Object> args = new ArrayList<Object>();
            for (Object arg : f.getArgs()) {
                args.add(deepEvaluation ? this.evaluate(arg, true) : arg);
            }
            Optional v = Reflections.invokeMethodWithArgs((Object)o, (String)fn, args);
            if (v.isPresent()) {
                return v.get();
            }
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            throw Exceptions.propagate((Throwable)new InvocationTargetException(e, "Error invoking '" + fn + "' on '" + o + "'"));
        }
        throw new IllegalArgumentException("No such function '" + fn + "' on " + o);
    }
}

