/*
 * Decompiled with CFR 0.152.
 */
package io.brooklyn.camp.brooklyn.spi.creation.service;

import brooklyn.entity.basic.VanillaSoftwareProcess;
import brooklyn.entity.brooklynnode.BrooklynNode;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.entity.group.DynamicRegionsFabric;
import brooklyn.entity.java.VanillaJavaApp;
import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import com.google.common.collect.ImmutableMap;
import io.brooklyn.camp.brooklyn.spi.creation.service.BrooklynServiceTypeResolver;
import io.brooklyn.camp.brooklyn.spi.creation.service.ServiceTypeResolver;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogServiceTypeResolver
extends BrooklynServiceTypeResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceTypeResolver.class);
    private static final Map<String, String> CATALOG_TYPES = ImmutableMap.builder().put((Object)"cluster", (Object)DynamicCluster.class.getName()).put((Object)"fabric", (Object)DynamicRegionsFabric.class.getName()).put((Object)"vanilla", (Object)VanillaSoftwareProcess.class.getName()).put((Object)"software-process", (Object)VanillaSoftwareProcess.class.getName()).put((Object)"java-app", (Object)VanillaJavaApp.class.getName()).put((Object)"brooklyn-node", (Object)BrooklynNode.class.getName()).put((Object)"web-app-cluster", (Object)"brooklyn.entity.webapp.ControlledDynamicWebAppCluster").build();
    private static final Converter<String, String> FMT = CaseFormat.LOWER_HYPHEN.converterTo(CaseFormat.UPPER_CAMEL);

    @Override
    public String getTypePrefix() {
        return "catalog";
    }

    @Override
    public String getBrooklynType(String serviceType) {
        String type = super.getBrooklynType(serviceType);
        if (type == null) {
            return null;
        }
        for (String check : CATALOG_TYPES.keySet()) {
            if (!type.equals(check) && !type.equals(FMT.convert((Object)check))) continue;
            return CATALOG_TYPES.get(check);
        }
        return type;
    }
}

