/*
 * Decompiled with CFR 0.152.
 */
package io.brooklyn.camp.brooklyn.spi.creation.service;

import brooklyn.catalog.CatalogItem;
import brooklyn.catalog.internal.CatalogUtils;
import brooklyn.entity.Entity;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.management.ManagementContext;
import brooklyn.util.text.Strings;
import io.brooklyn.camp.brooklyn.spi.creation.BrooklynComponentTemplateResolver;
import io.brooklyn.camp.brooklyn.spi.creation.BrooklynEntityDecorationResolver;
import io.brooklyn.camp.brooklyn.spi.creation.service.ServiceTypeResolver;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynServiceTypeResolver
implements ServiceTypeResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceTypeResolver.class);

    @Override
    public String getTypePrefix() {
        return "brooklyn";
    }

    @Override
    public String getBrooklynType(String serviceType) {
        String type = Strings.removeFromStart((String)serviceType, (String)(this.getTypePrefix() + ":")).trim();
        if (type == null) {
            return null;
        }
        return type;
    }

    @Override
    @Nullable
    public CatalogItem<Entity, EntitySpec<?>> getCatalogItem(BrooklynComponentTemplateResolver resolver, String serviceType) {
        String type = this.getBrooklynType(serviceType);
        if (type != null) {
            return CatalogUtils.getCatalogItemOptionalVersion((ManagementContext)resolver.getManagementContext(), Entity.class, (String)type);
        }
        return null;
    }

    @Override
    public <T extends Entity> void decorateSpec(BrooklynComponentTemplateResolver resolver, EntitySpec<T> spec) {
        new BrooklynEntityDecorationResolver.PolicySpecResolver(resolver.getYamlLoader()).decorate(spec, resolver.getAttrs());
        new BrooklynEntityDecorationResolver.EnricherSpecResolver(resolver.getYamlLoader()).decorate(spec, resolver.getAttrs());
        new BrooklynEntityDecorationResolver.InitializerResolver(resolver.getYamlLoader()).decorate(spec, resolver.getAttrs());
    }
}

