/*
 * Decompiled with CFR 0.152.
 */
package io.brooklyn.camp.brooklyn.spi.creation;

import brooklyn.location.Location;
import brooklyn.location.LocationDefinition;
import brooklyn.management.ManagementContext;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.guava.Maybe;
import brooklyn.util.text.Strings;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class BrooklynYamlLocationResolver {
    protected final ManagementContext mgmt;

    public BrooklynYamlLocationResolver(ManagementContext bmc) {
        this.mgmt = bmc;
    }

    public List<Location> resolveLocations(Map<? super String, ?> attrs, boolean removeUsedAttributes) {
        Object location = attrs.get("location");
        Object locations = attrs.get("locations");
        if (location == null && locations == null) {
            return null;
        }
        Location locationFromString = null;
        List<Location> locationsFromList = null;
        if (location != null) {
            if (location instanceof String) {
                locationFromString = this.resolveLocationFromString((String)location);
            } else if (location instanceof Map) {
                locationFromString = this.resolveLocationFromMap((Map)location);
            } else {
                throw new IllegalStateException("Illegal parameter for 'location'; must be a string or map (but got " + location + ")");
            }
        }
        if (locations != null) {
            if (!(locations instanceof Iterable)) {
                throw new IllegalStateException("Illegal parameter for 'locations'; must be an iterable (but got " + locations + ")");
            }
            locationsFromList = this.resolveLocations((Iterable)locations);
        }
        if (locationFromString != null && locationsFromList != null) {
            if (locationsFromList.size() != 1) {
                throw new IllegalStateException("Conflicting 'location' and 'locations' (" + location + " and " + locations + "); " + "if both are supplied the list must have exactly one element being the same");
            }
            if (!locationFromString.equals(Iterables.getOnlyElement(locationsFromList))) {
                throw new IllegalStateException("Conflicting 'location' and 'locations' (" + location + " and " + locations + "); " + "different location specified in each");
            }
        } else if (locationFromString != null) {
            locationsFromList = Arrays.asList(locationFromString);
        }
        return locationsFromList;
    }

    public List<Location> resolveLocations(Iterable<Object> locations) {
        MutableList result = MutableList.of();
        for (Object l : locations) {
            Location ll = this.resolveLocation(l);
            if (ll == null) continue;
            result.add(ll);
        }
        return result;
    }

    public Location resolveLocation(Object location) {
        if (location instanceof String) {
            return this.resolveLocationFromString((String)location);
        }
        if (location instanceof Map) {
            return this.resolveLocationFromMap((Map)location);
        }
        throw new IllegalStateException("Illegal parameter for 'location' (" + location + "); must be a string or map");
    }

    public Location resolveLocationFromString(String location) {
        if (Strings.isBlank((CharSequence)location)) {
            return null;
        }
        return this.resolveLocation(location, (Map<?, ?>)MutableMap.of());
    }

    public Location resolveLocationFromMap(Map<?, ?> location) {
        if (location.size() > 1) {
            throw new IllegalStateException("Illegal parameter for 'location'; expected a single entry in map (" + location + ")");
        }
        Object key = Iterables.getOnlyElement(location.keySet());
        Object value = location.get(key);
        if (!(key instanceof String)) {
            throw new IllegalStateException("Illegal parameter for 'location'; expected String key (" + location + ")");
        }
        if (!(value instanceof Map)) {
            throw new IllegalStateException("Illegal parameter for 'location'; expected config map (" + location + ")");
        }
        return this.resolveLocation((String)key, (Map)value);
    }

    protected Location resolveLocation(String spec, Map<?, ?> flags) {
        LocationDefinition ldef = this.mgmt.getLocationRegistry().getDefinedLocationByName(spec);
        if (ldef != null) {
            return (Location)this.mgmt.getLocationRegistry().resolve(ldef, null, flags).get();
        }
        Maybe l = this.mgmt.getLocationRegistry().resolve(spec, null, flags);
        if (l.isPresent()) {
            return (Location)l.get();
        }
        throw new IllegalStateException("Illegal parameter for 'location' (" + spec + "); not resolvable: " + Exceptions.collapseText((Throwable)((Maybe.Absent)l).getException()));
    }
}

