/*
 * Decompiled with CFR 0.152.
 */
package io.brooklyn.camp.brooklyn.spi.creation;

import brooklyn.catalog.internal.BasicBrooklynCatalog;
import brooklyn.entity.Entity;
import brooklyn.management.ManagementContext;
import brooklyn.management.classloading.BrooklynClassLoadingContext;
import brooklyn.management.classloading.JavaBrooklynClassLoadingContext;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.flags.FlagUtils;
import brooklyn.util.net.Urls;
import brooklyn.util.text.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.brooklyn.camp.brooklyn.BrooklynCampConstants;
import io.brooklyn.camp.brooklyn.spi.creation.BrooklynAssemblyTemplateInstantiator;
import io.brooklyn.camp.brooklyn.spi.creation.BrooklynComponentTemplateResolver;
import io.brooklyn.camp.spi.PlatformComponentTemplate;
import io.brooklyn.camp.spi.pdp.AssemblyTemplateConstructor;
import io.brooklyn.camp.spi.pdp.Service;
import io.brooklyn.camp.spi.resolve.PdpMatcher;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynEntityMatcher
implements PdpMatcher {
    private static final Logger log = LoggerFactory.getLogger(BrooklynEntityMatcher.class);
    protected final ManagementContext mgmt;

    public BrooklynEntityMatcher(ManagementContext bmc) {
        this.mgmt = bmc;
    }

    public boolean accepts(Object deploymentPlanItem) {
        return this.lookupType(deploymentPlanItem) != null;
    }

    protected String lookupType(Object deploymentPlanItem) {
        if (deploymentPlanItem instanceof Service) {
            Service service = (Service)deploymentPlanItem;
            String serviceType = service.getServiceType();
            BrooklynClassLoadingContext loader = BasicBrooklynCatalog.BrooklynLoaderTracker.getLoader();
            if (loader == null) {
                loader = JavaBrooklynClassLoadingContext.create((ManagementContext)this.mgmt);
            }
            if (BrooklynComponentTemplateResolver.Factory.supportsType(loader, serviceType)) {
                return serviceType;
            }
            String protocol = Urls.getProtocol((String)serviceType);
            if (protocol != null) {
                if (BrooklynCampConstants.YAML_URL_PROTOCOL_WHITELIST.contains(protocol)) {
                    return serviceType;
                }
                log.warn("The reference '" + serviceType + "' looks like an URL but the protocol '" + protocol + "' isn't white listed " + BrooklynCampConstants.YAML_URL_PROTOCOL_WHITELIST + ". " + "Not recognized as catalog item or java item as well!");
            }
        }
        return null;
    }

    public boolean apply(Object deploymentPlanItem, AssemblyTemplateConstructor atc) {
        List<FlagUtils.FlagConfigKeyAndValueRecord> topLevelApparentConfig;
        Object locations;
        Object location;
        MutableMap attrs;
        if (!(deploymentPlanItem instanceof Service)) {
            return false;
        }
        String type = this.lookupType(deploymentPlanItem);
        if (type == null) {
            return false;
        }
        log.debug("Item " + deploymentPlanItem + " being instantiated with " + type);
        Class old = atc.getInstantiator();
        if (old != null && !old.equals(BrooklynAssemblyTemplateInstantiator.class)) {
            log.warn("Can't mix Brooklyn entities with non-Brooklyn entities (at present): " + old);
            return false;
        }
        PlatformComponentTemplate.Builder builder = PlatformComponentTemplate.builder();
        builder.type(type.indexOf(58) == -1 ? "brooklyn:" + type : type);
        atc.instantiator(BrooklynAssemblyTemplateInstantiator.class);
        String name = ((Service)deploymentPlanItem).getName();
        if (!Strings.isBlank((CharSequence)name)) {
            builder.name(name);
        }
        if ((attrs = MutableMap.copyOf((Map)((Service)deploymentPlanItem).getCustomAttributes())).containsKey("id")) {
            builder.customAttribute("planId", attrs.remove("id"));
        }
        if ((location = attrs.remove("location")) != null) {
            builder.customAttribute("location", location);
        }
        if ((locations = attrs.remove("locations")) != null) {
            builder.customAttribute("locations", locations);
        }
        MutableMap brooklynConfig = MutableMap.of();
        Object origBrooklynConfig = attrs.remove("brooklyn.config");
        if (origBrooklynConfig != null) {
            if (!(origBrooklynConfig instanceof Map)) {
                throw new IllegalArgumentException("brooklyn.config must be a map of brooklyn config keys");
            }
            brooklynConfig.putAll((Map)origBrooklynConfig);
        }
        if ((topLevelApparentConfig = this.extractValidConfigFlagsOrKeys(type, (Map<String, Object>)attrs, true)) != null) {
            for (FlagUtils.FlagConfigKeyAndValueRecord r : topLevelApparentConfig) {
                if (r.getConfigKeyMaybeValue().isPresent()) {
                    brooklynConfig.put((Object)r.getConfigKey(), r.getConfigKeyMaybeValue().get());
                }
                if (!r.getFlagMaybeValue().isPresent()) continue;
                brooklynConfig.put((Object)r.getFlagName(), r.getFlagMaybeValue().get());
            }
        }
        if (!brooklynConfig.isEmpty()) {
            builder.customAttribute("brooklyn.config", (Object)brooklynConfig);
        }
        this.addCustomListAttributeIfNonNull((PlatformComponentTemplate.Builder<? extends PlatformComponentTemplate>)builder, (Map<?, ?>)attrs, "brooklyn.policies");
        this.addCustomListAttributeIfNonNull((PlatformComponentTemplate.Builder<? extends PlatformComponentTemplate>)builder, (Map<?, ?>)attrs, "brooklyn.enrichers");
        this.addCustomListAttributeIfNonNull((PlatformComponentTemplate.Builder<? extends PlatformComponentTemplate>)builder, (Map<?, ?>)attrs, "brooklyn.initializers");
        this.addCustomListAttributeIfNonNull((PlatformComponentTemplate.Builder<? extends PlatformComponentTemplate>)builder, (Map<?, ?>)attrs, "brooklyn.children");
        this.addCustomMapAttributeIfNonNull((PlatformComponentTemplate.Builder<? extends PlatformComponentTemplate>)builder, (Map<?, ?>)attrs, "brooklyn.catalog");
        if (!attrs.isEmpty()) {
            log.warn("Ignoring PDP attributes on " + deploymentPlanItem + ": " + attrs);
        }
        atc.add((PlatformComponentTemplate)builder.build());
        return true;
    }

    private void addCustomListAttributeIfNonNull(PlatformComponentTemplate.Builder<? extends PlatformComponentTemplate> builder, Map<?, ?> attrs, String key) {
        Object items = attrs.remove(key);
        if (items != null) {
            if (items instanceof List) {
                List itemList = (List)items;
                if (!itemList.isEmpty()) {
                    builder.customAttribute(key, (Object)Lists.newArrayList((Iterable)itemList));
                }
            } else {
                throw new IllegalArgumentException(key + " must be a list, is: " + items.getClass().getName());
            }
        }
    }

    private void addCustomMapAttributeIfNonNull(PlatformComponentTemplate.Builder<? extends PlatformComponentTemplate> builder, Map<?, ?> attrs, String key) {
        Object items = attrs.remove(key);
        if (items != null) {
            if (items instanceof Map) {
                Map itemMap = (Map)items;
                if (!itemMap.isEmpty()) {
                    builder.customAttribute(key, (Object)Maps.newHashMap((Map)itemMap));
                }
            } else {
                throw new IllegalArgumentException(key + " must be a map, is: " + items.getClass().getName());
            }
        }
    }

    protected List<FlagUtils.FlagConfigKeyAndValueRecord> extractValidConfigFlagsOrKeys(String typeName, Map<String, Object> attrs, boolean removeIfFound) {
        if (attrs == null || attrs.isEmpty()) {
            return null;
        }
        try {
            Class<? extends Entity> type = BrooklynComponentTemplateResolver.Factory.newInstance((BrooklynClassLoadingContext)JavaBrooklynClassLoadingContext.create((ManagementContext)this.mgmt), typeName).loadEntityClass();
            ConfigBag bag = ConfigBag.newInstance(attrs);
            List values = FlagUtils.findAllFlagsAndConfigKeys(null, type, (ConfigBag)bag);
            if (removeIfFound) {
                MutableMap used = MutableMap.copyOf((Map)bag.getAllConfig());
                for (String unusedKey : bag.getUnusedConfig().keySet()) {
                    used.remove((Object)unusedKey);
                }
                for (String usedKey : used.keySet()) {
                    attrs.remove(usedKey);
                }
            }
            return values;
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            if (e.toString().contains("Could not find")) {
                log.warn("Ignoring configuration attributes on " + typeName + ", item probably loaded from catalog and flags are not yet supported here");
                log.debug("Ignoring configuration attributes on " + typeName + ", details: " + e);
            } else {
                log.warn("Ignoring configuration attributes on " + typeName + " due to " + e, (Throwable)e);
            }
            return null;
        }
    }
}

