/*
 * Decompiled with CFR 0.152.
 */
package io.brooklyn.camp.brooklyn.spi.creation;

import brooklyn.catalog.BrooklynCatalog;
import brooklyn.catalog.CatalogItem;
import brooklyn.catalog.internal.CatalogUtils;
import brooklyn.entity.proxying.EntityInitializer;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.management.ManagementContext;
import brooklyn.policy.Enricher;
import brooklyn.policy.EnricherSpec;
import brooklyn.policy.Policy;
import brooklyn.policy.PolicySpec;
import brooklyn.util.collections.MutableList;
import brooklyn.util.config.ConfigBag;
import com.google.common.annotations.Beta;
import io.brooklyn.camp.brooklyn.spi.creation.BrooklynYamlTypeInstantiator;
import java.util.List;
import java.util.Map;

@Beta
public abstract class BrooklynEntityDecorationResolver<DT> {
    public final BrooklynYamlTypeInstantiator.Factory instantiator;

    protected BrooklynEntityDecorationResolver(BrooklynYamlTypeInstantiator.Factory instantiator) {
        this.instantiator = instantiator;
    }

    public abstract void decorate(EntitySpec<?> var1, ConfigBag var2);

    protected Iterable<? extends DT> buildListOfTheseDecorationsFromEntityAttributes(ConfigBag attrs) {
        Object value = this.getDecorationAttributeJsonValue(attrs);
        MutableList decorations = MutableList.of();
        if (value == null) {
            return decorations;
        }
        if (value instanceof Iterable) {
            for (Object decorationJson : (Iterable)value) {
                this.addDecorationFromJsonMap(this.checkIsMap(decorationJson), (List<DT>)decorations);
            }
        } else {
            throw new IllegalArgumentException(this.getDecorationKind() + " body should be iterable, not " + value.getClass());
        }
        return decorations;
    }

    protected Map<?, ?> checkIsMap(Object decorationJson) {
        if (!(decorationJson instanceof Map)) {
            throw new IllegalArgumentException(this.getDecorationKind() + " value must be a Map, not " + (decorationJson == null ? null : decorationJson.getClass()));
        }
        return (Map)decorationJson;
    }

    protected abstract String getDecorationKind();

    protected abstract Object getDecorationAttributeJsonValue(ConfigBag var1);

    protected void addDecorationFromJson(Object decorationJson, List<DT> decorations) {
        this.addDecorationFromJsonMap(this.checkIsMap(decorationJson), decorations);
    }

    protected abstract void addDecorationFromJsonMap(Map<?, ?> var1, List<DT> var2);

    public static class InitializerResolver
    extends BrooklynEntityDecorationResolver<EntityInitializer> {
        public InitializerResolver(BrooklynYamlTypeInstantiator.Factory loader) {
            super(loader);
        }

        @Override
        protected String getDecorationKind() {
            return "Entity initializer";
        }

        @Override
        public void decorate(EntitySpec<?> entitySpec, ConfigBag attrs) {
            entitySpec.addInitializers(this.buildListOfTheseDecorationsFromEntityAttributes(attrs));
        }

        @Override
        protected Object getDecorationAttributeJsonValue(ConfigBag attrs) {
            return attrs.getStringKey("brooklyn.initializers");
        }

        @Override
        protected void addDecorationFromJsonMap(Map<?, ?> decorationJson, List<EntityInitializer> decorations) {
            decorations.add(this.instantiator.from(decorationJson).prefix("initializer").newInstance(EntityInitializer.class));
        }
    }

    public static class EnricherSpecResolver
    extends BrooklynEntityDecorationResolver<EnricherSpec<?>> {
        public EnricherSpecResolver(BrooklynYamlTypeInstantiator.Factory loader) {
            super(loader);
        }

        @Override
        protected String getDecorationKind() {
            return "Enricher";
        }

        @Override
        public void decorate(EntitySpec<?> entitySpec, ConfigBag attrs) {
            entitySpec.enricherSpecs(this.buildListOfTheseDecorationsFromEntityAttributes(attrs));
        }

        @Override
        protected Object getDecorationAttributeJsonValue(ConfigBag attrs) {
            return attrs.getStringKey("brooklyn.enrichers");
        }

        @Override
        protected void addDecorationFromJsonMap(Map<?, ?> decorationJson, List<EnricherSpec<?>> decorations) {
            BrooklynYamlTypeInstantiator.InstantiatorFromKey decoLoader = this.instantiator.from(decorationJson).prefix("enricher");
            decorations.add(EnricherSpec.create(decoLoader.getType(Enricher.class)).configure(decoLoader.getConfigMap()));
        }
    }

    public static class PolicySpecResolver
    extends BrooklynEntityDecorationResolver<PolicySpec<?>> {
        public PolicySpecResolver(BrooklynYamlTypeInstantiator.Factory loader) {
            super(loader);
        }

        @Override
        protected String getDecorationKind() {
            return "Policy";
        }

        @Override
        public void decorate(EntitySpec<?> entitySpec, ConfigBag attrs) {
            entitySpec.policySpecs(this.buildListOfTheseDecorationsFromEntityAttributes(attrs));
        }

        @Override
        protected Object getDecorationAttributeJsonValue(ConfigBag attrs) {
            return attrs.getStringKey("brooklyn.policies");
        }

        @Override
        protected void addDecorationFromJsonMap(Map<?, ?> decorationJson, List<PolicySpec<?>> decorations) {
            PolicySpec spec;
            BrooklynYamlTypeInstantiator.InstantiatorFromKey decoLoader = this.instantiator.from(decorationJson).prefix("policy");
            String policyType = (String)decoLoader.getTypeName().get();
            ManagementContext mgmt = this.instantiator.loader.getManagementContext();
            BrooklynCatalog catalog = mgmt.getCatalog();
            CatalogItem<?, ?> item = this.getPolicyCatalogItem(catalog, policyType);
            if (item != null) {
                spec = (PolicySpec)catalog.createSpec(item);
                spec.configure(decoLoader.getConfigMap());
            } else {
                spec = PolicySpec.create(decoLoader.getType(Policy.class)).configure(decoLoader.getConfigMap());
            }
            decorations.add(spec);
        }

        private CatalogItem<?, ?> getPolicyCatalogItem(BrooklynCatalog catalog, String policyType) {
            if (CatalogUtils.looksLikeVersionedId((String)policyType)) {
                String id = CatalogUtils.getIdFromVersionedId((String)policyType);
                String version = CatalogUtils.getVersionFromVersionedId((String)policyType);
                return catalog.getCatalogItem(id, version);
            }
            return catalog.getCatalogItem(policyType, "0.0.0_DEFAULT_VERSION");
        }
    }
}

