/*
 * Decompiled with CFR 0.152.
 */
package io.brooklyn.camp.brooklyn.spi.creation;

import brooklyn.catalog.CatalogItem;
import brooklyn.catalog.internal.CatalogUtils;
import brooklyn.entity.Application;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.AbstractEntity;
import brooklyn.entity.basic.BrooklynTags;
import brooklyn.entity.basic.BrooklynTaskTags;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.proxying.InternalEntityFactory;
import brooklyn.location.Location;
import brooklyn.management.ManagementContext;
import brooklyn.management.ManagementContextInjectable;
import brooklyn.management.Task;
import brooklyn.management.classloading.BrooklynClassLoadingContext;
import brooklyn.management.classloading.JavaBrooklynClassLoadingContext;
import brooklyn.management.internal.ManagementContextInternal;
import brooklyn.util.ResourceUtils;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableSet;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.flags.FlagUtils;
import brooklyn.util.guava.Maybe;
import brooklyn.util.javalang.Reflections;
import brooklyn.util.task.Tasks;
import brooklyn.util.text.Strings;
import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import io.brooklyn.camp.brooklyn.BrooklynCampConstants;
import io.brooklyn.camp.brooklyn.spi.creation.BrooklynAssemblyTemplateInstantiator;
import io.brooklyn.camp.brooklyn.spi.creation.BrooklynYamlLocationResolver;
import io.brooklyn.camp.brooklyn.spi.creation.BrooklynYamlTypeInstantiator;
import io.brooklyn.camp.brooklyn.spi.creation.EntitySpecConfiguration;
import io.brooklyn.camp.brooklyn.spi.creation.service.BrooklynServiceTypeResolver;
import io.brooklyn.camp.brooklyn.spi.creation.service.ServiceTypeResolver;
import io.brooklyn.camp.spi.AbstractResource;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynComponentTemplateResolver {
    private static final Logger log = LoggerFactory.getLogger(BrooklynComponentTemplateResolver.class);
    private final BrooklynClassLoadingContext loader;
    private final ManagementContext mgmt;
    private final ConfigBag attrs;
    private final Maybe<AbstractResource> template;
    private final BrooklynYamlTypeInstantiator.Factory yamlLoader;
    private final String type;
    private final ServiceTypeResolver typeResolver;
    private final AtomicBoolean alreadyBuilt = new AtomicBoolean(false);

    public BrooklynComponentTemplateResolver(BrooklynClassLoadingContext loader, ConfigBag attrs, AbstractResource optionalTemplate, String type, ServiceTypeResolver typeResolver) {
        this.loader = loader;
        this.mgmt = loader.getManagementContext();
        this.attrs = ConfigBag.newInstanceCopying((ConfigBag)attrs);
        this.template = Maybe.fromNullable((Object)optionalTemplate);
        this.yamlLoader = new BrooklynYamlTypeInstantiator.Factory(loader, this);
        this.type = type;
        this.typeResolver = typeResolver;
    }

    public BrooklynClassLoadingContext getLoader() {
        return this.loader;
    }

    public ManagementContext getManagementContext() {
        return this.mgmt;
    }

    public ConfigBag getAttrs() {
        return this.attrs;
    }

    public Maybe<AbstractResource> getTemplate() {
        return this.template;
    }

    public BrooklynYamlTypeInstantiator.Factory getYamlLoader() {
        return this.yamlLoader;
    }

    public ServiceTypeResolver getServiceTypeResolver() {
        return this.typeResolver;
    }

    public String getDeclaredType() {
        return this.type;
    }

    public Boolean isAlreadyBuilt() {
        return this.alreadyBuilt.get();
    }

    protected boolean canResolve() {
        if (this.typeResolver.getCatalogItem(this, this.type) != null) {
            return true;
        }
        return this.loader.tryLoadClass(this.getJavaType(), Entity.class).isPresent();
    }

    protected Class<? extends Entity> loadEntityClass() {
        Maybe<Class<? extends Entity>> result = this.tryLoadEntityClass();
        if (result.isAbsent()) {
            throw new IllegalStateException("Could not find " + this.typeResolver.getBrooklynType(this.type), ((Maybe.Absent)result).getException());
        }
        return (Class)result.get();
    }

    protected Maybe<Class<? extends Entity>> tryLoadEntityClass() {
        return this.loader.tryLoadClass(this.getJavaType(), Entity.class);
    }

    protected boolean isJavaTypePrefix() {
        return this.type != null && (this.type.toLowerCase().startsWith("java:") || this.type.toLowerCase().startsWith("brooklyn:java:"));
    }

    protected String getJavaType() {
        CatalogItem<Entity, EntitySpec<?>> item = this.typeResolver.getCatalogItem(this, this.type);
        if (!this.isJavaTypePrefix() && item != null && item.getJavaType() != null) {
            return item.getJavaType();
        }
        return this.typeResolver.getBrooklynType(this.type);
    }

    protected <T extends Entity> EntitySpec<T> resolveSpec(Set<String> encounteredCatalogTypes) {
        if (this.alreadyBuilt.getAndSet(true)) {
            throw new IllegalStateException("Spec can only be used once: " + this);
        }
        EntitySpec<T> spec = this.createSpec(encounteredCatalogTypes);
        this.populateSpec(spec);
        return spec;
    }

    protected <T extends Entity> EntitySpec<T> createSpec(Set<String> encounteredCatalogTypes) {
        boolean recursiveButTryJava;
        CatalogItem<Entity, EntitySpec<?>> item = this.getServiceTypeResolver().getCatalogItem(this, this.getDeclaredType());
        if (encounteredCatalogTypes == null) {
            encounteredCatalogTypes = MutableSet.of();
        }
        boolean firstOccurrence = item == null || encounteredCatalogTypes.add(item.getSymbolicName());
        boolean bl = recursiveButTryJava = !firstOccurrence;
        if (this.isJavaTypePrefix() || item == null || item.getJavaType() != null) {
            return this.createSpecFromJavaType();
        }
        if (recursiveButTryJava) {
            if (this.tryLoadEntityClass().isAbsent()) {
                throw new IllegalStateException("Recursive reference to " + item + " (and cannot be resolved as a Java type)");
            }
            return this.createSpecFromJavaType();
        }
        EntitySpec<?> spec = BrooklynAssemblyTemplateInstantiator.resolveCatalogYamlReferenceSpec(this.mgmt, item, (Set<String>)encounteredCatalogTypes);
        spec.catalogItemId(item.getId());
        return spec;
    }

    protected <T extends Entity> EntitySpec<T> createSpecFromJavaType() {
        EntitySpec spec;
        Class<? extends Entity> type = this.loadEntityClass();
        if (type.isInterface()) {
            spec = EntitySpec.create(type);
        } else {
            Class interfaceclazz = Application.class.isAssignableFrom(type) ? Application.class : Entity.class;
            List additionalInterfaceClazzes = Reflections.getAllInterfaces(type);
            spec = EntitySpec.create(interfaceclazz).impl(type).additionalInterfaces((Iterable)additionalInterfaceClazzes);
        }
        spec.catalogItemId(CatalogUtils.getCatalogItemIdFromLoader((BrooklynClassLoadingContext)this.loader));
        if (this.template.isPresent() && ((AbstractResource)this.template.get()).getSourceCode() != null) {
            spec.tag((Object)BrooklynTags.newYamlSpecTag((String)((AbstractResource)this.template.get()).getSourceCode()));
        }
        return spec;
    }

    protected <T extends Entity> void populateSpec(EntitySpec<T> spec) {
        List<Location> childLocations;
        Object childrenObj;
        String name;
        String templateId = null;
        String planId = null;
        if (this.template.isPresent()) {
            name = ((AbstractResource)this.template.get()).getName();
            templateId = ((AbstractResource)this.template.get()).getId();
        } else {
            name = (String)this.attrs.getStringKey("name");
        }
        planId = (String)this.attrs.getStringKey("id");
        if (planId == null) {
            planId = (String)this.attrs.getStringKey("planId");
        }
        if ((childrenObj = this.attrs.getStringKey("brooklyn.children")) != null) {
            MutableSet encounteredCatalogTypes = MutableSet.of();
            Iterable children = (Iterable)childrenObj;
            for (Map childAttrs : children) {
                BrooklynComponentTemplateResolver entityResolver = Factory.newInstance(this.loader, childAttrs);
                EntitySpec<?> childSpec = BrooklynAssemblyTemplateInstantiator.resolveSpec(ResourceUtils.create((Object)this), entityResolver, (Set<String>)encounteredCatalogTypes);
                spec.child(childSpec);
            }
        }
        if (!Strings.isBlank((CharSequence)name)) {
            spec.displayName(name);
        }
        if (templateId != null) {
            spec.configure(BrooklynCampConstants.TEMPLATE_ID, (Object)templateId);
        }
        if (planId != null) {
            spec.configure(BrooklynCampConstants.PLAN_ID, (Object)planId);
        }
        if ((childLocations = new BrooklynYamlLocationResolver(this.mgmt).resolveLocations(this.attrs.getAllConfig(), true)) != null) {
            spec.locations(childLocations);
        }
        this.typeResolver.decorateSpec(this, spec);
        this.configureEntityConfig(spec);
    }

    protected <T extends Entity> T newEntity(EntitySpec<T> spec) {
        Class entityImpl = spec.getImplementation() != null ? spec.getImplementation() : this.mgmt.getEntityManager().getEntityTypeRegistry().getImplementedBy(spec.getType());
        InternalEntityFactory entityFactory = ((ManagementContextInternal)this.mgmt).getEntityFactory();
        Entity entity = entityFactory.constructEntity(entityImpl, spec);
        String planId = (String)spec.getConfig().get(BrooklynCampConstants.PLAN_ID);
        if (planId != null) {
            entity.config().set(BrooklynCampConstants.PLAN_ID, (Object)planId);
        }
        if (spec.getLocations().size() > 0) {
            ((AbstractEntity)entity).addLocations((Collection)spec.getLocations());
        }
        if (spec.getParent() != null) {
            entity.setParent(spec.getParent());
        }
        return (T)entity;
    }

    protected void configureEntityConfig(EntitySpec<?> spec) {
        Object transformed;
        ConfigBag bag = ConfigBag.newInstance((Map)((Map)this.attrs.getStringKey("brooklyn.config")));
        ConfigBag bagFlags = ConfigBag.newInstanceCopying((ConfigBag)this.attrs);
        List topLevelApparentConfig = FlagUtils.findAllFlagsAndConfigKeys(null, (Class)spec.getType(), (ConfigBag)bagFlags);
        for (FlagUtils.FlagConfigKeyAndValueRecord r : topLevelApparentConfig) {
            if (r.getConfigKeyMaybeValue().isPresent()) {
                bag.putIfAbsent(r.getConfigKey(), r.getConfigKeyMaybeValue().get());
            }
            if (!r.getFlagMaybeValue().isPresent()) continue;
            bag.putAsStringKeyIfAbsent((Object)r.getFlagName(), r.getFlagMaybeValue().get());
        }
        List records = FlagUtils.findAllFlagsAndConfigKeys(null, (Class)spec.getType(), (ConfigBag)bag);
        LinkedHashSet<String> keyNamesUsed = new LinkedHashSet<String>();
        for (FlagUtils.FlagConfigKeyAndValueRecord r : records) {
            if (r.getFlagMaybeValue().isPresent()) {
                transformed = new SpecialFlagsTransformer(this.loader).transformSpecialFlags(r.getFlagMaybeValue().get());
                spec.configure((CharSequence)r.getFlagName(), transformed);
                keyNamesUsed.add(r.getFlagName());
            }
            if (!r.getConfigKeyMaybeValue().isPresent()) continue;
            transformed = new SpecialFlagsTransformer(this.loader).transformSpecialFlags(r.getConfigKeyMaybeValue().get());
            spec.configure(r.getConfigKey(), transformed);
            keyNamesUsed.add(r.getConfigKey().getName());
        }
        for (String key : MutableSet.copyOf(bag.getUnusedConfig().keySet())) {
            if (keyNamesUsed.contains(key)) continue;
            transformed = new SpecialFlagsTransformer(this.loader).transformSpecialFlags(bag.getStringKey(key));
            spec.configure(ConfigKeys.newConfigKey(Object.class, (String)key.toString()), transformed);
        }
    }

    protected List<Map<String, Object>> getChildren(Map<String, Object> attrs) {
        if (attrs == null) {
            return null;
        }
        return (List)attrs.get("brooklyn.children");
    }

    protected static class SpecialFlagsTransformer
    implements Function<Object, Object> {
        protected final ManagementContext mgmt;
        private BrooklynClassLoadingContext loader = null;

        public SpecialFlagsTransformer(BrooklynClassLoadingContext loader) {
            this.loader = loader;
            this.mgmt = loader.getManagementContext();
        }

        public Object apply(Object input) {
            if (input instanceof Map) {
                return this.transformSpecialFlags((Map)input);
            }
            if (input instanceof Set) {
                return MutableSet.of(this.transformSpecialFlags((Iterable)input));
            }
            if (input instanceof List) {
                return MutableList.copyOf(this.transformSpecialFlags((Iterable)input));
            }
            if (input instanceof Iterable) {
                return this.transformSpecialFlags((Iterable)input);
            }
            return this.transformSpecialFlags(input);
        }

        protected Map<?, ?> transformSpecialFlags(Map<?, ?> flag) {
            return Maps.transformValues(flag, (Function)this);
        }

        protected Iterable<?> transformSpecialFlags(Iterable<?> flag) {
            return Iterables.transform(flag, (Function)this);
        }

        protected BrooklynClassLoadingContext getLoader() {
            if (this.loader != null) {
                return this.loader;
            }
            Entity entity = BrooklynTaskTags.getTargetOrContextEntity((Task)Tasks.current());
            if (entity != null) {
                return CatalogUtils.getClassLoadingContext((Entity)entity);
            }
            return JavaBrooklynClassLoadingContext.create((ManagementContext)this.mgmt);
        }

        protected Object transformSpecialFlags(Object flag) {
            if (flag instanceof EntitySpecConfiguration) {
                EntitySpecConfiguration specConfig = (EntitySpecConfiguration)flag;
                Map<String, Object> resolvedConfig = this.transformSpecialFlags(specConfig.getSpecConfiguration());
                specConfig.setSpecConfiguration(resolvedConfig);
                return Factory.newInstance(this.getLoader(), specConfig.getSpecConfiguration()).resolveSpec(null);
            }
            if (flag instanceof ManagementContextInjectable) {
                log.debug("Injecting Brooklyn management context info object: {}", flag);
                ((ManagementContextInjectable)flag).injectManagementContext(this.loader.getManagementContext());
            }
            return flag;
        }
    }

    public static class Factory {
        private static ServiceTypeResolver computeResolverType(BrooklynClassLoadingContext context, String knownServiceType, AbstractResource optionalTemplate, ConfigBag attrs) {
            String type = Factory.getDeclaredType(knownServiceType, optionalTemplate, attrs);
            return Factory.findService(context, type);
        }

        protected static ServiceTypeResolver findService(BrooklynClassLoadingContext context, String type) {
            if (type.indexOf(58) != -1) {
                String prefix = (String)Splitter.on((String)":").splitToList((CharSequence)type).get(0);
                ServiceLoader<ServiceTypeResolver> loader = ServiceLoader.load(ServiceTypeResolver.class, context.getManagementContext().getCatalogClassLoader());
                for (ServiceTypeResolver resolver : loader) {
                    if (!prefix.equals(resolver.getTypePrefix())) continue;
                    return resolver;
                }
            }
            return null;
        }

        public static BrooklynComponentTemplateResolver newInstance(BrooklynClassLoadingContext context, Map<String, ?> childAttrs) {
            return Factory.newInstance(context, ConfigBag.newInstance(childAttrs), null);
        }

        public static BrooklynComponentTemplateResolver newInstance(BrooklynClassLoadingContext context, AbstractResource template) {
            return Factory.newInstance(context, ConfigBag.newInstance((Map)template.getCustomAttributes()), template);
        }

        public static BrooklynComponentTemplateResolver newInstance(BrooklynClassLoadingContext context, String serviceType) {
            return Factory.newInstance(context, ConfigBag.newInstance().configureStringKey("serviceType", (Object)serviceType), null);
        }

        private static BrooklynComponentTemplateResolver newInstance(BrooklynClassLoadingContext context, ConfigBag attrs, AbstractResource optionalTemplate) {
            ServiceTypeResolver typeResolver = Factory.computeResolverType(context, null, optionalTemplate, attrs);
            String type = Factory.getDeclaredType(null, optionalTemplate, attrs);
            if (typeResolver == null) {
                typeResolver = new BrooklynServiceTypeResolver();
            }
            return new BrooklynComponentTemplateResolver(context, attrs, optionalTemplate, type, typeResolver);
        }

        public static String getDeclaredType(String knownServiceType, AbstractResource optionalTemplate, @Nullable ConfigBag attrs) {
            String type = knownServiceType;
            if (type == null && optionalTemplate != null && ((type = optionalTemplate.getType()).equals("AssemblyTemplate") || type.equals("PlatformComponentTemplate") || type.equals("ApplicationComponentTemplate"))) {
                type = null;
            }
            if (type == null) {
                type = Factory.extractServiceTypeAttribute(attrs);
            }
            return type;
        }

        private static String extractServiceTypeAttribute(@Nullable ConfigBag attrs) {
            return (String)BrooklynYamlTypeInstantiator.InstantiatorFromKey.extractTypeName("service", attrs).orNull();
        }

        public static boolean supportsType(BrooklynClassLoadingContext context, String serviceType) {
            ServiceTypeResolver typeResolver = Factory.computeResolverType(context, serviceType, null, null);
            if (typeResolver != null) {
                return true;
            }
            return Factory.newInstance(context, serviceType).canResolve();
        }
    }
}

