/*
 * Decompiled with CFR 0.152.
 */
package io.brooklyn.camp.brooklyn.spi.creation;

import brooklyn.camp.brooklyn.api.AssemblyTemplateSpecInstantiator;
import brooklyn.camp.brooklyn.api.HasBrooklynManagementContext;
import brooklyn.catalog.CatalogItem;
import brooklyn.catalog.internal.BasicBrooklynCatalog;
import brooklyn.catalog.internal.CatalogUtils;
import brooklyn.config.BrooklynServerConfig;
import brooklyn.entity.Application;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.BasicApplicationImpl;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.management.ManagementContext;
import brooklyn.management.classloading.BrooklynClassLoadingContext;
import brooklyn.management.internal.EntityManagementUtils;
import brooklyn.util.ResourceUtils;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.flags.TypeCoercions;
import brooklyn.util.net.Urls;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.brooklyn.camp.CampPlatform;
import io.brooklyn.camp.brooklyn.BrooklynCampConstants;
import io.brooklyn.camp.brooklyn.spi.creation.BrooklynComponentTemplateResolver;
import io.brooklyn.camp.spi.AbstractResource;
import io.brooklyn.camp.spi.Assembly;
import io.brooklyn.camp.spi.AssemblyTemplate;
import io.brooklyn.camp.spi.PlatformComponentTemplate;
import io.brooklyn.camp.spi.collection.ResolvableLink;
import io.brooklyn.camp.spi.instantiate.AssemblyTemplateInstantiator;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynAssemblyTemplateInstantiator
implements AssemblyTemplateSpecInstantiator {
    private static final Logger log = LoggerFactory.getLogger(BrooklynAssemblyTemplateInstantiator.class);
    public static final String NEVER_UNWRAP_APPS_PROPERTY = "wrappedApp";

    public Assembly instantiate(AssemblyTemplate template, CampPlatform platform) {
        Application app = this.create(template, platform);
        EntityManagementUtils.CreationResult start = EntityManagementUtils.start((Application)app);
        log.debug("CAMP created " + app + "; starting in " + start.task());
        return (Assembly)platform.assemblies().get(app.getApplicationId());
    }

    public Application create(AssemblyTemplate template, CampPlatform platform) {
        Application instance = EntityManagementUtils.createUnstarted((ManagementContext)this.getBrooklynManagementContext(platform), (AssemblyTemplate)template);
        log.debug("CAMP created {}", (Object)instance);
        return instance;
    }

    private ManagementContext getBrooklynManagementContext(CampPlatform platform) {
        return ((HasBrooklynManagementContext)platform).getBrooklynManagementContext();
    }

    public EntitySpec<? extends Application> createSpec(AssemblyTemplate template, CampPlatform platform, BrooklynClassLoadingContext loader, boolean autoUnwrapIfPossible) {
        log.debug("CAMP creating application instance for {} ({})", (Object)template.getId(), (Object)template);
        BrooklynComponentTemplateResolver resolver = BrooklynComponentTemplateResolver.Factory.newInstance(loader, (AbstractResource)this.buildWrapperAppTemplate(template));
        EntitySpec app = resolver.resolveSpec(null);
        List<EntitySpec<?>> childSpecs = this.buildTemplateServicesAsSpecs(loader, template, platform);
        for (EntitySpec<?> childSpec : childSpecs) {
            app.child(childSpec);
        }
        if (autoUnwrapIfPossible && this.shouldUnwrap(template, app)) {
            EntitySpec oldApp = app;
            app = (EntitySpec)Iterables.getOnlyElement((Iterable)app.getChildren());
            EntityManagementUtils.collapseSpec((EntitySpec)oldApp, (EntitySpec)app);
        } else {
            app.configure(EntityManagementUtils.WRAPPER_APP_MARKER, (Object)Boolean.TRUE);
        }
        return app;
    }

    private AssemblyTemplate buildWrapperAppTemplate(AssemblyTemplate template) {
        AssemblyTemplate.Builder builder = AssemblyTemplate.builder();
        builder.type("brooklyn:" + BasicApplicationImpl.class.getName());
        builder.id(template.getId());
        builder.name(template.getName());
        builder.sourceCode(template.getSourceCode());
        for (Map.Entry entry : template.getCustomAttributes().entrySet()) {
            builder.customAttribute((String)entry.getKey(), entry.getValue());
        }
        builder.instantiator(template.getInstantiator());
        AssemblyTemplate wrapTemplate = builder.build();
        return wrapTemplate;
    }

    protected boolean shouldUnwrap(AssemblyTemplate template, EntitySpec<? extends Application> app) {
        Object leaveWrapped = template.getCustomAttributes().get(NEVER_UNWRAP_APPS_PROPERTY);
        if (leaveWrapped != null && ((Boolean)TypeCoercions.coerce(leaveWrapped, Boolean.class)).booleanValue()) {
            return false;
        }
        if (app.getChildren().size() != 1) {
            return false;
        }
        EntitySpec childSpec = (EntitySpec)Iterables.getOnlyElement((Iterable)app.getChildren());
        if (childSpec.getType() == null || !Application.class.isAssignableFrom(childSpec.getType())) {
            return false;
        }
        return EntityManagementUtils.hasNoNameOrCustomKeysOrRoot((AssemblyTemplate)template, app);
    }

    private List<EntitySpec<?>> buildTemplateServicesAsSpecs(BrooklynClassLoadingContext loader, AssemblyTemplate template, CampPlatform platform) {
        return this.buildTemplateServicesAsSpecsImpl(loader, template, platform, Sets.newLinkedHashSet());
    }

    private List<EntitySpec<?>> buildTemplateServicesAsSpecsImpl(BrooklynClassLoadingContext loader, AssemblyTemplate template, CampPlatform platform, Set<String> encounteredCatalogTypes) {
        ArrayList result = Lists.newArrayList();
        for (ResolvableLink ctl : template.getPlatformComponentTemplates().links()) {
            PlatformComponentTemplate appChildComponentTemplate = (PlatformComponentTemplate)ctl.resolve();
            BrooklynComponentTemplateResolver entityResolver = BrooklynComponentTemplateResolver.Factory.newInstance(loader, (AbstractResource)appChildComponentTemplate);
            EntitySpec<?> spec = BrooklynAssemblyTemplateInstantiator.resolveSpec(ResourceUtils.create((Object)this), entityResolver, encounteredCatalogTypes);
            result.add(spec);
        }
        return result;
    }

    static EntitySpec<?> resolveSpec(ResourceUtils ru, BrooklynComponentTemplateResolver entityResolver, Set<String> encounteredCatalogTypes) {
        String brooklynType = entityResolver.getServiceTypeResolver().getBrooklynType(entityResolver.getDeclaredType());
        CatalogItem<Entity, EntitySpec<?>> item = entityResolver.getServiceTypeResolver().getCatalogItem(entityResolver, entityResolver.getDeclaredType());
        if (log.isTraceEnabled()) {
            log.trace("Building CAMP template services: type=" + brooklynType + "; item=" + item + "; loader=" + entityResolver.getLoader() + "; encounteredCatalogTypes=" + encounteredCatalogTypes);
        }
        Object spec = null;
        String protocol = Urls.getProtocol((String)brooklynType);
        if (protocol != null) {
            if (BrooklynCampConstants.YAML_URL_PROTOCOL_WHITELIST.contains(protocol)) {
                spec = BrooklynAssemblyTemplateInstantiator.tryResolveYamlUrlReferenceSpec(ru, brooklynType, entityResolver.getLoader(), encounteredCatalogTypes);
                if (spec != null) {
                    entityResolver.populateSpec(spec);
                }
            } else {
                log.warn("The reference " + brooklynType + " looks like an URL but the protocol " + protocol + " isn't white listed (" + BrooklynCampConstants.YAML_URL_PROTOCOL_WHITELIST + "). " + "Will try to load it as catalog item or java type.");
            }
        }
        if (spec == null) {
            spec = entityResolver.resolveSpec(encounteredCatalogTypes);
        }
        return spec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EntitySpec<?> tryResolveYamlUrlReferenceSpec(ResourceUtils ru, String brooklynType, BrooklynClassLoadingContext itemLoader, Set<String> encounteredCatalogTypes) {
        InputStreamReader yaml;
        ManagementContext mgmt = itemLoader.getManagementContext();
        try {
            yaml = new InputStreamReader(ru.getResourceFromUrl(brooklynType), "UTF-8");
        }
        catch (Exception e) {
            log.warn("AssemblyTemplate type " + brooklynType + " which looks like a URL can't be fetched.", (Throwable)e);
            return null;
        }
        try {
            EntitySpec<?> entitySpec = BrooklynAssemblyTemplateInstantiator.createNestedSpec(mgmt, encounteredCatalogTypes, yaml, itemLoader);
            return entitySpec;
        }
        finally {
            try {
                ((Reader)yaml).close();
            }
            catch (IOException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }
    }

    static EntitySpec<?> resolveCatalogYamlReferenceSpec(ManagementContext mgmt, CatalogItem<Entity, EntitySpec<?>> item, Set<String> encounteredCatalogTypes) {
        String yaml = item.getPlanYaml();
        StringReader input = new StringReader(yaml);
        BrooklynClassLoadingContext itemLoader = CatalogUtils.newClassLoadingContext((ManagementContext)mgmt, item);
        return BrooklynAssemblyTemplateInstantiator.createNestedSpec(mgmt, encounteredCatalogTypes, input, itemLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EntitySpec<?> createNestedSpec(ManagementContext mgmt, Set<String> encounteredCatalogTypes, Reader input, BrooklynClassLoadingContext itemLoader) {
        AssemblyTemplate at;
        CampPlatform platform = (CampPlatform)BrooklynServerConfig.getCampPlatform((ManagementContext)mgmt).get();
        BasicBrooklynCatalog.BrooklynLoaderTracker.setLoader((BrooklynClassLoadingContext)itemLoader);
        try {
            at = platform.pdp().registerDeploymentPlan(input);
        }
        finally {
            BasicBrooklynCatalog.BrooklynLoaderTracker.unsetLoader((BrooklynClassLoadingContext)itemLoader);
        }
        return BrooklynAssemblyTemplateInstantiator.createNestedSpecStatic(at, platform, itemLoader, encounteredCatalogTypes);
    }

    public EntitySpec<?> createNestedSpec(AssemblyTemplate template, CampPlatform platform, BrooklynClassLoadingContext itemLoader, Set<String> encounteredCatalogTypes) {
        return BrooklynAssemblyTemplateInstantiator.createNestedSpecStatic(template, platform, itemLoader, encounteredCatalogTypes);
    }

    private static EntitySpec<?> createNestedSpecStatic(AssemblyTemplate template, CampPlatform platform, BrooklynClassLoadingContext itemLoader, Set<String> encounteredCatalogTypes) {
        try {
            AssemblyTemplateInstantiator ati = (AssemblyTemplateInstantiator)template.getInstantiator().newInstance();
            if (ati instanceof BrooklynAssemblyTemplateInstantiator) {
                List<EntitySpec<?>> specs = ((BrooklynAssemblyTemplateInstantiator)ati).buildTemplateServicesAsSpecsImpl(itemLoader, template, platform, encounteredCatalogTypes);
                if (specs.size() > 1) {
                    throw new UnsupportedOperationException("Only supporting single service in catalog item currently: got " + specs);
                }
                return specs.get(0);
            }
            throw new IllegalStateException("Cannot create application with instantiator: " + ati);
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }
}

