/*
 * Decompiled with CFR 0.152.
 */
package io.brooklyn.camp.brooklyn;

import brooklyn.entity.Application;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.BrooklynShutdownHooks;
import brooklyn.entity.basic.BrooklynTaskTags;
import brooklyn.entity.basic.Entities;
import brooklyn.management.ExecutionManager;
import brooklyn.management.ManagementContext;
import brooklyn.management.Task;
import brooklyn.util.ResourceUtils;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.stream.Streams;
import com.google.common.annotations.Beta;
import io.brooklyn.camp.CampPlatform;
import io.brooklyn.camp.brooklyn.BrooklynCampPlatform;
import io.brooklyn.camp.brooklyn.BrooklynCampPlatformLauncherAbstract;
import io.brooklyn.camp.spi.Assembly;
import io.brooklyn.camp.spi.AssemblyTemplate;
import io.brooklyn.camp.spi.instantiate.AssemblyTemplateInstantiator;
import java.io.InputStream;
import java.io.Reader;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public abstract class YamlLauncherAbstract {
    private static final Logger log = LoggerFactory.getLogger(YamlLauncherAbstract.class);
    protected final BrooklynCampPlatformLauncherAbstract platformLauncher = this.newPlatformLauncher();
    protected final BrooklynCampPlatform platform;
    protected final ManagementContext brooklynMgmt;
    protected boolean shutdownAppsOnExit = false;

    public YamlLauncherAbstract() {
        this.platformLauncher.launch();
        this.platform = this.platformLauncher.getCampPlatform();
        this.brooklynMgmt = this.platformLauncher.getBrooklynMgmt();
    }

    public ManagementContext getManagementContext() {
        return this.brooklynMgmt;
    }

    public boolean getShutdownAppsOnExit() {
        return this.shutdownAppsOnExit;
    }

    public void setShutdownAppsOnExit(boolean shutdownAppsOnExit) {
        this.shutdownAppsOnExit = shutdownAppsOnExit;
    }

    protected abstract BrooklynCampPlatformLauncherAbstract newPlatformLauncher();

    public Application launchAppYaml(String url) {
        return this.launchAppYaml(url, true);
    }

    public Application launchAppYaml(String url, boolean waitForTasksToComplete) {
        try {
            Reader input = Streams.reader((InputStream)new ResourceUtils((Object)this).getResourceFromUrl(url));
            Application app = this.launchAppYaml(input, waitForTasksToComplete);
            log.info("Application started from YAML file " + url + ": " + app);
            return app;
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public Application launchAppYaml(Reader input) {
        return this.launchAppYaml(input, true);
    }

    public Application launchAppYaml(Reader input, boolean waitForTasksToComplete) {
        try {
            AssemblyTemplate at = this.platform.pdp().registerDeploymentPlan(input);
            Assembly assembly = ((AssemblyTemplateInstantiator)at.getInstantiator().newInstance()).instantiate(at, (CampPlatform)this.platform);
            Entity app = this.brooklynMgmt.getEntityManager().getEntity(assembly.getId());
            log.info("Launching " + app);
            if (this.getShutdownAppsOnExit()) {
                BrooklynShutdownHooks.invokeStopOnShutdown((Entity)app);
            }
            if (waitForTasksToComplete) {
                Set tasks = BrooklynTaskTags.getTasksInEntityContext((ExecutionManager)this.brooklynMgmt.getExecutionManager(), (Entity)app);
                log.info("Waiting on " + tasks.size() + " task(s)");
                for (Task t : tasks) {
                    t.blockUntilEnded();
                }
            }
            log.info("Application started from YAML: " + app);
            Entities.dumpInfo((Entity)app);
            return (Application)app;
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public void destroyAll() {
        Entities.destroyAll((ManagementContext)this.getManagementContext());
        try {
            this.platformLauncher.stopServers();
        }
        catch (Exception e) {
            log.warn("Unable to stop servers (ignoring): " + e);
        }
    }
}

