/*
 * Decompiled with CFR 0.152.
 */
package io.brooklyn.camp.brooklyn;

import brooklyn.camp.brooklyn.api.HasBrooklynManagementContext;
import brooklyn.config.BrooklynProperties;
import brooklyn.management.ManagementContext;
import io.brooklyn.camp.AggregatingCampPlatform;
import io.brooklyn.camp.brooklyn.BrooklynCampConstants;
import io.brooklyn.camp.brooklyn.spi.creation.BrooklynEntityMatcher;
import io.brooklyn.camp.brooklyn.spi.dsl.BrooklynDslInterpreter;
import io.brooklyn.camp.brooklyn.spi.platform.BrooklynImmutableCampPlatform;
import io.brooklyn.camp.spi.PlatformRootSummary;
import io.brooklyn.camp.spi.resolve.PdpMatcher;
import io.brooklyn.camp.spi.resolve.PlanInterpreter;

public class BrooklynCampPlatform
extends AggregatingCampPlatform
implements HasBrooklynManagementContext {
    private final ManagementContext bmc;

    public BrooklynCampPlatform(PlatformRootSummary root, ManagementContext managementContext) {
        super(root);
        this.addPlatform(new BrooklynImmutableCampPlatform(root, managementContext));
        this.bmc = managementContext;
        this.addMatchers();
        this.addInterpreters();
        managementContext.addPropertiesReloadListener(new ManagementContext.PropertiesReloadListener(){
            private static final long serialVersionUID = -3739276553334749184L;

            public void reloaded() {
                BrooklynCampPlatform.this.setConfigKeyAtManagmentContext();
            }
        });
    }

    public ManagementContext getBrooklynManagementContext() {
        return this.bmc;
    }

    protected void addMatchers() {
        this.pdp().addMatcher((PdpMatcher)new BrooklynEntityMatcher(this.bmc));
    }

    protected void addInterpreters() {
        this.pdp().addInterpreter((PlanInterpreter)new BrooklynDslInterpreter());
    }

    public BrooklynCampPlatform setConfigKeyAtManagmentContext() {
        ((BrooklynProperties)this.bmc.getConfig()).put(BrooklynCampConstants.CAMP_PLATFORM, (Object)this);
        return this;
    }
}

