/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.blobstore.strategy.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.logging.Logger;

public class MultipartUploadSlicingAlgorithm {
    @Resource
    @Named(value="jclouds.blobstore")
    protected Logger logger = Logger.NULL;
    @VisibleForTesting
    static final long DEFAULT_PART_SIZE = 0x2000000L;
    @VisibleForTesting
    static final int DEFAULT_MAGNITUDE_BASE = 100;
    @Inject(optional=true)
    @Named(value="jclouds.mpu.parts.size")
    @VisibleForTesting
    long defaultPartSize = 0x2000000L;
    @Inject(optional=true)
    @Named(value="jclouds.mpu.parts.magnitude")
    @VisibleForTesting
    int magnitudeBase = 100;
    private volatile int parts;
    private volatile long chunkSize;
    private volatile long remaining;
    private volatile int part;
    private volatile long chunkOffset;
    private volatile long copied;

    @VisibleForTesting
    protected long calculateChunkSize(long length) {
        long remainder;
        long unitPartSize = this.defaultPartSize;
        int parts = (int)(length / unitPartSize);
        long partSize = unitPartSize;
        int magnitude = parts / this.magnitudeBase;
        if (magnitude > 0) {
            partSize = (long)magnitude * unitPartSize;
            if (partSize > 0x140000000L) {
                partSize = 0x140000000L;
                unitPartSize = 0x140000000L;
            }
            if ((long)(parts = (int)(length / partSize)) * partSize < length) {
                partSize = (long)(magnitude + 1) * unitPartSize;
                if (partSize > 0x140000000L) {
                    partSize = 0x140000000L;
                    unitPartSize = 0x140000000L;
                }
                parts = (int)(length / partSize);
            }
        }
        if (parts > 10000) {
            unitPartSize = 0x500000L;
            parts = (int)(length / unitPartSize);
        }
        if (parts > 10000) {
            parts = 9999;
        }
        if ((remainder = length % unitPartSize) == 0L && parts > 0) {
            --parts;
        }
        this.chunkSize = partSize;
        this.parts = parts;
        this.remaining = length - partSize * (long)parts;
        this.logger.debug(" %d bytes partitioned in %d parts of part size: %d, remaining: %d%s", new Object[]{length, parts, this.chunkSize, this.remaining, this.remaining > 0x140000000L ? " overflow!" : ""});
        return this.chunkSize;
    }

    public long getCopied() {
        return this.copied;
    }

    public void setCopied(long copied) {
        this.copied = copied;
    }

    @VisibleForTesting
    protected int getParts() {
        return this.parts;
    }

    protected int getNextPart() {
        return ++this.part;
    }

    protected void addCopied(long copied) {
        this.copied += copied;
    }

    protected long getNextChunkOffset() {
        long next = this.chunkOffset;
        this.chunkOffset += this.getChunkSize();
        return next;
    }

    @VisibleForTesting
    protected long getChunkSize() {
        return this.chunkSize;
    }

    @VisibleForTesting
    protected long getRemaining() {
        return this.remaining;
    }
}

