/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.webapp.tomcat;

import brooklyn.entity.basic.Entities;
import brooklyn.entity.drivers.EntityDriver;
import brooklyn.entity.webapp.JavaWebAppSshDriver;
import brooklyn.entity.webapp.tomcat.TomcatDriver;
import brooklyn.entity.webapp.tomcat.TomcatServer;
import brooklyn.entity.webapp.tomcat.TomcatServerImpl;
import brooklyn.event.AttributeSensor;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.net.Networking;
import brooklyn.util.os.Os;
import brooklyn.util.ssh.BashCommands;
import brooklyn.util.text.StringEscapes;
import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TomcatSshDriver
extends JavaWebAppSshDriver
implements TomcatDriver {
    private static final String KEYSTORE_FILE = "keystore";

    public TomcatSshDriver(TomcatServerImpl entity, SshMachineLocation machine) {
        super(entity, machine);
    }

    public void preInstall() {
        this.resolver = Entities.newDownloader((EntityDriver)this);
        this.setExpandedInstallDir(Os.mergePaths((String[])new String[]{this.getInstallDir(), this.resolver.getUnpackedDirectoryName("apache-tomcat-" + this.getVersion())}));
    }

    public void install() {
        List urls = this.resolver.getTargets();
        String saveAs = this.resolver.getFilename();
        LinkedList<String> commands = new LinkedList<String>();
        commands.addAll(BashCommands.commandsToDownloadUrlsAs((List)urls, (String)saveAs));
        commands.add(BashCommands.INSTALL_TAR);
        commands.add(String.format("tar xvzf %s", saveAs));
        this.newScript((String)"installing").environmentVariablesReset().body.append(commands).execute();
    }

    public void customize() {
        this.newScript((String)"customizing").body.append((CharSequence)"mkdir -p conf logs webapps temp").failOnNonZeroResultCode().execute();
        this.copyTemplate((String)this.entity.getConfig(TomcatServer.SERVER_XML_RESOURCE), Os.mergePaths((String[])new String[]{this.getRunDir(), "conf", "server.xml"}));
        this.copyTemplate((String)this.entity.getConfig(TomcatServer.WEB_XML_RESOURCE), Os.mergePaths((String[])new String[]{this.getRunDir(), "conf", "web.xml"}));
        if (this.isProtocolEnabled("HTTPS")) {
            String keystoreUrl = (String)Preconditions.checkNotNull((Object)this.getSslKeystoreUrl(), (Object)("keystore URL must be specified if using HTTPS for " + this.entity));
            String destinationSslKeystoreFile = this.getHttpsSslKeystoreFile();
            InputStream keystoreStream = this.resource.getResourceFromUrl(keystoreUrl);
            this.getMachine().copyTo(keystoreStream, destinationSslKeystoreFile);
        }
        this.getEntity().deployInitialWars();
    }

    public void launch() {
        MutableMap ports = MutableMap.of((Object)"httpPort", (Object)this.getHttpPort(), (Object)"shutdownPort", (Object)this.getShutdownPort());
        Networking.checkPortsValid((Map)ports);
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"launching").body.append(new CharSequence[]{String.format("%s/bin/startup.sh >>$RUN/console 2>&1 </dev/null", this.getExpandedInstallDir()), "for i in {1..10}\ndo\n    if [ -s " + this.getLogFileLocation() + " ]; then exit; fi\n" + "    sleep 1\n" + "done\n" + "echo \"Couldn't determine if tomcat-server is running (logs/catalina.out is still empty); continuing but may subsequently fail\""}).execute();
    }

    public boolean isRunning() {
        return this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)"pid.txt"), "check-running").execute() == 0;
    }

    public void stop() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)"pid.txt"), "stopping").execute();
    }

    public void kill() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)"pid.txt"), "killing").execute();
    }

    protected List<String> getCustomJavaConfigOptions() {
        return MutableList.builder().addAll((Iterable)super.getCustomJavaConfigOptions()).add((Object)"-Xms200m").add((Object)"-Xmx800m").add((Object)"-XX:MaxPermSize=400m").build();
    }

    public Map<String, String> getShellEnvironment() {
        MutableMap shellEnv = MutableMap.builder().putAll(super.getShellEnvironment()).remove((Object)"JAVA_OPTS").put((Object)"CATALINA_PID", (Object)"pid.txt").put((Object)"CATALINA_BASE", (Object)this.getRunDir()).put((Object)"RUN", (Object)this.getRunDir()).build();
        List javaOpts = this.getJavaOpts();
        String sJavaOpts = StringEscapes.BashStringEscapes.doubleQuoteLiteralsForBash((String[])javaOpts.toArray(new String[0]));
        shellEnv.put("CATALINA_OPTS", sJavaOpts);
        return shellEnv;
    }

    protected String getLogFileLocation() {
        return Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "logs/catalina.out"});
    }

    @Override
    protected String getDeploySubdir() {
        return "webapps";
    }

    public Integer getShutdownPort() {
        return (Integer)this.entity.getAttribute((AttributeSensor)TomcatServerImpl.SHUTDOWN_PORT);
    }

    public String getHttpsSslKeystoreFile() {
        return Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "conf", KEYSTORE_FILE});
    }
}

