/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.webapp.tomcat;

import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.java.JavaAppUtils;
import brooklyn.entity.webapp.JavaWebAppSoftwareProcessImpl;
import brooklyn.entity.webapp.tomcat.TomcatDriver;
import brooklyn.entity.webapp.tomcat.TomcatServer;
import brooklyn.event.AttributeSensor;
import brooklyn.event.feed.jmx.JmxAttributePollConfig;
import brooklyn.event.feed.jmx.JmxFeed;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatServerImpl
extends JavaWebAppSoftwareProcessImpl
implements TomcatServer {
    private static final Logger LOG = LoggerFactory.getLogger(TomcatServerImpl.class);
    private volatile JmxFeed jmxWebFeed;
    private volatile JmxFeed jmxAppFeed;

    public void connectSensors() {
        super.connectSensors();
        if (this.getDriver().isJmxEnabled()) {
            String requestProcessorMbeanName = "Catalina:type=GlobalRequestProcessor,name=\"http-*\"";
            Integer port = this.isHttpsEnabled() ? (Integer)this.getAttribute((AttributeSensor)HTTPS_PORT) : (Integer)this.getAttribute((AttributeSensor)HTTP_PORT);
            String connectorMbeanName = String.format("Catalina:type=Connector,port=%s", port);
            this.jmxWebFeed = JmxFeed.builder().entity((EntityLocal)this).period(3000L, TimeUnit.MILLISECONDS).pollAttribute(new JmxAttributePollConfig((AttributeSensor)ERROR_COUNT).objectName(requestProcessorMbeanName).attributeName("errorCount")).pollAttribute(new JmxAttributePollConfig(REQUEST_COUNT).objectName(requestProcessorMbeanName).attributeName("requestCount")).pollAttribute(new JmxAttributePollConfig(TOTAL_PROCESSING_TIME).objectName(requestProcessorMbeanName).attributeName("processingTime")).pollAttribute(new JmxAttributePollConfig(CONNECTOR_STATUS).objectName(connectorMbeanName).attributeName("stateName")).pollAttribute((JmxAttributePollConfig)((JmxAttributePollConfig)new JmxAttributePollConfig(SERVICE_PROCESS_IS_RUNNING).objectName(connectorMbeanName).attributeName("stateName").onSuccess(Functions.forPredicate((Predicate)Predicates.equalTo((Object)"STARTED")))).setOnFailureOrException((Object)false)).build();
            this.jmxAppFeed = JavaAppUtils.connectMXBeanSensors((EntityLocal)this);
        } else {
            LOG.warn("Tomcat running without JMX monitoring; limited visibility of service available");
            this.connectServiceUpIsRunning();
        }
    }

    public void disconnectSensors() {
        super.disconnectSensors();
        if (this.getDriver() != null && this.getDriver().isJmxEnabled()) {
            if (this.jmxWebFeed != null) {
                this.jmxWebFeed.stop();
            }
            if (this.jmxAppFeed != null) {
                this.jmxAppFeed.stop();
            }
        } else {
            this.disconnectServiceUpIsRunning();
        }
    }

    public Class getDriverInterface() {
        return TomcatDriver.class;
    }

    public String getShortName() {
        return "Tomcat";
    }
}

