/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.webapp.tomcat;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.java.UsesJmx;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.entity.trait.HasShortName;
import brooklyn.entity.webapp.JavaWebAppSoftwareProcess;
import brooklyn.entity.webapp.tomcat.TomcatServerImpl;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.BasicAttributeSensor;
import brooklyn.event.basic.BasicAttributeSensorAndConfigKey;
import brooklyn.event.basic.PortAttributeSensorAndConfigKey;
import brooklyn.location.basic.PortRanges;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.javalang.JavaClassNames;
import brooklyn.util.time.Duration;

@Catalog(name="Tomcat Server", description="Apache Tomcat is an open source software implementation of the Java Servlet and JavaServer Pages technologies", iconUrl="classpath:///tomcat-logo.png")
@ImplementedBy(value=TomcatServerImpl.class)
public interface TomcatServer
extends JavaWebAppSoftwareProcess,
UsesJmx,
HasShortName {
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"7.0.56");
    @SetFromFlag(value="downloadUrl")
    public static final BasicAttributeSensorAndConfigKey<String> DOWNLOAD_URL = new BasicAttributeSensorAndConfigKey(SoftwareProcess.DOWNLOAD_URL, (Object)"http://download.nextag.com/apache/tomcat/tomcat-7/v${version}/bin/apache-tomcat-${version}.tar.gz");
    @SetFromFlag(value="shutdownPort")
    public static final PortAttributeSensorAndConfigKey SHUTDOWN_PORT = ConfigKeys.newPortSensorAndConfigKey((String)"tomcat.shutdownport", (String)"Suggested shutdown port", (Object)PortRanges.fromString((String)"31880+"));
    @SetFromFlag(value="server.xml")
    public static final ConfigKey<String> SERVER_XML_RESOURCE = ConfigKeys.newStringConfigKey((String)"tomcat.serverxml", (String)"The file to template and use as the Tomcat process' server.xml", (String)JavaClassNames.resolveClasspathUrl(TomcatServer.class, (String)"server.xml"));
    @SetFromFlag(value="web.xml")
    public static final ConfigKey<String> WEB_XML_RESOURCE = ConfigKeys.newStringConfigKey((String)"tomcat.webxml", (String)"The file to template and use as the Tomcat process' web.xml", (String)JavaClassNames.resolveClasspathUrl(TomcatServer.class, (String)"web.xml"));
    public static final ConfigKey<Duration> START_TIMEOUT = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.START_TIMEOUT, (Object)Duration.FIVE_MINUTES);
    public static final AttributeSensor<String> CONNECTOR_STATUS = new BasicAttributeSensor(String.class, "webapp.tomcat.connectorStatus", "Catalina connector state name");
    public static final AttributeSensor<String> JMX_SERVICE_URL = UsesJmx.JMX_URL;
}

