/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.webapp.tomcat;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.entity.webapp.tomcat.Tomcat8ServerImpl;
import brooklyn.entity.webapp.tomcat.TomcatServer;
import brooklyn.event.basic.BasicAttributeSensorAndConfigKey;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.javalang.JavaClassNames;

@Catalog(name="Tomcat Server", description="Apache Tomcat is an open source software implementation of the Java Servlet and JavaServer Pages technologies", iconUrl="classpath:///tomcat-logo.png")
@ImplementedBy(value=Tomcat8ServerImpl.class)
public interface Tomcat8Server
extends TomcatServer {
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"8.0.22");
    @SetFromFlag(value="downloadUrl")
    public static final BasicAttributeSensorAndConfigKey<String> DOWNLOAD_URL = new BasicAttributeSensorAndConfigKey(SoftwareProcess.DOWNLOAD_URL, (Object)"http://download.nextag.com/apache/tomcat/tomcat-8/v${version}/bin/apache-tomcat-${version}.tar.gz");
    @SetFromFlag(value="server.xml")
    public static final ConfigKey<String> SERVER_XML_RESOURCE = ConfigKeys.newStringConfigKey((String)"tomcat.serverxml", (String)"The file to template and use as the Tomcat process' server.xml", (String)JavaClassNames.resolveClasspathUrl(Tomcat8Server.class, (String)"tomcat8-server.xml"));
    @SetFromFlag(value="web.xml")
    public static final ConfigKey<String> WEB_XML_RESOURCE = ConfigKeys.newStringConfigKey((String)"tomcat.webxml", (String)"The file to template and use as the Tomcat process' web.xml", (String)JavaClassNames.resolveClasspathUrl(Tomcat8Server.class, (String)"tomcat8-web.xml"));
}

