/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.webapp.nodejs;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.SoftwareProcessImpl;
import brooklyn.entity.webapp.WebAppServiceMethods;
import brooklyn.entity.webapp.nodejs.NodeJsWebAppDriver;
import brooklyn.entity.webapp.nodejs.NodeJsWebAppService;
import brooklyn.event.AttributeSensor;
import brooklyn.event.feed.ConfigToAttributes;
import brooklyn.event.feed.http.HttpFeed;
import brooklyn.event.feed.http.HttpPollConfig;
import brooklyn.event.feed.http.HttpValueFunctions;
import brooklyn.location.access.BrooklynAccessUtils;
import com.google.common.base.Predicates;
import com.google.common.net.HostAndPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeJsWebAppServiceImpl
extends SoftwareProcessImpl
implements NodeJsWebAppService {
    private static final Logger LOG = LoggerFactory.getLogger(NodeJsWebAppService.class);
    private transient HttpFeed httpFeed;

    public Class<?> getDriverInterface() {
        return NodeJsWebAppDriver.class;
    }

    public NodeJsWebAppDriver getDriver() {
        return (NodeJsWebAppDriver)super.getDriver();
    }

    protected void connectSensors() {
        super.connectSensors();
        ConfigToAttributes.apply((EntityLocal)this);
        HostAndPort accessible = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)this, (int)this.getHttpPort());
        String nodeJsUrl = String.format("http://%s:%d", accessible.getHostText(), accessible.getPort());
        LOG.info("Connecting to {}", (Object)nodeJsUrl);
        this.httpFeed = HttpFeed.builder().entity((EntityLocal)this).baseUri(nodeJsUrl).poll((HttpPollConfig)((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(SERVICE_UP).suburl((String)this.getConfig(NodeJsWebAppService.SERVICE_UP_PATH)).checkSuccess(Predicates.alwaysTrue())).onSuccess(HttpValueFunctions.responseCodeEquals((int)200))).setOnException((Object)false)).build();
        WebAppServiceMethods.connectWebAppServerPolicies((EntityLocal)this);
    }

    public void disconnectSensors() {
        if (this.httpFeed != null) {
            this.httpFeed.stop();
        }
        super.disconnectSensors();
    }

    protected void postStop() {
        super.postStop();
        this.setAttribute(REQUESTS_PER_SECOND_LAST, 0.0);
        this.setAttribute(REQUESTS_PER_SECOND_IN_WINDOW, 0.0);
    }

    @Override
    public Integer getHttpPort() {
        return (Integer)this.getAttribute((AttributeSensor)Attributes.HTTP_PORT);
    }
}

