/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.webapp.nodejs;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.entity.webapp.WebAppService;
import brooklyn.entity.webapp.nodejs.NodeJsWebAppServiceImpl;
import brooklyn.location.PortRange;
import brooklyn.location.basic.PortRanges;
import brooklyn.util.flags.SetFromFlag;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.util.List;

@Catalog(name="Node.JS Application", description="Node.js is a cross-platform runtime environment for server-side and networking applications. Node.js applications are written in JavaScriptq", iconUrl="classpath:///nodejs-logo.png")
@ImplementedBy(value=NodeJsWebAppServiceImpl.class)
public interface NodeJsWebAppService
extends SoftwareProcess,
WebAppService {
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"stable");
    @SetFromFlag(value="httpPort")
    public static final ConfigKey<PortRange> HTTP_PORT = ConfigKeys.newConfigKeyWithDefault((ConfigKey)Attributes.HTTP_PORT.getConfigKey(), (Object)PortRanges.fromInteger((int)3000));
    @SetFromFlag(value="gitRepoUrl")
    public static final ConfigKey<String> APP_GIT_REPOSITORY_URL = ConfigKeys.newStringConfigKey((String)"nodejs.gitRepo.url", (String)"The Git repository where the application is hosted");
    @SetFromFlag(value="archiveUrl")
    public static final ConfigKey<String> APP_ARCHIVE_URL = ConfigKeys.newStringConfigKey((String)"nodejs.archive.url", (String)"The URL where the application archive is hosted");
    @SetFromFlag(value="appFileName")
    public static final ConfigKey<String> APP_FILE = ConfigKeys.newStringConfigKey((String)"nodejs.app.fileName", (String)"The NodeJS application file to start", (String)"app.js");
    @SetFromFlag(value="appName")
    public static final ConfigKey<String> APP_NAME = ConfigKeys.newStringConfigKey((String)"nodejs.app.name", (String)"The name of the NodeJS application");
    @SetFromFlag(value="appCommand")
    public static final ConfigKey<String> APP_COMMAND = ConfigKeys.newStringConfigKey((String)"nodejs.app.command", (String)"Command to start the NodeJS application (defaults to node)", (String)"node");
    @SetFromFlag(value="appCommandLine")
    public static final ConfigKey<String> APP_COMMAND_LINE = ConfigKeys.newStringConfigKey((String)"nodejs.app.commandLine", (String)"Replacement command line to start the NodeJS application (ignores command and file if set)");
    @SetFromFlag(value="nodePackages")
    public static final ConfigKey<List<String>> NODE_PACKAGE_LIST = ConfigKeys.newConfigKey((TypeToken)new TypeToken<List<String>>(){}, (String)"nodejs.packages", (String)"The NPM packages to install", (Object)ImmutableList.of());
    public static final ConfigKey<String> SERVICE_UP_PATH = ConfigKeys.newStringConfigKey((String)"nodejs.serviceUp.path", (String)"Path to use when checking the NodeJS application is running", (String)"/");

    public Integer getHttpPort();
}

