/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.webapp.jetty;

import brooklyn.entity.basic.Entities;
import brooklyn.entity.drivers.EntityDriver;
import brooklyn.entity.webapp.JavaWebAppSshDriver;
import brooklyn.entity.webapp.jetty.Jetty6Driver;
import brooklyn.entity.webapp.jetty.Jetty6Server;
import brooklyn.entity.webapp.jetty.Jetty6ServerImpl;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.net.Networking;
import brooklyn.util.os.Os;
import brooklyn.util.ssh.BashCommands;
import brooklyn.util.text.Strings;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Jetty6SshDriver
extends JavaWebAppSshDriver
implements Jetty6Driver {
    public Jetty6SshDriver(Jetty6ServerImpl entity, SshMachineLocation machine) {
        super(entity, machine);
    }

    protected String getLogFileLocation() {
        return Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "logs", "*.stderrout.log"});
    }

    @Override
    protected String getDeploySubdir() {
        return "webapps";
    }

    public void preInstall() {
        this.resolver = Entities.newDownloader((EntityDriver)this);
        this.setExpandedInstallDir(Os.mergePaths((String[])new String[]{this.getInstallDir(), this.resolver.getUnpackedDirectoryName(String.format("jetty-%s", this.getVersion()))}));
    }

    public void install() {
        List urls = this.resolver.getTargets();
        String saveAs = this.resolver.getFilename();
        LinkedList<String> commands = new LinkedList<String>();
        commands.addAll(BashCommands.commandsToDownloadUrlsAs((List)urls, (String)saveAs));
        commands.add(BashCommands.INSTALL_ZIP);
        commands.add("unzip " + saveAs);
        this.newScript((String)"installing").body.append(commands).execute();
    }

    public void customize() {
        this.newScript((String)"customizing").body.append(new CharSequence[]{"mkdir logs contexts webapps", String.format("for x in start.jar bin contrib modules lib extras; do ln -s %s/$x $x ; done", this.getExpandedInstallDir()), String.format("for x in etc resources; do cp -r %s/$x $x ; done", this.getExpandedInstallDir())}).execute();
        String destinationBrooklynConfig = Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "etc/jetty-brooklyn.xml"});
        this.copyTemplate("classpath://brooklyn/entity/webapp/jetty/jetty-brooklyn.xml", destinationBrooklynConfig);
        String customConfigTemplateUrl = this.getConfigXmlTemplateUrl();
        if (Strings.isNonEmpty((CharSequence)customConfigTemplateUrl)) {
            String destinationConfigFile = Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "etc/jetty-custom.xml"});
            this.copyTemplate(customConfigTemplateUrl, destinationConfigFile);
        }
        this.getEntity().deployInitialWars();
    }

    private String getConfigXmlTemplateUrl() {
        return (String)this.getEntity().getConfig(Jetty6Server.CONFIG_XML_TEMPLATE_URL);
    }

    public void launch() {
        MutableMap ports = MutableMap.of((Object)"httpPort", (Object)this.getHttpPort(), (Object)"jmxPort", (Object)this.getJmxPort(), (Object)"rmiRegistryPort", (Object)this.getRmiRegistryPort());
        Networking.checkPortsValid((Map)ports);
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"launching").body.append(new CharSequence[]{"./bin/jetty.sh start jetty-brooklyn.xml jetty.xml jetty-logging.xml jetty-stats.xml " + (Strings.isEmpty((CharSequence)this.getConfigXmlTemplateUrl()) ? "" : "jetty-custom.xml ") + ">> $RUN_DIR/console 2>&1 < /dev/null", "for i in {1..10} ; do\n    if [ -s " + this.getLogFileLocation() + " ]; then exit; fi\n" + "    sleep 1\n" + "done", "echo \"Couldn't determine if jetty-server is running (log file is still empty); continuing but may subsequently fail\""}).execute();
        log.debug("launched jetty");
    }

    public boolean isRunning() {
        return this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)"jetty.pid"), "check-running").execute() == 0;
    }

    public void stop() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"stopping").body.append((CharSequence)"./bin/jetty.sh stop").execute();
    }

    public void kill1() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)"jetty.pid"), "stopping").execute();
    }

    public void kill9() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)"jetty.pid"), "killing").execute();
    }

    public void kill() {
        this.kill9();
    }

    protected List<String> getCustomJavaConfigOptions() {
        return MutableList.builder().addAll((Iterable)super.getCustomJavaConfigOptions()).add((Object)"-Xms200m").add((Object)"-Xmx800m").add((Object)"-XX:MaxPermSize=400m").build();
    }

    public Map<String, String> getShellEnvironment() {
        return MutableMap.builder().putAll(super.getShellEnvironment()).put((Object)"JETTY_RUN", (Object)this.getRunDir()).put((Object)"JETTY_HOME", (Object)this.getRunDir()).put((Object)"JETTY_LOGS", (Object)Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "logs"})).put((Object)"JETTY_PORT", (Object)this.getHttpPort().toString()).renameKey((Object)"JAVA_OPTS", (Object)"JAVA_OPTIONS").build();
    }
}

