/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.webapp.jetty;

import brooklyn.enricher.Enrichers;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.entity.java.JavaAppUtils;
import brooklyn.entity.java.UsesJmx;
import brooklyn.entity.webapp.JavaWebAppSoftwareProcessImpl;
import brooklyn.entity.webapp.jetty.Jetty6Driver;
import brooklyn.entity.webapp.jetty.Jetty6Server;
import brooklyn.event.AttributeSensor;
import brooklyn.event.feed.jmx.JmxAttributePollConfig;
import brooklyn.event.feed.jmx.JmxFeed;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jetty6ServerImpl
extends JavaWebAppSoftwareProcessImpl
implements Jetty6Server {
    private static final Logger log = LoggerFactory.getLogger(Jetty6ServerImpl.class);
    private volatile JmxFeed jmxFeedJetty;
    private volatile JmxFeed jmxFeedMx;

    public void connectSensors() {
        super.connectSensors();
        if (this.getDriver().isJmxEnabled()) {
            String serverMbeanName = "org.mortbay.jetty:type=server,id=0";
            String statsMbeanName = "org.mortbay.jetty.handler:type=atomicstatisticshandler,id=0";
            this.jmxFeedJetty = JmxFeed.builder().entity((EntityLocal)this).period(500L, TimeUnit.MILLISECONDS).pollAttribute((JmxAttributePollConfig)((JmxAttributePollConfig)new JmxAttributePollConfig(SERVICE_UP).objectName(serverMbeanName).attributeName("running").onSuccess(Functions.forPredicate((Predicate)Predicates.equalTo((Object)true)))).setOnFailureOrException((Object)false)).pollAttribute(new JmxAttributePollConfig(REQUEST_COUNT).objectName(statsMbeanName).attributeName("requests")).pollAttribute(new JmxAttributePollConfig(RESPONSES_4XX_COUNT).objectName(statsMbeanName).attributeName("responses4xx")).pollAttribute(new JmxAttributePollConfig(RESPONSES_5XX_COUNT).objectName(statsMbeanName).attributeName("responses5xx")).pollAttribute(new JmxAttributePollConfig(TOTAL_PROCESSING_TIME).objectName(statsMbeanName).attributeName("requestTimeTotal")).pollAttribute(new JmxAttributePollConfig(MAX_PROCESSING_TIME).objectName(statsMbeanName).attributeName("requestTimeMax")).build();
            this.addEnricher(((Enrichers.CombinerBuilder)Enrichers.builder().combining(new AttributeSensor[]{RESPONSES_4XX_COUNT, RESPONSES_5XX_COUNT}).publishing((AttributeSensor)ERROR_COUNT).computingSum()).build());
            this.jmxFeedMx = JavaAppUtils.connectMXBeanSensors((EntityLocal)this);
        } else {
            log.warn("Jetty running without JMX monitoring; limited visibility of service available");
        }
    }

    protected void disconnectSensors() {
        if (this.jmxFeedJetty != null) {
            this.jmxFeedJetty.stop();
        }
        if (this.jmxFeedMx != null) {
            this.jmxFeedMx.stop();
        }
        super.disconnectSensors();
    }

    public Integer getJmxPort() {
        if (((Jetty6Driver)this.getDriver()).isJmxEnabled()) {
            return (Integer)this.getAttribute((AttributeSensor)UsesJmx.JMX_PORT);
        }
        return -1;
    }

    public Class getDriverInterface() {
        return Jetty6Driver.class;
    }

    public String getShortName() {
        return "Jetty";
    }

    @Override
    public void deploy(String url, String targetName) {
        super.deploy(url, targetName);
        this.restartIfRunning();
    }

    @Override
    public void undeploy(String targetName) {
        super.undeploy(targetName);
        this.restartIfRunning();
    }

    protected void restartIfRunning() {
        Lifecycle serviceState = (Lifecycle)this.getAttribute(SERVICE_STATE_ACTUAL);
        if (serviceState == Lifecycle.RUNNING) {
            this.restart();
        }
    }
}

