/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.webapp.jetty;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.java.UsesJmx;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.entity.trait.HasShortName;
import brooklyn.entity.webapp.JavaWebAppSoftwareProcess;
import brooklyn.entity.webapp.jetty.Jetty6ServerImpl;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.BasicAttributeSensorAndConfigKey;
import brooklyn.event.basic.Sensors;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.time.Duration;

@Catalog(name="Jetty6 Server", description="Old version (v6 @ Mortbay) of the popular Jetty webapp container", iconUrl="classpath:///jetty-logo.png")
@ImplementedBy(value=Jetty6ServerImpl.class)
public interface Jetty6Server
extends JavaWebAppSoftwareProcess,
UsesJmx,
HasShortName {
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"6.1.26");
    public static final ConfigKey<Duration> START_TIMEOUT = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.START_TIMEOUT, (Object)Duration.FIVE_MINUTES);
    @SetFromFlag(value="configXmlTemplateUrl")
    public static final ConfigKey<String> CONFIG_XML_TEMPLATE_URL = ConfigKeys.newStringConfigKey((String)"jetty.configXml.templateUrl", (String)"Extra XML configuration file template URL if required");
    @SetFromFlag(value="downloadUrl")
    public static final BasicAttributeSensorAndConfigKey<String> DOWNLOAD_URL = new BasicAttributeSensorAndConfigKey(SoftwareProcess.DOWNLOAD_URL, (Object)"http://get.jenv.mvnsearch.org/download/jetty/jetty-${version}.zip");
    public static final AttributeSensor<Integer> RESPONSES_4XX_COUNT = Sensors.newIntegerSensor((String)"webapp.responses.4xx", (String)"Responses in the 400's");
    public static final AttributeSensor<Integer> RESPONSES_5XX_COUNT = Sensors.newIntegerSensor((String)"webapp.responses.5xx", (String)"Responses in the 500's");
}

