/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.webapp.jboss;

import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.drivers.EntityDriver;
import brooklyn.entity.webapp.JavaWebAppSshDriver;
import brooklyn.entity.webapp.jboss.JBoss7Driver;
import brooklyn.entity.webapp.jboss.JBoss7Server;
import brooklyn.entity.webapp.jboss.JBoss7ServerImpl;
import brooklyn.event.AttributeSensor;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.net.Networking;
import brooklyn.util.os.Os;
import brooklyn.util.ssh.BashCommands;
import brooklyn.util.text.Strings;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JBoss7SshDriver
extends JavaWebAppSshDriver
implements JBoss7Driver {
    private static final Logger LOG = LoggerFactory.getLogger(JBoss7SshDriver.class);
    public static final String SERVER_TYPE = "standalone";
    public static final String CONFIG_FILE = "standalone-brooklyn.xml";
    public static final String KEYSTORE_FILE = ".keystore";
    public static final String MANAGEMENT_REALM = "ManagementRealm";

    public JBoss7SshDriver(JBoss7ServerImpl entity, SshMachineLocation machine) {
        super(entity, machine);
    }

    @Override
    public JBoss7ServerImpl getEntity() {
        return (JBoss7ServerImpl)super.getEntity();
    }

    @Override
    public String getSslKeystoreFile() {
        return Os.mergePathsUnix((String[])new String[]{this.getRunDir(), SERVER_TYPE, "configuration", KEYSTORE_FILE});
    }

    protected String getTemplateConfigurationUrl() {
        return (String)this.entity.getConfig(JBoss7Server.TEMPLATE_CONFIGURATION_URL);
    }

    protected String getLogFileLocation() {
        return Os.mergePathsUnix((String[])new String[]{this.getRunDir(), SERVER_TYPE, "log/server.log"});
    }

    @Override
    protected String getDeploySubdir() {
        return Os.mergePathsUnix((String[])new String[]{SERVER_TYPE, "deployments"});
    }

    private Integer getManagementHttpPort() {
        return (Integer)this.entity.getAttribute((AttributeSensor)JBoss7Server.MANAGEMENT_HTTP_PORT);
    }

    private Integer getManagementHttpsPort() {
        return (Integer)this.entity.getAttribute((AttributeSensor)JBoss7Server.MANAGEMENT_HTTPS_PORT);
    }

    private Integer getManagementNativePort() {
        return (Integer)this.entity.getAttribute((AttributeSensor)JBoss7Server.MANAGEMENT_NATIVE_PORT);
    }

    private String getManagementUsername() {
        return (String)this.entity.getConfig(JBoss7Server.MANAGEMENT_USER);
    }

    private String getManagementPassword() {
        return (String)this.entity.getConfig(JBoss7Server.MANAGEMENT_PASSWORD);
    }

    public void preInstall() {
        this.resolver = Entities.newDownloader((EntityDriver)this);
        this.setExpandedInstallDir(Os.mergePaths((String[])new String[]{this.getInstallDir(), this.resolver.getUnpackedDirectoryName(String.format("jboss-as-%s", this.getVersion()))}));
    }

    public void install() {
        List urls = this.resolver.getTargets();
        String saveAs = this.resolver.getFilename();
        LinkedList<String> commands = new LinkedList<String>();
        commands.addAll(BashCommands.commandsToDownloadUrlsAs((List)urls, (String)saveAs));
        commands.add(BashCommands.INSTALL_TAR);
        commands.add("tar xzfv " + saveAs);
        this.newScript((String)"installing").environmentVariablesReset().body.append(commands).execute();
    }

    public void customize() {
        Preconditions.checkState((boolean)Strings.isNonBlank((CharSequence)this.getManagementUsername()), (Object)"User for management realm required");
        String managementPassword = this.getManagementPassword();
        if (Strings.isBlank((CharSequence)managementPassword)) {
            LOG.debug(this + " has no password specified for " + JBoss7Server.MANAGEMENT_PASSWORD.getName() + "; using a random string");
            this.entity.setConfig(JBoss7Server.MANAGEMENT_PASSWORD, (Object)Strings.makeRandomId((int)8));
        }
        String hashedPassword = JBoss7SshDriver.hashPassword(this.getManagementUsername(), this.getManagementPassword(), MANAGEMENT_REALM);
        MutableMap ports = MutableMap.builder().put((Object)"managementHttpPort", (Object)this.getManagementHttpPort()).put((Object)"managementHttpsPort", (Object)this.getManagementHttpsPort()).put((Object)"managementNativePort", (Object)this.getManagementNativePort()).build();
        if (this.isProtocolEnabled("HTTP")) {
            ports.put("httpPort", this.getHttpPort());
        }
        if (this.isProtocolEnabled("HTTPS")) {
            ports.put("httpsPort", this.getHttpsPort());
        }
        Networking.checkPortsValid((Map)ports);
        String hostname = (String)this.entity.getAttribute(SoftwareProcess.HOSTNAME);
        Preconditions.checkNotNull((Object)hostname, (Object)"AS 7 entity must set hostname otherwise server will only be visible on localhost");
        this.newScript((String)"customizing").environmentVariablesReset().body.append(new CharSequence[]{String.format("cp -r %s/%s . || exit $!", this.getExpandedInstallDir(), SERVER_TYPE), String.format("echo -e '\n%s=%s' >> %s/%s/configuration/mgmt-users.properties", this.getManagementUsername(), hashedPassword, this.getRunDir(), SERVER_TYPE)}).execute();
        if (this.isProtocolEnabled("HTTPS")) {
            String keystoreUrl = (String)Preconditions.checkNotNull((Object)this.getSslKeystoreUrl(), (Object)("keystore URL must be specified if using HTTPS for " + this.entity));
            String destinationSslKeystoreFile = this.getSslKeystoreFile();
            InputStream keystoreStream = this.resource.getResourceFromUrl(keystoreUrl);
            this.getMachine().copyTo(keystoreStream, destinationSslKeystoreFile);
        }
        String destinationConfigFile = Os.mergePathsUnix((String[])new String[]{this.getRunDir(), SERVER_TYPE, "configuration", CONFIG_FILE});
        this.copyTemplate(this.getTemplateConfigurationUrl(), destinationConfigFile);
        this.getEntity().deployInitialWars();
    }

    public void launch() {
        this.entity.setAttribute(JBoss7Server.PID_FILE, (Object)Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "pid.txt"}));
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"launching").body.append(new CharSequence[]{"export LAUNCH_JBOSS_IN_BACKGROUND=true", String.format("export JBOSS_HOME=%s", this.getExpandedInstallDir()), String.format("export JBOSS_PIDFILE=%s/%s", this.getRunDir(), "pid.txt"), String.format("%s/bin/%s.sh ", this.getExpandedInstallDir(), SERVER_TYPE) + String.format("--server-config %s ", CONFIG_FILE) + String.format("-Djboss.server.base.dir=%s/%s ", this.getRunDir(), SERVER_TYPE) + String.format("\"-Djboss.server.base.url=file://%s/%s\" ", this.getRunDir(), SERVER_TYPE) + "-Djava.net.preferIPv4Stack=true " + "-Djava.net.preferIPv6Addresses=false " + String.format(" >> %s/console 2>&1 </dev/null &", this.getRunDir()), "for i in {1..10}\ndo\n    grep -i 'starting' " + this.getRunDir() + "/console && exit\n" + "    sleep 1\n" + "done\n" + "echo \"Couldn't determine if process is running (console output does not contain 'starting'); continuing but may subsequently fail\""}).execute();
    }

    public boolean isRunning() {
        return this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)true), "check-running").execute() == 0;
    }

    public void stop() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)true), "stopping").environmentVariablesReset().execute();
    }

    public void kill() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)true), "killing").execute();
    }

    protected List<String> getCustomJavaConfigOptions() {
        return MutableList.builder().addAll((Iterable)super.getCustomJavaConfigOptions()).add((Object)"-Xms200m").add((Object)"-Xmx800m").add((Object)"-XX:MaxPermSize=400m").build();
    }

    public static String hashPassword(String username, String password, String realm) {
        String concat = username + ":" + realm + ":" + password;
        byte[] hashed = Hashing.md5().hashString((CharSequence)concat, Charsets.UTF_8).asBytes();
        return BaseEncoding.base16().lowerCase().encode(hashed);
    }
}

