/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.webapp.jboss;

import brooklyn.config.ConfigKey;
import brooklyn.config.render.RendererHints;
import brooklyn.enricher.Enrichers;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.webapp.JavaWebAppSoftwareProcessImpl;
import brooklyn.entity.webapp.jboss.JBoss7Driver;
import brooklyn.entity.webapp.jboss.JBoss7Server;
import brooklyn.event.AttributeSensor;
import brooklyn.event.feed.http.HttpFeed;
import brooklyn.event.feed.http.HttpPollConfig;
import brooklyn.event.feed.http.HttpValueFunctions;
import brooklyn.location.access.BrooklynAccessUtils;
import brooklyn.util.guava.Functionals;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JBoss7ServerImpl
extends JavaWebAppSoftwareProcessImpl
implements JBoss7Server {
    public static final Logger log = LoggerFactory.getLogger(JBoss7ServerImpl.class);
    private volatile HttpFeed httpFeed;

    public JBoss7ServerImpl() {
    }

    public JBoss7ServerImpl(Map flags) {
        this(flags, null);
    }

    public JBoss7ServerImpl(Map flags, Entity parent) {
        super(flags, parent);
    }

    public Class<?> getDriverInterface() {
        return JBoss7Driver.class;
    }

    @Override
    public JBoss7Driver getDriver() {
        return (JBoss7Driver)super.getDriver();
    }

    protected void connectSensors() {
        super.connectSensors();
        HostAndPort hp = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)this, (int)((Integer)this.getAttribute((AttributeSensor)MANAGEMENT_HTTP_PORT) + (Integer)this.getConfig(PORT_INCREMENT)));
        String managementUri = String.format("http://%s:%s/management/subsystem/web/connector/http/read-resource", hp.getHostText(), hp.getPort());
        this.setAttribute(MANAGEMENT_URL, managementUri);
        log.debug("JBoss sensors for " + this + " reading from " + managementUri);
        ImmutableMap includeRuntimeUriVars = ImmutableMap.of((Object)"include-runtime", (Object)"true");
        this.httpFeed = HttpFeed.builder().entity((EntityLocal)this).period(200L).baseUri(managementUri).credentials((String)this.getConfig(MANAGEMENT_USER), (String)this.getConfig(MANAGEMENT_PASSWORD)).poll((HttpPollConfig)new HttpPollConfig(MANAGEMENT_STATUS).onSuccess(HttpValueFunctions.responseCode())).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(MANAGEMENT_URL_UP).onSuccess(HttpValueFunctions.responseCodeEquals((int)200))).onFailureOrException(Functions.constant((Object)false))).poll((HttpPollConfig)new HttpPollConfig(REQUEST_COUNT).vars((Map)includeRuntimeUriVars).onSuccess(HttpValueFunctions.jsonContents((String)"requestCount", Integer.class))).poll((HttpPollConfig)new HttpPollConfig((AttributeSensor)ERROR_COUNT).vars((Map)includeRuntimeUriVars).onSuccess(HttpValueFunctions.jsonContents((String)"errorCount", Integer.class))).poll((HttpPollConfig)new HttpPollConfig(TOTAL_PROCESSING_TIME).vars((Map)includeRuntimeUriVars).onSuccess(HttpValueFunctions.jsonContents((String)"processingTime", Integer.class))).poll((HttpPollConfig)new HttpPollConfig(MAX_PROCESSING_TIME).vars((Map)includeRuntimeUriVars).onSuccess(HttpValueFunctions.jsonContents((String)"maxTime", Integer.class))).poll((HttpPollConfig)new HttpPollConfig(BYTES_RECEIVED).vars((Map)includeRuntimeUriVars).onSuccess(HttpValueFunctions.jsonContents((String)"bytesReceived", Long.class))).poll((HttpPollConfig)new HttpPollConfig(BYTES_SENT).vars((Map)includeRuntimeUriVars).onSuccess(HttpValueFunctions.jsonContents((String)"bytesSent", Long.class))).build();
        this.connectServiceUp();
    }

    protected void connectServiceUp() {
        this.connectServiceUpIsRunning();
        this.addEnricher(((Enrichers.UpdatingMapBuilder)Enrichers.builder().updatingMap(Attributes.SERVICE_NOT_UP_INDICATORS).from(MANAGEMENT_URL_UP).computing((Function)Functionals.ifNotEquals((Object)true).value((Object)"Management URL not reachable"))).build());
    }

    protected void disconnectServiceUp() {
        this.disconnectServiceUpIsRunning();
    }

    protected void disconnectSensors() {
        super.disconnectSensors();
        if (this.httpFeed != null) {
            this.httpFeed.stop();
        }
        this.disconnectServiceUp();
    }

    public int getManagementHttpsPort() {
        return (Integer)this.getAttribute((AttributeSensor)MANAGEMENT_HTTPS_PORT);
    }

    public int getManagementHttpPort() {
        return (Integer)this.getAttribute((AttributeSensor)MANAGEMENT_HTTP_PORT);
    }

    public int getManagementNativePort() {
        return (Integer)this.getAttribute((AttributeSensor)MANAGEMENT_NATIVE_PORT);
    }

    public int getPortOffset() {
        return (Integer)this.getConfig(PORT_INCREMENT);
    }

    public boolean isWelcomeRootEnabled() {
        return false;
    }

    public String getBindAddress() {
        return (String)this.getConfig((ConfigKey.HasConfigKey)BIND_ADDRESS);
    }

    public String getManagementBindAddress() {
        return (String)this.getConfig((ConfigKey.HasConfigKey)BIND_ADDRESS);
    }

    public String getUnsecureBindAddress() {
        return (String)this.getConfig((ConfigKey.HasConfigKey)BIND_ADDRESS);
    }

    public String getHttpManagementInterfaceSecurityRealm() {
        return "";
    }

    public int getDeploymentTimeoutSecs() {
        return (Integer)this.getConfig(DEPLOYMENT_TIMEOUT);
    }

    public String getHttpsSslKeystoreFile() {
        return this.getDriver().getSslKeystoreFile();
    }

    public String getShortName() {
        return "JBossAS7";
    }

    static {
        RendererHints.register((AttributeSensor)MANAGEMENT_URL, (RendererHints.Hint)RendererHints.namedActionWithUrl());
    }
}

