/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.webapp.jboss;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.entity.trait.HasShortName;
import brooklyn.entity.webapp.JavaWebAppSoftwareProcess;
import brooklyn.entity.webapp.jboss.JBoss7ServerImpl;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.BasicAttributeSensorAndConfigKey;
import brooklyn.event.basic.PortAttributeSensorAndConfigKey;
import brooklyn.event.basic.Sensors;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.javalang.JavaClassNames;

@Catalog(name="JBoss Application Server 7", description="AS7: an open source Java application server from JBoss", iconUrl="classpath:///jboss-logo.png")
@ImplementedBy(value=JBoss7ServerImpl.class)
public interface JBoss7Server
extends JavaWebAppSoftwareProcess,
HasShortName {
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"7.1.1.Final");
    @SetFromFlag(value="downloadUrl")
    public static final BasicAttributeSensorAndConfigKey<String> DOWNLOAD_URL = new BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey(SoftwareProcess.DOWNLOAD_URL, "http://download.jboss.org/jbossas/7.1/jboss-as-${version}/jboss-as-${version}.tar.gz");
    @SetFromFlag(value="bindAddress")
    public static final BasicAttributeSensorAndConfigKey<String> BIND_ADDRESS = new BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey("jboss.bind.address", "Address of interface JBoss should listen on, defaulting 0.0.0.0 (but could set e.g. to attributeWhenReady(HOSTNAME)", "0.0.0.0");
    @SetFromFlag(value="managementHttpPort")
    public static final PortAttributeSensorAndConfigKey MANAGEMENT_HTTP_PORT = new PortAttributeSensorAndConfigKey("webapp.jboss.managementHttpPort", "Management port", (Object)"9990+");
    @SetFromFlag(value="managementHttpsPort")
    public static final PortAttributeSensorAndConfigKey MANAGEMENT_HTTPS_PORT = new PortAttributeSensorAndConfigKey("webapp.jboss.managementHttpsPort", "Management port", (Object)"9443+");
    @SetFromFlag(value="managementNativePort")
    public static final PortAttributeSensorAndConfigKey MANAGEMENT_NATIVE_PORT = new PortAttributeSensorAndConfigKey("webapp.jboss.managementNativePort", "Management native port", (Object)"10999+");
    @SetFromFlag(value="portIncrement")
    public static final ConfigKey<Integer> PORT_INCREMENT = ConfigKeys.newConfigKey((String)"webapp.jboss.portIncrement", (String)"Port increment for all ports in config file", (Object)0);
    @SetFromFlag(value="deploymentTimeout")
    public static final ConfigKey<Integer> DEPLOYMENT_TIMEOUT = ConfigKeys.newConfigKey((String)"webapp.jboss.deploymentTimeout", (String)"Deployment timeout, in seconds", (Object)600);
    public static final ConfigKey<String> TEMPLATE_CONFIGURATION_URL = ConfigKeys.newConfigKey((String)"webapp.jboss.templateConfigurationUrl", (String)"Template file (in freemarker format) for the standalone.xml file", (Object)JavaClassNames.resolveClasspathUrl(JBoss7Server.class, (String)"jboss7-standalone.xml"));
    @SetFromFlag(value="managementUser")
    public static final ConfigKey<String> MANAGEMENT_USER = ConfigKeys.newConfigKey((String)"webapp.jboss.managementUser", (String)"A user to be placed in the management realm. Brooklyn will use this user to poll sensors", (Object)"brooklyn");
    @SetFromFlag(value="managementPassword")
    public static final ConfigKey<String> MANAGEMENT_PASSWORD = ConfigKeys.newStringConfigKey((String)"webapp.jboss.managementPassword", (String)"Password for MANAGEMENT_USER.");
    public static final AttributeSensor<String> MANAGEMENT_URL = Sensors.newStringSensor((String)"webapp.jboss.managementUrl", (String)"URL where management endpoint is available");
    public static final AttributeSensor<Integer> MANAGEMENT_STATUS = Sensors.newIntegerSensor((String)"webapp.jboss.managementStatus", (String)"HTTP response code for the management server");
    public static final AttributeSensor<Boolean> MANAGEMENT_URL_UP = Sensors.newBooleanSensor((String)"webapp.jboss.managementUp", (String)"Management server is responding with OK");
    public static final AttributeSensor<String> PID_FILE = Sensors.newStringSensor((String)"jboss.pid.file", (String)"PID file");
}

