/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.webapp.jboss;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.webapp.JavaWebAppSoftwareProcessImpl;
import brooklyn.entity.webapp.jboss.JBoss6Driver;
import brooklyn.entity.webapp.jboss.JBoss6Server;
import brooklyn.event.AttributeSensor;
import brooklyn.event.feed.jmx.JmxAttributePollConfig;
import brooklyn.event.feed.jmx.JmxFeed;
import com.google.common.base.Functions;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JBoss6ServerImpl
extends JavaWebAppSoftwareProcessImpl
implements JBoss6Server {
    public static final Logger log = LoggerFactory.getLogger(JBoss6ServerImpl.class);
    private volatile JmxFeed jmxFeed;

    public JBoss6ServerImpl() {
        this(new LinkedHashMap(), null);
    }

    public JBoss6ServerImpl(Entity parent) {
        this(new LinkedHashMap(), parent);
    }

    public JBoss6ServerImpl(Map flags) {
        this(flags, null);
    }

    public JBoss6ServerImpl(Map flags, Entity parent) {
        super(flags, parent);
    }

    public void connectSensors() {
        super.connectSensors();
        String requestProcessorMbeanName = "jboss.web:type=GlobalRequestProcessor,name=http-*";
        String serverMbeanName = "jboss.system:type=Server";
        this.jmxFeed = JmxFeed.builder().entity((EntityLocal)this).period(500L, TimeUnit.MILLISECONDS).pollAttribute(new JmxAttributePollConfig((AttributeSensor)ERROR_COUNT).objectName(requestProcessorMbeanName).attributeName("errorCount")).pollAttribute(new JmxAttributePollConfig(REQUEST_COUNT).objectName(requestProcessorMbeanName).attributeName("requestCount")).pollAttribute(new JmxAttributePollConfig(TOTAL_PROCESSING_TIME).objectName(requestProcessorMbeanName).attributeName("processingTime")).pollAttribute((JmxAttributePollConfig)new JmxAttributePollConfig(SERVICE_UP).objectName(serverMbeanName).attributeName("Started").onException(Functions.constant((Object)false))).build();
    }

    public void disconnectSensors() {
        super.disconnectSensors();
        if (this.jmxFeed != null) {
            this.jmxFeed.stop();
        }
    }

    public Class<JBoss6Driver> getDriverInterface() {
        return JBoss6Driver.class;
    }
}

