/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.webapp.jboss;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.java.UsesJmx;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.entity.webapp.JavaWebAppSoftwareProcess;
import brooklyn.entity.webapp.jboss.JBoss6ServerImpl;
import brooklyn.event.basic.BasicAttributeSensorAndConfigKey;
import brooklyn.util.flags.SetFromFlag;

@Catalog(name="JBoss Application Server 6", description="AS6: an open source Java application server from JBoss", iconUrl="classpath:///jboss-logo.png")
@ImplementedBy(value=JBoss6ServerImpl.class)
public interface JBoss6Server
extends JavaWebAppSoftwareProcess,
UsesJmx {
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"6.0.0.Final");
    @SetFromFlag(value="downloadUrl")
    public static final BasicAttributeSensorAndConfigKey<String> DOWNLOAD_URL = new BasicAttributeSensorAndConfigKey(SoftwareProcess.DOWNLOAD_URL, (Object)"http://downloads.sourceforge.net/project/jboss/JBoss/JBoss-${version}/jboss-as-distribution-${version}.zip?r=http%3A%2F%2Fsourceforge.net%2Fprojects%2Fjboss%2Ffiles%2FJBoss%2F${version}%2F&ts=1307104229&use_mirror=kent");
    @SetFromFlag(value="bindAddress")
    public static final BasicAttributeSensorAndConfigKey<String> BIND_ADDRESS = new BasicAttributeSensorAndConfigKey(String.class, "jboss6.bind.address", "Address of interface JBoss should listen on, defaulting 0.0.0.0 (but could set e.g. to attributeWhenReady(HOSTNAME)", (Object)"0.0.0.0");
    @SetFromFlag(value="portIncrement")
    public static final BasicAttributeSensorAndConfigKey<Integer> PORT_INCREMENT = new BasicAttributeSensorAndConfigKey(Integer.class, "jboss6.portincrement", "Increment to be used for all jboss ports", (Object)0);
    @SetFromFlag(value="clusterName")
    public static final BasicAttributeSensorAndConfigKey<String> CLUSTER_NAME = new BasicAttributeSensorAndConfigKey(String.class, "jboss6.clusterName", "Identifier used to group JBoss instances", (Object)"");
}

