/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.webapp;

import brooklyn.config.render.RendererHints;
import brooklyn.entity.webapp.WebAppServiceConstants;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.BasicAttributeSensor;
import brooklyn.event.basic.Sensors;
import brooklyn.util.math.MathFunctions;
import brooklyn.util.text.ByteSizeStrings;
import brooklyn.util.time.Duration;
import com.google.common.base.Function;

public interface WebAppServiceMetrics {
    public static final BasicAttributeSensor<Integer> ERROR_COUNT = new BasicAttributeSensor(Integer.class, "webapp.reqs.errors", "Request errors");
    public static final AttributeSensor<Integer> TOTAL_PROCESSING_TIME = Sensors.newIntegerSensor((String)"webapp.reqs.processingTime.total", (String)"Total processing time, reported by webserver (millis)");
    public static final AttributeSensor<Integer> MAX_PROCESSING_TIME = Sensors.newIntegerSensor((String)"webapp.reqs.processingTime.max", (String)"Max processing time for any single request, reported by webserver (millis)");
    public static final AttributeSensor<Double> PROCESSING_TIME_FRACTION_LAST = Sensors.newDoubleSensor((String)"webapp.reqs.processingTime.fraction.last", (String)"Fraction of time spent processing, reported by webserver (percentage, last datapoint)");
    public static final AttributeSensor<Double> PROCESSING_TIME_FRACTION_IN_WINDOW = Sensors.newDoubleSensor((String)"webapp.reqs.processingTime.fraction.windowed", (String)"Fraction of time spent processing, reported by webserver (percentage, over time window)");
    public static final AttributeSensor<Long> BYTES_RECEIVED = new BasicAttributeSensor(Long.class, "webapp.reqs.bytes.received", "Total bytes received by the webserver");
    public static final AttributeSensor<Long> BYTES_SENT = new BasicAttributeSensor(Long.class, "webapp.reqs.bytes.sent", "Total bytes sent by the webserver");
    public static final AttributeSensor<Double> REQUESTS_PER_SECOND_LAST = Sensors.newDoubleSensor((String)"webapp.reqs.perSec.last", (String)"Reqs/sec (last datapoint)");
    public static final AttributeSensor<Double> REQUESTS_PER_SECOND_IN_WINDOW = Sensors.newDoubleSensor((String)"webapp.reqs.perSec.windowed", (String)"Reqs/sec (over time window)");
    public static final AttributeSensor<Integer> REQUEST_COUNT = Initializer.REQUEST_COUNT;

    public static class Initializer {
        public static final AttributeSensor<Integer> REQUEST_COUNT = Sensors.newIntegerSensor((String)"webapp.reqs.total", (String)"Request count");

        static {
            RendererHints.register((AttributeSensor)WebAppServiceConstants.TOTAL_PROCESSING_TIME, (RendererHints.Hint)RendererHints.displayValue((Function)Duration.millisToStringRounded()));
            RendererHints.register((AttributeSensor)WebAppServiceConstants.MAX_PROCESSING_TIME, (RendererHints.Hint)RendererHints.displayValue((Function)Duration.millisToStringRounded()));
            RendererHints.register((AttributeSensor)WebAppServiceConstants.BYTES_RECEIVED, (RendererHints.Hint)RendererHints.displayValue((Function)ByteSizeStrings.metric()));
            RendererHints.register((AttributeSensor)WebAppServiceConstants.BYTES_SENT, (RendererHints.Hint)RendererHints.displayValue((Function)ByteSizeStrings.metric()));
            RendererHints.register((AttributeSensor)WebAppServiceConstants.PROCESSING_TIME_FRACTION_LAST, (RendererHints.Hint)RendererHints.displayValue((Function)MathFunctions.percent((int)2)));
            RendererHints.register((AttributeSensor)WebAppServiceConstants.PROCESSING_TIME_FRACTION_IN_WINDOW, (RendererHints.Hint)RendererHints.displayValue((Function)MathFunctions.percent((int)2)));
        }
    }
}

