/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.webapp;

import brooklyn.enricher.RollingTimeWindowMeanEnricher;
import brooklyn.enricher.TimeFractionDeltaEnricher;
import brooklyn.enricher.TimeWeightedDeltaEnricher;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.webapp.WebAppService;
import brooklyn.entity.webapp.WebAppServiceConstants;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.location.access.BrooklynAccessUtils;
import brooklyn.policy.Enricher;
import brooklyn.util.time.Duration;
import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class WebAppServiceMethods
implements WebAppServiceConstants {
    public static final Duration DEFAULT_WINDOW_DURATION = Duration.TEN_SECONDS;

    public static void connectWebAppServerPolicies(EntityLocal entity) {
        WebAppServiceMethods.connectWebAppServerPolicies(entity, DEFAULT_WINDOW_DURATION);
    }

    public static void connectWebAppServerPolicies(EntityLocal entity, Duration windowPeriod) {
        entity.addEnricher((Enricher)TimeWeightedDeltaEnricher.getPerSecondDeltaEnricher((Entity)entity, (Sensor)REQUEST_COUNT, (Sensor)REQUESTS_PER_SECOND_LAST));
        if (windowPeriod != null) {
            entity.addEnricher((Enricher)new RollingTimeWindowMeanEnricher((Entity)entity, REQUESTS_PER_SECOND_LAST, REQUESTS_PER_SECOND_IN_WINDOW, windowPeriod));
        }
        entity.addEnricher((Enricher)new TimeFractionDeltaEnricher((Entity)entity, (Sensor)TOTAL_PROCESSING_TIME, (Sensor)PROCESSING_TIME_FRACTION_LAST, TimeUnit.MILLISECONDS));
        if (windowPeriod != null) {
            entity.addEnricher((Enricher)new RollingTimeWindowMeanEnricher((Entity)entity, PROCESSING_TIME_FRACTION_LAST, PROCESSING_TIME_FRACTION_IN_WINDOW, windowPeriod));
        }
    }

    public static Set<String> getEnabledProtocols(Entity entity) {
        return (Set)entity.getAttribute((AttributeSensor)WebAppService.ENABLED_PROTOCOLS);
    }

    public static boolean isProtocolEnabled(Entity entity, String protocol) {
        for (String contender : WebAppServiceMethods.getEnabledProtocols(entity)) {
            if (!protocol.equalsIgnoreCase(contender)) continue;
            return true;
        }
        return false;
    }

    public static String inferBrooklynAccessibleRootUrl(Entity entity) {
        if (WebAppServiceMethods.isProtocolEnabled(entity, "https")) {
            Integer rawPort = (Integer)entity.getAttribute((AttributeSensor)HTTPS_PORT);
            Preconditions.checkNotNull((Object)rawPort, (String)"HTTPS_PORT sensors not set for %s; is an acceptable port available?", (Object[])new Object[]{entity});
            HostAndPort hp = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)entity, (int)rawPort);
            return String.format("https://%s:%s/", hp.getHostText(), hp.getPort());
        }
        if (WebAppServiceMethods.isProtocolEnabled(entity, "http")) {
            Integer rawPort = (Integer)entity.getAttribute((AttributeSensor)HTTP_PORT);
            Preconditions.checkNotNull((Object)rawPort, (String)"HTTP_PORT sensors not set for %s; is an acceptable port available?", (Object[])new Object[]{entity});
            HostAndPort hp = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)entity, (int)rawPort);
            return String.format("http://%s:%s/", hp.getHostText(), hp.getPort());
        }
        throw new IllegalStateException("HTTP and HTTPS protocols not enabled for " + entity + "; enabled protocols are " + WebAppServiceMethods.getEnabledProtocols(entity));
    }
}

