/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.webapp;

import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.java.JavaSoftwareProcessSshDriver;
import brooklyn.entity.webapp.FilenameToWebContextMapper;
import brooklyn.entity.webapp.HttpsSslConfig;
import brooklyn.entity.webapp.JavaWebAppDriver;
import brooklyn.entity.webapp.JavaWebAppSoftwareProcess;
import brooklyn.entity.webapp.JavaWebAppSoftwareProcessImpl;
import brooklyn.entity.webapp.WebAppService;
import brooklyn.entity.webapp.WebAppServiceConstants;
import brooklyn.event.AttributeSensor;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.management.TaskFactory;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.Tasks;
import brooklyn.util.task.ssh.SshTasks;
import brooklyn.util.text.Strings;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Set;

public abstract class JavaWebAppSshDriver
extends JavaSoftwareProcessSshDriver
implements JavaWebAppDriver {
    public JavaWebAppSshDriver(JavaWebAppSoftwareProcessImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
    }

    public JavaWebAppSoftwareProcessImpl getEntity() {
        return (JavaWebAppSoftwareProcessImpl)super.getEntity();
    }

    protected boolean isProtocolEnabled(String protocol) {
        Set<String> protocols = this.getEnabledProtocols();
        for (String contender : protocols) {
            if (!protocol.equalsIgnoreCase(contender)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getEnabledProtocols() {
        return (Set)this.entity.getAttribute((AttributeSensor)JavaWebAppSoftwareProcess.ENABLED_PROTOCOLS);
    }

    @Override
    public Integer getHttpPort() {
        return (Integer)this.entity.getAttribute((AttributeSensor)Attributes.HTTP_PORT);
    }

    @Override
    public Integer getHttpsPort() {
        return (Integer)this.entity.getAttribute((AttributeSensor)Attributes.HTTPS_PORT);
    }

    @Override
    public HttpsSslConfig getHttpsSslConfig() {
        return (HttpsSslConfig)this.entity.getAttribute(WebAppServiceConstants.HTTPS_SSL_CONFIG);
    }

    protected String getSslKeystoreUrl() {
        HttpsSslConfig ssl = this.getHttpsSslConfig();
        return ssl == null ? null : ssl.getKeystoreUrl();
    }

    protected String getSslKeystorePassword() {
        HttpsSslConfig ssl = this.getHttpsSslConfig();
        return ssl == null ? null : ssl.getKeystorePassword();
    }

    protected String getSslKeyAlias() {
        HttpsSslConfig ssl = this.getHttpsSslConfig();
        return ssl == null ? null : ssl.getKeyAlias();
    }

    protected String inferRootUrl() {
        if (this.isProtocolEnabled("https")) {
            Integer port = this.getHttpsPort();
            Preconditions.checkNotNull((Object)port, (Object)"HTTPS_PORT sensors not set; is an acceptable port available?");
            return String.format("https://%s:%s/", this.getSubnetHostname(), port);
        }
        if (this.isProtocolEnabled("http")) {
            Integer port = this.getHttpPort();
            Preconditions.checkNotNull((Object)port, (Object)"HTTP_PORT sensors not set; is an acceptable port available?");
            return String.format("http://%s:%s/", this.getSubnetHostname(), port);
        }
        throw new IllegalStateException("HTTP and HTTPS protocols not enabled for " + this.entity + "; enabled protocols are " + this.getEnabledProtocols());
    }

    public void postLaunch() {
        String rootUrl = this.inferRootUrl();
        this.entity.setAttribute(Attributes.MAIN_URI, (Object)URI.create(rootUrl));
        this.entity.setAttribute(WebAppService.ROOT_URL, (Object)rootUrl);
    }

    protected abstract String getDeploySubdir();

    protected String getDeployDir() {
        if (this.getDeploySubdir() == null) {
            throw new IllegalStateException("no deployment directory available for " + this);
        }
        return this.getRunDir() + "/" + this.getDeploySubdir();
    }

    @Override
    public void deploy(File file) {
        this.deploy(file, null);
    }

    @Override
    public void deploy(File f, String targetName) {
        if (targetName == null) {
            targetName = f.getName();
        }
        this.deploy(f.toURI().toASCIIString(), targetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String deploy(final String url, String targetName) {
        String canonicalTargetName = this.getFilenameContextMapper().convertDeploymentTargetNameToFilename(targetName);
        String dest = this.getDeployDir() + "/" + canonicalTargetName;
        final String tmpDest = dest + "." + Strings.makeRandomId((int)8) + ".tmp";
        String msg = String.format("deploying %s to %s:%s", url, this.getHostname(), dest);
        log.info(this.entity + " " + msg);
        Tasks.setBlockingDetails((String)msg);
        try {
            final String copyTaskMsg = String.format("copying %s to %s:%s", url, this.getHostname(), tmpDest);
            DynamicTasks.queue((String)copyTaskMsg, (Runnable)new Runnable(){

                @Override
                public void run() {
                    int result = JavaWebAppSshDriver.this.copyResource(url, tmpDest);
                    if (result != 0) {
                        throw new IllegalStateException("Invalud result " + result + " while " + copyTaskMsg);
                    }
                }
            });
            DynamicTasks.queue((TaskFactory)SshTasks.newSshExecTaskFactory((SshMachineLocation)this.getMachine(), (String[])new String[]{String.format("mv -f %s %s.bak", dest, dest)}).allowingNonZeroExitCode());
            DynamicTasks.queue((TaskFactory)SshTasks.newSshExecTaskFactory((SshMachineLocation)this.getMachine(), (String[])new String[]{String.format("mv -f %s %s", tmpDest, dest)}).requiringExitCodeZero());
            log.debug("{} deployed {} to {}:{}", new Object[]{this.entity, url, this.getHostname(), dest});
            DynamicTasks.waitForLast();
        }
        finally {
            Tasks.resetBlockingDetails();
        }
        return this.getFilenameContextMapper().convertDeploymentTargetNameToContext(canonicalTargetName);
    }

    @Override
    public void undeploy(String targetName) {
        String dest = this.getDeployDir() + "/" + this.getFilenameContextMapper().convertDeploymentTargetNameToFilename(targetName);
        log.info("{} undeploying {}:{}", new Object[]{this.entity, this.getHostname(), dest});
        int result = this.getMachine().execCommands("removing war on undeploy", (List)ImmutableList.of((Object)String.format("rm -f %s", dest)));
        log.debug("{} undeployed {}:{}: result {}", new Object[]{this.entity, this.getHostname(), dest, result});
    }

    @Override
    public FilenameToWebContextMapper getFilenameContextMapper() {
        return new FilenameToWebContextMapper();
    }
}

