/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.webapp;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilenameToWebContextMapper {
    public static final Logger log = LoggerFactory.getLogger(FilenameToWebContextMapper.class);

    public String findArchiveNameFromUrl(String url, boolean verbose) {
        String name = url.substring(url.lastIndexOf(47) + 1);
        if (name.indexOf("?") > 0) {
            Pattern p = Pattern.compile("[A-Za-z0-9_\\-]+\\..(ar|AR)($|(?=[^A-Za-z0-9_\\-]))");
            Matcher wars = p.matcher(name);
            if (wars.find()) {
                name = wars.group();
                if (wars.find()) {
                    if (verbose) {
                        log.warn("Not clear which archive to deploy for " + url + ": using " + name);
                    }
                } else if (verbose) {
                    log.info("Inferred archive to deploy for " + url + ": using " + name);
                }
            } else if (verbose) {
                log.warn("Not clear which archive to deploy for " + url + ": using " + name);
            }
        }
        return name;
    }

    public String convertDeploymentTargetNameToFilename(String targetName) {
        String result = targetName;
        if (result.isEmpty()) {
            return "";
        }
        if (targetName.startsWith("/")) {
            if ((result = result.substring(1)).length() == 0) {
                result = "ROOT";
            }
            result = result + ".war";
        } else if (result.indexOf(46) == -1) {
            result = result + ".war";
        }
        return result;
    }

    public String convertDeploymentTargetNameToContext(String targetName) {
        String extension;
        String result = targetName;
        if (result.isEmpty()) {
            return "";
        }
        if (!targetName.startsWith("/") && (result = "/" + result).indexOf(46) != -1 && (extension = result.substring(result.lastIndexOf(46) + 1).toUpperCase()).matches(".AR") && (result = result.substring(0, result.length() - 4)).equalsIgnoreCase("/ROOT")) {
            result = "/";
        }
        return result;
    }
}

