/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.webapp;

import brooklyn.enricher.Enrichers;
import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.effector.Effectors;
import brooklyn.entity.group.DynamicClusterImpl;
import brooklyn.entity.webapp.DynamicWebAppCluster;
import brooklyn.entity.webapp.FilenameToWebContextMapper;
import brooklyn.entity.webapp.JavaWebAppService;
import brooklyn.event.AttributeSensor;
import brooklyn.management.Task;
import brooklyn.management.TaskAdaptable;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.collections.MutableSet;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.TaskBuilder;
import brooklyn.util.task.TaskTags;
import brooklyn.util.task.Tasks;
import brooklyn.util.time.Duration;
import brooklyn.util.time.Time;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicWebAppClusterImpl
extends DynamicClusterImpl
implements DynamicWebAppCluster {
    private static final Logger log = LoggerFactory.getLogger(DynamicWebAppClusterImpl.class);
    private static final FilenameToWebContextMapper FILENAME_TO_WEB_CONTEXT_MAPPER = new FilenameToWebContextMapper();

    public void init() {
        AttributeSensor t;
        super.init();
        ImmutableList summingEnricherSetup = ImmutableList.of((Object)ImmutableList.of((Object)REQUEST_COUNT, (Object)REQUEST_COUNT), (Object)ImmutableList.of((Object)ERROR_COUNT, (Object)ERROR_COUNT), (Object)ImmutableList.of((Object)REQUESTS_PER_SECOND_LAST, (Object)REQUESTS_PER_SECOND_LAST), (Object)ImmutableList.of((Object)REQUESTS_PER_SECOND_IN_WINDOW, (Object)REQUESTS_PER_SECOND_IN_WINDOW), (Object)ImmutableList.of((Object)TOTAL_PROCESSING_TIME, (Object)TOTAL_PROCESSING_TIME), (Object)ImmutableList.of((Object)PROCESSING_TIME_FRACTION_IN_WINDOW, (Object)PROCESSING_TIME_FRACTION_IN_WINDOW));
        ImmutableList averagingEnricherSetup = ImmutableList.of((Object)ImmutableList.of((Object)REQUEST_COUNT, (Object)REQUEST_COUNT_PER_NODE), (Object)ImmutableList.of((Object)ERROR_COUNT, (Object)ERROR_COUNT_PER_NODE), (Object)ImmutableList.of((Object)REQUESTS_PER_SECOND_LAST, (Object)REQUESTS_PER_SECOND_LAST_PER_NODE), (Object)ImmutableList.of((Object)REQUESTS_PER_SECOND_IN_WINDOW, (Object)REQUESTS_PER_SECOND_IN_WINDOW_PER_NODE), (Object)ImmutableList.of((Object)TOTAL_PROCESSING_TIME, (Object)TOTAL_PROCESSING_TIME_PER_NODE), (Object)ImmutableList.of((Object)PROCESSING_TIME_FRACTION_IN_WINDOW, (Object)PROCESSING_TIME_FRACTION_IN_WINDOW_PER_NODE));
        for (List es : summingEnricherSetup) {
            t = (AttributeSensor)es.get(0);
            AttributeSensor total = (AttributeSensor)es.get(1);
            this.addEnricher(((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)Enrichers.builder().aggregating(t).publishing(total).fromMembers()).computingSum()).build());
        }
        for (List es : averagingEnricherSetup) {
            t = (AttributeSensor)es.get(0);
            AttributeSensor average = (AttributeSensor)es.get(1);
            this.addEnricher(((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)Enrichers.builder().aggregating(t).publishing(average).fromMembers()).computingAverage()).build());
        }
    }

    static <T> Task<T> whenServiceUp(final Entity target, final TaskAdaptable<T> task, String name) {
        return Tasks.builder().name(name).dynamic(true).body(new Callable<T>(){

            @Override
            public T call() {
                while (true) {
                    if (!Entities.isManaged((Entity)target)) {
                        Tasks.markInessential();
                        throw new IllegalStateException("Target " + target + " is no longer managed");
                    }
                    if (Boolean.TRUE.equals(target.getAttribute(Attributes.SERVICE_UP))) {
                        Object object;
                        Tasks.resetBlockingDetails();
                        TaskTags.markInessential((TaskAdaptable)task);
                        DynamicTasks.queue((TaskAdaptable)task);
                        try {
                            object = task.asTask().getUnchecked();
                        }
                        catch (Exception e) {
                            if (Entities.isManaged((Entity)target)) {
                                throw Exceptions.propagate((Throwable)e);
                            }
                            Tasks.markInessential();
                            throw new IllegalStateException("Target " + target + " is no longer managed", e);
                        }
                        return object;
                    }
                    Tasks.setBlockingDetails((String)("Waiting on " + target + " to be ready"));
                    Time.sleep((Duration)Duration.ONE_SECOND);
                }
                finally {
                    Tasks.resetBlockingDetails();
                }
            }
        }).build();
    }

    @Override
    public void deploy(String url, String targetName) {
        Preconditions.checkNotNull((Object)url, (Object)"url");
        Preconditions.checkNotNull((Object)targetName, (Object)"targetName");
        targetName = FILENAME_TO_WEB_CONTEXT_MAPPER.convertDeploymentTargetNameToContext(targetName);
        DynamicWebAppClusterImpl.addToWarsByContext(this, url, targetName);
        log.debug("Deploying " + targetName + "->" + url + " across cluster " + this + "; WARs now " + this.getConfig(WARS_BY_CONTEXT));
        Iterable targets = Iterables.filter((Iterable)this.getChildren(), JavaWebAppService.CanDeployAndUndeploy.class);
        TaskBuilder tb = Tasks.builder().parallel(true).name("Deploy " + targetName + " to cluster (size " + Iterables.size((Iterable)targets) + ")");
        for (Entity target : targets) {
            tb.add(DynamicWebAppClusterImpl.whenServiceUp(target, Effectors.invocation((Entity)target, (Effector)DEPLOY, (Map)MutableMap.of((Object)"url", (Object)url, (Object)"targetName", (Object)targetName)), "Deploy " + targetName + " to " + target + " when ready"));
        }
        DynamicTasks.queueIfPossible((TaskAdaptable)tb.build()).orSubmitAsync((Entity)this).asTask().getUnchecked();
        MutableSet deployedWars = MutableSet.copyOf((Iterable)((Iterable)this.getAttribute(DEPLOYED_WARS)));
        deployedWars.add(targetName);
        this.setAttribute(DEPLOYED_WARS, deployedWars);
    }

    @Override
    public void undeploy(String targetName) {
        Preconditions.checkNotNull((Object)targetName, (Object)"targetName");
        targetName = FILENAME_TO_WEB_CONTEXT_MAPPER.convertDeploymentTargetNameToContext(targetName);
        if (!DynamicWebAppClusterImpl.removeFromWarsByContext(this, targetName)) {
            DynamicTasks.submit((TaskAdaptable)Tasks.warning((String)("Context " + targetName + " not known at " + this + "; attempting to undeploy regardless"), null), (Entity)this);
        }
        log.debug("Undeploying " + targetName + " across cluster " + this + "; WARs now " + this.getConfig(WARS_BY_CONTEXT));
        Iterable targets = Iterables.filter((Iterable)this.getChildren(), JavaWebAppService.CanDeployAndUndeploy.class);
        TaskBuilder tb = Tasks.builder().parallel(true).name("Undeploy " + targetName + " across cluster (size " + Iterables.size((Iterable)targets) + ")");
        for (Entity target : targets) {
            tb.add(DynamicWebAppClusterImpl.whenServiceUp(target, Effectors.invocation((Entity)target, (Effector)UNDEPLOY, (Map)MutableMap.of((Object)"targetName", (Object)targetName)), "Undeploy " + targetName + " at " + target + " when ready"));
        }
        DynamicTasks.queueIfPossible((TaskAdaptable)tb.build()).orSubmitAsync((Entity)this).asTask().getUnchecked();
        MutableSet deployedWars = MutableSet.copyOf((Iterable)((Iterable)this.getAttribute(DEPLOYED_WARS)));
        deployedWars.remove(FILENAME_TO_WEB_CONTEXT_MAPPER.convertDeploymentTargetNameToContext(targetName));
        this.setAttribute(DEPLOYED_WARS, deployedWars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addToWarsByContext(Entity entity, String url, String targetName) {
        targetName = FILENAME_TO_WEB_CONTEXT_MAPPER.convertDeploymentTargetNameToContext(targetName);
        Entity entity2 = entity;
        synchronized (entity2) {
            MutableMap newWarsMap = MutableMap.copyOf((Map)((Map)entity.getConfig(WARS_BY_CONTEXT)));
            newWarsMap.put(targetName, url);
            ((EntityInternal)entity).setConfig(WARS_BY_CONTEXT, (Object)newWarsMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean removeFromWarsByContext(Entity entity, String targetName) {
        targetName = FILENAME_TO_WEB_CONTEXT_MAPPER.convertDeploymentTargetNameToContext(targetName);
        Entity entity2 = entity;
        synchronized (entity2) {
            MutableMap newWarsMap = MutableMap.copyOf((Map)((Map)entity.getConfig(WARS_BY_CONTEXT)));
            String url = (String)newWarsMap.remove(targetName);
            if (url == null) {
                return false;
            }
            ((EntityInternal)entity).setConfig(WARS_BY_CONTEXT, (Object)newWarsMap);
            return true;
        }
    }

    @Override
    public void redeployAll() {
        MutableMap wars = MutableMap.copyOf((Map)((Map)this.getConfig(WARS_BY_CONTEXT)));
        String redeployPrefix = "Redeploy all WARs (count " + wars.size() + ")";
        log.debug("Redeplying all WARs across cluster " + this + ": " + this.getConfig(WARS_BY_CONTEXT));
        Iterable targetEntities = Iterables.filter((Iterable)this.getChildren(), JavaWebAppService.CanDeployAndUndeploy.class);
        TaskBuilder tb = Tasks.builder().parallel(true).name(redeployPrefix + " across cluster (size " + Iterables.size((Iterable)targetEntities) + ")");
        for (Entity targetEntity : targetEntities) {
            TaskBuilder redeployAllToTarget = Tasks.builder().name(redeployPrefix + " at " + targetEntity + " (after ready check)");
            for (String warContextPath : wars.keySet()) {
                redeployAllToTarget.add(Effectors.invocation((Entity)targetEntity, (Effector)DEPLOY, (Map)MutableMap.of((Object)"url", wars.get(warContextPath), (Object)"targetName", (Object)warContextPath)));
            }
            tb.add(DynamicWebAppClusterImpl.whenServiceUp(targetEntity, redeployAllToTarget.build(), redeployPrefix + " at " + targetEntity + " when ready"));
        }
        DynamicTasks.queueIfPossible((TaskAdaptable)tb.build()).orSubmitAsync((Entity)this).asTask().getUnchecked();
    }
}

