/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.webapp;

import brooklyn.enricher.Enrichers;
import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.Group;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.ConfigurableEntityFactory;
import brooklyn.entity.basic.DynamicGroupImpl;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.EntityPredicates;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.entity.basic.ServiceStateLogic;
import brooklyn.entity.proxy.LoadBalancer;
import brooklyn.entity.proxy.nginx.NginxController;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.trait.Startable;
import brooklyn.entity.trait.StartableMethods;
import brooklyn.entity.webapp.ControlledDynamicWebAppCluster;
import brooklyn.entity.webapp.DynamicWebAppCluster;
import brooklyn.entity.webapp.DynamicWebAppClusterImpl;
import brooklyn.entity.webapp.WebAppService;
import brooklyn.entity.webapp.tomcat.TomcatServer;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.event.SensorEvent;
import brooklyn.event.SensorEventListener;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.event.feed.ConfigToAttributes;
import brooklyn.location.Location;
import brooklyn.management.Task;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.collections.QuorumCheck;
import brooklyn.util.exceptions.Exceptions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlledDynamicWebAppClusterImpl
extends DynamicGroupImpl
implements ControlledDynamicWebAppCluster {
    public static final Logger log = LoggerFactory.getLogger(ControlledDynamicWebAppClusterImpl.class);

    public ControlledDynamicWebAppClusterImpl() {
        this((Map<?, ?>)MutableMap.of(), null);
    }

    public ControlledDynamicWebAppClusterImpl(Map<?, ?> flags) {
        this(flags, null);
    }

    public ControlledDynamicWebAppClusterImpl(Entity parent) {
        this((Map<?, ?>)MutableMap.of(), parent);
    }

    @Deprecated
    public ControlledDynamicWebAppClusterImpl(Map<?, ?> flags, Entity parent) {
        super(flags, parent);
    }

    public void init() {
        boolean hasMemberFactory;
        super.init();
        ConfigToAttributes.apply((EntityLocal)this, (AttributeSensorAndConfigKey)FACTORY);
        ConfigToAttributes.apply((EntityLocal)this, (AttributeSensorAndConfigKey)MEMBER_SPEC);
        ConfigToAttributes.apply((EntityLocal)this, (AttributeSensorAndConfigKey)CONTROLLER);
        ConfigToAttributes.apply((EntityLocal)this, (AttributeSensorAndConfigKey)CONTROLLER_SPEC);
        ConfigToAttributes.apply((EntityLocal)this, (AttributeSensorAndConfigKey)WEB_CLUSTER_SPEC);
        ConfigurableEntityFactory webServerFactory = (ConfigurableEntityFactory)this.getAttribute((AttributeSensor)FACTORY);
        EntitySpec webServerSpec = (EntitySpec)this.getAttribute((AttributeSensor)MEMBER_SPEC);
        if (webServerFactory == null && webServerSpec == null) {
            log.debug("creating default web server spec for {}", (Object)this);
            webServerSpec = EntitySpec.create(TomcatServer.class);
            this.setAttribute((AttributeSensor)MEMBER_SPEC, webServerSpec);
        }
        log.debug("creating cluster child for {}", (Object)this);
        EntitySpec webClusterSpec = (EntitySpec)this.getAttribute((AttributeSensor)WEB_CLUSTER_SPEC);
        MutableMap webClusterFlags = webServerSpec != null ? MutableMap.of((Object)"memberSpec", (Object)webServerSpec) : MutableMap.of((Object)"factory", (Object)webServerFactory);
        if (webClusterSpec == null) {
            log.debug("creating default web cluster spec for {}", (Object)this);
            webClusterSpec = EntitySpec.create(DynamicWebAppCluster.class);
        }
        boolean hasMemberSpec = webClusterSpec.getConfig().containsKey(DynamicWebAppCluster.MEMBER_SPEC) || webClusterSpec.getFlags().containsKey("memberSpec");
        boolean bl = hasMemberFactory = webClusterSpec.getConfig().containsKey(DynamicWebAppCluster.FACTORY) || webClusterSpec.getFlags().containsKey("factory");
        if (!hasMemberSpec && !hasMemberFactory) {
            webClusterSpec.configure((Map)webClusterFlags);
        } else {
            log.warn("In {}, not setting cluster's {} because already set on webClusterSpec", new Object[]{this, webClusterFlags.keySet()});
        }
        this.setAttribute((AttributeSensor)WEB_CLUSTER_SPEC, webClusterSpec);
        DynamicWebAppCluster cluster = (DynamicWebAppCluster)this.addChild(webClusterSpec);
        if (Entities.isManaged((Entity)this)) {
            Entities.manage((Entity)cluster);
        }
        this.setAttribute(CLUSTER, cluster);
        this.setEntityFilter(EntityPredicates.isMemberOf((Group)cluster));
        LoadBalancer controller = (LoadBalancer)this.getAttribute((AttributeSensor)CONTROLLER);
        if (controller == null) {
            EntitySpec controllerSpec = (EntitySpec)this.getAttribute((AttributeSensor)CONTROLLER_SPEC);
            if (controllerSpec == null) {
                log.debug("creating controller using default spec for {}", (Object)this);
                controllerSpec = EntitySpec.create(NginxController.class);
                this.setAttribute((AttributeSensor)CONTROLLER_SPEC, controllerSpec);
            } else {
                log.debug("creating controller using custom spec for {}", (Object)this);
            }
            controller = (LoadBalancer)this.addChild(controllerSpec);
            this.addEnricher(((Enrichers.PropagatorBuilder)Enrichers.builder().propagating(new Sensor[]{LoadBalancer.PROXY_HTTP_PORT, LoadBalancer.PROXY_HTTPS_PORT}).from((Entity)controller)).build());
            if (Entities.isManaged((Entity)this)) {
                Entities.manage((Entity)controller);
            }
            this.setAttribute((AttributeSensor)CONTROLLER, controller);
        }
        this.doBind();
    }

    protected void initEnrichers() {
        if (this.config().getLocalRaw(UP_QUORUM_CHECK).isAbsent()) {
            this.config().set(UP_QUORUM_CHECK, (Object)QuorumCheck.QuorumChecks.newInstance((int)2, (double)1.0, (boolean)false));
        }
        super.initEnrichers();
        ServiceStateLogic.newEnricherFromChildrenUp().checkChildrenOnly().requireUpChildren((QuorumCheck)this.getConfig(UP_QUORUM_CHECK)).addTo((Entity)this);
    }

    public void rebind() {
        super.rebind();
        this.doBind();
    }

    protected void doBind() {
        DynamicWebAppCluster cluster = (DynamicWebAppCluster)this.getAttribute(CLUSTER);
        if (cluster != null) {
            this.subscribe(cluster, (Sensor)DynamicWebAppCluster.GROUP_MEMBERS, (SensorEventListener)new SensorEventListener<Object>(){

                public void onEvent(SensorEvent<Object> event) {
                    ControlledDynamicWebAppClusterImpl.this.rescanEntities();
                }
            });
        }
    }

    @Override
    public LoadBalancer getController() {
        return (LoadBalancer)this.getAttribute((AttributeSensor)CONTROLLER);
    }

    @Override
    public synchronized ConfigurableEntityFactory<WebAppService> getFactory() {
        return (ConfigurableEntityFactory)this.getAttribute((AttributeSensor)FACTORY);
    }

    @Override
    public synchronized DynamicWebAppCluster getCluster() {
        return (DynamicWebAppCluster)this.getAttribute(CLUSTER);
    }

    public void start(Collection<? extends Location> locations) {
        ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STARTING);
        try {
            if (this.isLegacyConstruction()) {
                this.init();
            }
            if (locations.isEmpty()) {
                locations = this.getLocations();
            }
            this.addLocations(locations);
            LoadBalancer loadBalancer = this.getController();
            loadBalancer.bind((Map<?, ?>)MutableMap.of((Object)"serverPool", (Object)this.getCluster()));
            MutableList childrenToStart = MutableList.of((Object)this.getCluster());
            if (this.getController().getParent() == null) {
                this.addChild(this.getController());
            }
            Task startControllerTask = null;
            if (this.equals(this.getController().getParent())) {
                if (this.getController().getLocations().size() == 0) {
                    childrenToStart.add(this.getController());
                } else {
                    startControllerTask = Entities.invokeEffectorList((EntityLocal)this, (Iterable)MutableList.of((Object)this.getController()), (Effector)Startable.START, (Map)ImmutableMap.of((Object)"locations", (Object)this.getController().getLocations()));
                }
            }
            Entities.invokeEffectorList((EntityLocal)this, (Iterable)childrenToStart, (Effector)Startable.START, (Map)ImmutableMap.of((Object)"locations", (Object)locations)).get();
            if (startControllerTask != null) {
                startControllerTask.get();
            }
            this.getController().update();
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.RUNNING);
        }
        catch (Exception e) {
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            this.connectSensors();
        }
    }

    public void stop() {
        ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STOPPING);
        try {
            ArrayList tostop = Lists.newArrayList();
            if (this.equals(this.getController().getParent())) {
                tostop.add(this.getController());
            }
            tostop.add(this.getCluster());
            StartableMethods.stopSequentially((Iterable)tostop);
            this.clearLocations();
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STOPPED);
        }
        catch (Exception e) {
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public void restart() {
        ArrayList locations = Lists.newArrayList((Iterable)this.getLocations());
        this.stop();
        this.start(locations);
    }

    void connectSensors() {
        this.addEnricher(((Enrichers.PropagatorBuilder)Enrichers.builder().propagatingAllButUsualAnd(new Sensor[]{Attributes.MAIN_URI, ROOT_URL, GROUP_MEMBERS, GROUP_SIZE}).from((Entity)this.getCluster())).build());
        this.addEnricher(((Enrichers.PropagatorBuilder)Enrichers.builder().propagating(new Sensor[]{LoadBalancer.HOSTNAME, Attributes.ADDRESS, Attributes.MAIN_URI, ROOT_URL}).from((Entity)this.getController())).build());
    }

    public Integer resize(Integer desiredSize) {
        return this.getCluster().resize(desiredSize);
    }

    public String replaceMember(String memberId) {
        return this.getCluster().replaceMember(memberId);
    }

    public Integer getCurrentSize() {
        return this.getCluster().getCurrentSize();
    }

    @Override
    public void deploy(String url, String targetName) {
        DynamicWebAppClusterImpl.addToWarsByContext(this, url, targetName);
        this.getCluster().deploy(url, targetName);
    }

    @Override
    public void undeploy(String targetName) {
        DynamicWebAppClusterImpl.removeFromWarsByContext(this, targetName);
        this.getCluster().undeploy(targetName);
    }

    @Override
    public void redeployAll() {
        this.getCluster().redeployAll();
    }
}

