/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.proxy.nginx;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.annotation.Effector;
import brooklyn.entity.basic.AbstractGroup;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.MethodEffector;
import brooklyn.entity.proxy.AbstractController;
import brooklyn.entity.proxy.ProxySslConfig;
import brooklyn.entity.proxy.nginx.UrlMappingImpl;
import brooklyn.entity.proxy.nginx.UrlRewriteRule;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.Sensors;
import brooklyn.util.flags.SetFromFlag;
import com.google.common.reflect.TypeToken;
import java.util.Collection;

@ImplementedBy(value=UrlMappingImpl.class)
public interface UrlMapping
extends AbstractGroup {
    public static final MethodEffector<Void> DISCARD = new MethodEffector(UrlMapping.class, "discard");
    @SetFromFlag(value="label")
    public static final ConfigKey<String> LABEL = ConfigKeys.newStringConfigKey((String)"urlmapping.label", (String)"optional human-readable label to identify a server");
    @SetFromFlag(value="domain")
    public static final ConfigKey<String> DOMAIN = ConfigKeys.newStringConfigKey((String)"urlmapping.domain", (String)"domain (hostname, e.g. www.foo.com) to present for this URL map rule; required.");
    @SetFromFlag(value="path")
    public static final ConfigKey<String> PATH = ConfigKeys.newStringConfigKey((String)"urlmapping.path", (String)"URL path (pattern) for this URL map rule. Currently only supporting regex matches (if not supplied, will match all paths at the indicated domain)");
    @SetFromFlag(value="ssl")
    public static final ConfigKey<ProxySslConfig> SSL_CONFIG = AbstractController.SSL_CONFIG;
    @SetFromFlag(value="rewrites")
    public static final ConfigKey<Collection<UrlRewriteRule>> REWRITES = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Collection<UrlRewriteRule>>(){}, (String)"urlmapping.rewrites", (String)"Set of URL rewrite rules to apply");
    @SetFromFlag(value="target")
    public static final ConfigKey<Entity> TARGET_PARENT = ConfigKeys.newConfigKey(Entity.class, (String)"urlmapping.target.parent", (String)"optional target entity whose children will be pointed at by this mapper");
    public static final AttributeSensor<Collection<String>> TARGET_ADDRESSES = Sensors.newSensor((TypeToken)new TypeToken<Collection<String>>(){}, (String)"urlmapping.target.addresses", (String)"set of addresses which should be forwarded to by this URL mapping");

    public String getUniqueLabel();

    public UrlMapping addRewrite(String var1, String var2);

    public UrlMapping addRewrite(UrlRewriteRule var1);

    public String getDomain();

    public String getPath();

    public Entity getTarget();

    public void setTarget(Entity var1);

    public void recompute();

    public Collection<String> getTargetAddresses();

    public ProxySslConfig getSsl();

    @Effector(description="Unmanages the url-mapping, so it is discarded and no longer applies")
    public void discard();
}

