/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.proxy.nginx;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.drivers.EntityDriver;
import brooklyn.entity.proxy.ProxySslConfig;
import brooklyn.entity.proxy.nginx.NginxConfigFileGenerator;
import brooklyn.entity.proxy.nginx.NginxController;
import brooklyn.entity.proxy.nginx.NginxDriver;
import brooklyn.entity.proxy.nginx.UrlMapping;
import brooklyn.util.ResourceUtils;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.text.Strings;
import brooklyn.util.text.TemplateProcessor;
import com.google.common.collect.LinkedHashMultimap;
import java.util.Collection;
import java.util.Map;

public class NginxTemplateConfigGenerator
implements NginxConfigFileGenerator {
    public static final ConfigKey<String> SERVER_CONF_TEMPLATE_URL = ConfigKeys.newStringConfigKey((String)"nginx.config.templateUrl", (String)"The server.conf configuration file URL (FreeMarker template). Only applies if 'nginx.config.generator' specifies a generator which uses a template.", (String)"classpath://brooklyn/entity/proxy/nginx/server.conf");

    @Override
    public String generateConfigFile(NginxDriver driver, NginxController nginx) {
        String templateUrl = (String)driver.getEntity().getConfig(NginxController.SERVER_CONF_TEMPLATE_URL);
        ResourceUtils.create((Object)this).checkUrlExists(templateUrl);
        ProxySslConfig ssl = (ProxySslConfig)driver.getEntity().getConfig(NginxController.SSL_CONFIG);
        if (ssl != null && Strings.isEmpty((CharSequence)ssl.getCertificateDestination()) && Strings.isEmpty((CharSequence)ssl.getCertificateSourceUrl())) {
            throw new IllegalStateException("ProxySslConfig can't have a null certificateDestination and null certificateSourceUrl. One or both need to be set");
        }
        Iterable<UrlMapping> mappings = ((NginxController)driver.getEntity()).getUrlMappings();
        LinkedHashMultimap mappingsByDomain = LinkedHashMultimap.create();
        for (UrlMapping mapping : mappings) {
            Collection addrs = (Collection)mapping.getAttribute(UrlMapping.TARGET_ADDRESSES);
            if (addrs == null || addrs.size() <= 0) continue;
            mappingsByDomain.put((Object)mapping.getDomain(), (Object)mapping);
        }
        MutableMap substitutions = MutableMap.builder().putIfNotNull((Object)"ssl", (Object)ssl).put((Object)"urlMappings", mappings).put((Object)"domainMappings", (Object)mappingsByDomain).build();
        String contents = ResourceUtils.create((Object)driver.getEntity()).getResourceAsString(templateUrl);
        return TemplateProcessor.processTemplateContents((String)contents, (EntityDriver)driver, (Map)substitutions);
    }
}

