/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.proxy.nginx;

import brooklyn.entity.proxy.ProxySslConfig;
import brooklyn.entity.proxy.nginx.NginxConfigFileGenerator;
import brooklyn.entity.proxy.nginx.NginxController;
import brooklyn.entity.proxy.nginx.NginxDriver;
import brooklyn.entity.proxy.nginx.UrlMapping;
import brooklyn.entity.proxy.nginx.UrlRewriteRule;
import brooklyn.util.text.Strings;
import com.google.common.collect.LinkedHashMultimap;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NginxDefaultConfigGenerator
implements NginxConfigFileGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(NginxDefaultConfigGenerator.class);

    @Override
    public String generateConfigFile(NginxDriver driver, NginxController nginx) {
        Collection addrs;
        StringBuilder config = new StringBuilder();
        config.append("\n");
        config.append(String.format("pid %s;\n", driver.getPidFile()));
        config.append("events {\n");
        config.append("  worker_connections 8196;\n");
        config.append("}\n");
        config.append("http {\n");
        ProxySslConfig globalSslConfig = nginx.getSslConfig();
        if (nginx.isSsl()) {
            this.verifyConfig(globalSslConfig);
            this.appendSslConfig("global", config, "    ", globalSslConfig, true, true);
        }
        if (nginx.getDomain() != null || nginx.getServerPoolAddresses() == null || nginx.getServerPoolAddresses().isEmpty()) {
            config.append("  server {\n");
            config.append(this.getCodeForServerConfig());
            config.append("    listen " + nginx.getPort() + ";\n");
            config.append(this.getCodeFor404());
            config.append("  }\n");
        }
        if (nginx.getServerPoolAddresses() != null && nginx.getServerPoolAddresses().size() > 0) {
            config.append(String.format("  upstream " + nginx.getId() + " {\n", new Object[0]));
            if (nginx.isSticky()) {
                config.append("    sticky;\n");
            }
            for (String address : nginx.getServerPoolAddresses()) {
                config.append("    server " + address + ";\n");
            }
            config.append("  }\n");
            config.append("  server {\n");
            config.append(this.getCodeForServerConfig());
            config.append("    listen " + nginx.getPort() + ";\n");
            if (nginx.getDomain() != null) {
                config.append("    server_name " + nginx.getDomain() + ";\n");
            }
            config.append("    location / {\n");
            config.append("      proxy_pass " + (globalSslConfig != null && globalSslConfig.getTargetIsSsl() ? "https" : "http") + "://" + nginx.getId() + ";\n");
            config.append("    }\n");
            config.append("  }\n");
        }
        Iterable<UrlMapping> mappings = nginx.getUrlMappings();
        LinkedHashMultimap mappingsByDomain = LinkedHashMultimap.create();
        for (UrlMapping mapping : mappings) {
            addrs = (Collection)mapping.getAttribute(UrlMapping.TARGET_ADDRESSES);
            if (addrs == null || addrs.size() <= 0) continue;
            mappingsByDomain.put((Object)mapping.getDomain(), (Object)mapping);
        }
        for (UrlMapping um : mappings) {
            addrs = (Collection)um.getAttribute(UrlMapping.TARGET_ADDRESSES);
            if (addrs == null || addrs.size() <= 0) continue;
            config.append(String.format("  upstream " + um.getUniqueLabel() + " {\n", new Object[0]));
            if (nginx.isSticky()) {
                config.append("    sticky;\n");
            }
            for (String address : addrs) {
                config.append("    server " + address + ";\n");
            }
            config.append("  }\n");
        }
        for (String domain : mappingsByDomain.keySet()) {
            config.append("  server {\n");
            config.append(this.getCodeForServerConfig());
            config.append("    listen " + nginx.getPort() + ";\n");
            config.append("    server_name " + domain + ";\n");
            boolean hasRoot = false;
            ProxySslConfig localSslConfig = null;
            for (UrlMapping mappingInDomain : mappingsByDomain.get((Object)domain)) {
                ProxySslConfig sslConfig = (ProxySslConfig)mappingInDomain.getConfig(UrlMapping.SSL_CONFIG);
                if (sslConfig == null) continue;
                this.verifyConfig(sslConfig);
                if (localSslConfig != null) {
                    if (localSslConfig.equals(sslConfig)) continue;
                    LOG.warn("{} mapping {} provides SSL config for {} when a different config had already been provided by another mapping, ignoring this one", new Object[]{this, mappingInDomain, domain});
                    continue;
                }
                if (globalSslConfig != null) {
                    if (globalSslConfig.equals(sslConfig)) continue;
                    LOG.warn("{} mapping {} provides SSL config for {} when a different config had been provided at root nginx scope, ignoring this one", new Object[]{this, mappingInDomain, domain});
                    continue;
                }
                localSslConfig = sslConfig;
            }
            if (localSslConfig != null) {
                this.appendSslConfig(domain, config, "    ", localSslConfig, true, true);
            }
            for (UrlMapping mappingInDomain : mappingsByDomain.get((Object)domain)) {
                boolean isRoot;
                boolean bl = isRoot = mappingInDomain.getPath() == null || mappingInDomain.getPath().length() == 0 || mappingInDomain.getPath().equals("/");
                if (isRoot && hasRoot) {
                    LOG.warn("" + this + " mapping " + mappingInDomain + " provides a duplicate / proxy, ignoring");
                    continue;
                }
                hasRoot |= isRoot;
                String location = isRoot ? "/" : "~ " + mappingInDomain.getPath();
                config.append("    location " + location + " {\n");
                Collection rewrites = (Collection)mappingInDomain.getConfig(UrlMapping.REWRITES);
                if (rewrites != null && rewrites.size() > 0) {
                    for (UrlRewriteRule rule : rewrites) {
                        config.append("      rewrite \"^" + rule.getFrom() + "$\" \"" + rule.getTo() + "\"");
                        if (rule.isBreak()) {
                            config.append(" break");
                        }
                        config.append(" ;\n");
                    }
                }
                config.append("      proxy_pass " + (localSslConfig != null && localSslConfig.getTargetIsSsl() ? "https" : (localSslConfig == null && globalSslConfig != null && globalSslConfig.getTargetIsSsl() ? "https" : "http")) + "://" + mappingInDomain.getUniqueLabel() + " ;\n");
                config.append("    }\n");
            }
            if (!hasRoot) {
                config.append("    location / { \n" + this.getCodeFor404() + "    }\n");
            }
            config.append("  }\n");
        }
        config.append("}\n");
        return config.toString();
    }

    protected String getCodeForServerConfig() {
        return "    server_tokens off;\n    proxy_set_header Host $http_host;\n    proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;\n    proxy_set_header X-Real-IP $remote_addr;\n";
    }

    protected String getCodeFor404() {
        return "    return 404;\n";
    }

    protected void verifyConfig(ProxySslConfig proxySslConfig) {
        if (Strings.isEmpty((CharSequence)proxySslConfig.getCertificateDestination()) && Strings.isEmpty((CharSequence)proxySslConfig.getCertificateSourceUrl())) {
            throw new IllegalStateException("ProxySslConfig can't have a null certificateDestination and null certificateSourceUrl. One or both need to be set");
        }
    }

    protected boolean appendSslConfig(String id, StringBuilder out, String prefix, ProxySslConfig ssl, boolean sslBlock, boolean certificateBlock) {
        if (ssl == null) {
            return false;
        }
        if (sslBlock) {
            out.append(prefix);
            out.append("ssl on;\n");
        }
        if (ssl.getReuseSessions()) {
            out.append(prefix);
            out.append("");
        }
        if (certificateBlock) {
            String cert = Strings.isEmpty((CharSequence)ssl.getCertificateDestination()) ? "" + id + ".crt" : ssl.getCertificateDestination();
            out.append(prefix);
            out.append("ssl_certificate " + cert + ";\n");
            String key = !Strings.isEmpty((CharSequence)ssl.getKeyDestination()) ? ssl.getKeyDestination() : (!Strings.isEmpty((CharSequence)ssl.getKeySourceUrl()) ? "" + id + ".key" : null);
            if (key != null) {
                out.append(prefix);
                out.append("ssl_certificate_key " + key + ";\n");
            }
            out.append("ssl_protocols TLSv1 TLSv1.1 TLSv1.2;\n");
        }
        return true;
    }
}

