/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.proxy.nginx;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.annotation.Effector;
import brooklyn.entity.annotation.EffectorParam;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.MethodEffector;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.proxy.AbstractController;
import brooklyn.entity.proxy.ProxySslConfig;
import brooklyn.entity.proxy.nginx.NginxConfigFileGenerator;
import brooklyn.entity.proxy.nginx.NginxControllerImpl;
import brooklyn.entity.proxy.nginx.NginxDefaultConfigGenerator;
import brooklyn.entity.proxy.nginx.NginxTemplateConfigGenerator;
import brooklyn.entity.proxy.nginx.UrlMapping;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.entity.trait.HasShortName;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.BasicAttributeSensorAndConfigKey;
import brooklyn.event.basic.Sensors;
import brooklyn.util.flags.SetFromFlag;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

@Catalog(name="Nginx Server", description="A single Nginx server. Provides HTTP and reverse proxy services", iconUrl="classpath:///nginx-logo.jpeg")
@ImplementedBy(value=NginxControllerImpl.class)
public interface NginxController
extends AbstractController,
HasShortName {
    public static final MethodEffector<String> GET_CURRENT_CONFIGURATION = new MethodEffector(NginxController.class, "getCurrentConfiguration");
    public static final MethodEffector<Void> DEPLOY = new MethodEffector(NginxController.class, "deploy");
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"1.8.0");
    @SetFromFlag(value="stickyVersion")
    public static final ConfigKey<String> STICKY_VERSION = ConfigKeys.newStringConfigKey((String)"nginx.sticky.version", (String)"Version of ngnix-sticky-module to be installed, if required", (String)"1.2.5");
    @SetFromFlag(value="pcreVersion")
    public static final ConfigKey<String> PCRE_VERSION = ConfigKeys.newStringConfigKey((String)"pcre.version", (String)"Version of PCRE to be installed, if required", (String)"8.37");
    @SetFromFlag(value="downloadUrl")
    public static final BasicAttributeSensorAndConfigKey<String> DOWNLOAD_URL = new BasicAttributeSensorAndConfigKey(SoftwareProcess.DOWNLOAD_URL, (Object)"http://nginx.org/download/nginx-${version}.tar.gz");
    @SetFromFlag(value="downloadAddonUrls")
    public static final BasicAttributeSensorAndConfigKey<Map<String, String>> DOWNLOAD_ADDON_URLS = new BasicAttributeSensorAndConfigKey(SoftwareProcess.DOWNLOAD_ADDON_URLS, (Object)ImmutableMap.of((Object)"stickymodule", (Object)"https://bitbucket.org/nginx-goodies/nginx-sticky-module-ng/get/${addonversion}.tar.gz", (Object)"pcre", (Object)"ftp://ftp.csx.cam.ac.uk/pub/software/programming/pcre/pcre-${addonversion}.tar.gz"));
    @SetFromFlag(value="sticky")
    public static final ConfigKey<Boolean> STICKY = ConfigKeys.newBooleanConfigKey((String)"nginx.sticky", (String)"Whether to use sticky sessions", (Boolean)true);
    @SetFromFlag(value="httpPollPeriod")
    public static final ConfigKey<Long> HTTP_POLL_PERIOD = ConfigKeys.newLongConfigKey((String)"nginx.sensorpoll.http", (String)"Poll period (in milliseconds)", (Long)1000L);
    @SetFromFlag(value="withLdOpt")
    public static final ConfigKey<String> WITH_LD_OPT = ConfigKeys.newStringConfigKey((String)"nginx.install.withLdOpt", (String)"String to pass in with --with-ld-opt=\"<val>\" (and for OS X has pcre auto-appended to this)", (String)"-L /usr/local/lib");
    @SetFromFlag(value="withCcOpt")
    public static final ConfigKey<String> WITH_CC_OPT = ConfigKeys.newStringConfigKey((String)"nginx.install.withCcOpt", (String)"String to pass in with --with-cc-opt=\"<val>\"", (String)"-I /usr/local/include");
    @SetFromFlag(value="configGenerator")
    public static final ConfigKey<NginxConfigFileGenerator> SERVER_CONF_GENERATOR = ConfigKeys.newConfigKey(NginxConfigFileGenerator.class, (String)"nginx.config.generator", (String)"The server.conf generator class", (Object)new NginxDefaultConfigGenerator());
    @SetFromFlag(value="configTemplate")
    public static final ConfigKey<String> SERVER_CONF_TEMPLATE_URL = NginxTemplateConfigGenerator.SERVER_CONF_TEMPLATE_URL;
    @SetFromFlag(value="staticContentArchive")
    public static final ConfigKey<String> STATIC_CONTENT_ARCHIVE_URL = ConfigKeys.newStringConfigKey((String)"nginx.config.staticContentArchiveUrl", (String)"The URL of an archive file of static content (To be copied to the server)");
    public static final BasicAttributeSensorAndConfigKey<String> ACCESS_LOG_LOCATION = new BasicAttributeSensorAndConfigKey(String.class, "nginx.log.access", "Nginx access log file location", (Object)"logs/access.log");
    public static final BasicAttributeSensorAndConfigKey<String> ERROR_LOG_LOCATION = new BasicAttributeSensorAndConfigKey(String.class, "nginx.log.error", "Nginx error log file location", (Object)"logs/error.log");
    public static final AttributeSensor<Boolean> NGINX_URL_ANSWERS_NICELY = Sensors.newBooleanSensor((String)"nginx.url.answers.nicely");
    public static final AttributeSensor<String> PID_FILE = Sensors.newStringSensor((String)"nginx.pid.file", (String)"PID file");

    public boolean isSticky();

    @Effector(description="Gets the current server configuration (by brooklyn recalculating what the config should be); does not affect the server")
    public String getCurrentConfiguration();

    @Effector(description="Deploys an archive of static content to the server")
    public void deploy(@EffectorParam(name="archiveUrl", description="The URL of the static content archive to deploy") String var1);

    public String getConfigFile();

    public Iterable<UrlMapping> getUrlMappings();

    public boolean appendSslConfig(String var1, StringBuilder var2, String var3, ProxySslConfig var4, boolean var5, boolean var6);

    public static interface NginxControllerInternal {
        public void doExtraConfigurationDuringStart();
    }
}

