/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.proxy;

import brooklyn.util.flags.FlagUtils;
import brooklyn.util.flags.SetFromFlag;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxySslConfig
implements Serializable {
    private static final long serialVersionUID = -2692754611458939617L;
    private static final Logger log = LoggerFactory.getLogger(ProxySslConfig.class);
    private String certificateSourceUrl;
    private String keySourceUrl;
    private String certificateDestination;
    private String keyDestination;
    private boolean targetIsSsl = false;
    private boolean reuseSessions = false;

    public static Builder builder() {
        return new Builder();
    }

    public static ProxySslConfig fromMap(Map<?, ?> map) {
        Builder b = new Builder();
        Map unused = FlagUtils.setFieldsFromFlags(map, (Object)b);
        if (!unused.isEmpty()) {
            log.warn("Unused flags when populating " + b + " (ignoring): " + unused);
        }
        return b.build();
    }

    public ProxySslConfig() {
    }

    protected ProxySslConfig(Builder builder) {
        this.certificateSourceUrl = builder.certificateSourceUrl;
        this.keySourceUrl = builder.keySourceUrl;
        this.certificateDestination = builder.certificateDestination;
        this.keyDestination = builder.keyDestination;
        this.targetIsSsl = builder.targetIsSsl;
        this.reuseSessions = builder.reuseSessions;
    }

    public String getCertificateSourceUrl() {
        return this.certificateSourceUrl;
    }

    public void setCertificateSourceUrl(String certificateSourceUrl) {
        this.certificateSourceUrl = certificateSourceUrl;
    }

    public String getKeySourceUrl() {
        return this.keySourceUrl;
    }

    public void setKeySourceUrl(String keySourceUrl) {
        this.keySourceUrl = keySourceUrl;
    }

    public String getCertificateDestination() {
        return this.certificateDestination;
    }

    public void setCertificateDestination(String certificateDestination) {
        this.certificateDestination = certificateDestination;
    }

    public String getKeyDestination() {
        return this.keyDestination;
    }

    public void setKeyDestination(String keyDestination) {
        this.keyDestination = keyDestination;
    }

    public boolean getTargetIsSsl() {
        return this.targetIsSsl;
    }

    public void setTargetIsSsl(boolean targetIsSsl) {
        this.targetIsSsl = targetIsSsl;
    }

    public boolean getReuseSessions() {
        return this.reuseSessions;
    }

    public void setReuseSessions(boolean reuseSessions) {
        this.reuseSessions = reuseSessions;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.certificateSourceUrl, this.keySourceUrl, this.certificateDestination, this.keyDestination, this.reuseSessions, this.targetIsSsl});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProxySslConfig other = (ProxySslConfig)obj;
        return Objects.equal((Object)this.certificateSourceUrl, (Object)other.certificateSourceUrl) && Objects.equal((Object)this.certificateDestination, (Object)other.certificateDestination) && Objects.equal((Object)this.keyDestination, (Object)other.keyDestination) && Objects.equal((Object)this.keySourceUrl, (Object)other.keySourceUrl) && Objects.equal((Object)this.reuseSessions, (Object)other.reuseSessions) && Objects.equal((Object)this.targetIsSsl, (Object)other.targetIsSsl);
    }

    public static class Builder {
        @SetFromFlag
        protected String certificateSourceUrl;
        @SetFromFlag
        protected String keySourceUrl;
        @SetFromFlag
        protected String certificateDestination;
        @SetFromFlag
        protected String keyDestination;
        @SetFromFlag
        protected boolean targetIsSsl = false;
        @SetFromFlag
        protected boolean reuseSessions = false;

        public Builder certificateSourceUrl(String val) {
            this.certificateSourceUrl = val;
            return this;
        }

        public Builder keySourceUrl(String val) {
            this.keySourceUrl = val;
            return this;
        }

        public Builder certificateDestination(String val) {
            this.certificateDestination = val;
            return this;
        }

        public Builder keyDestination(String val) {
            this.keyDestination = val;
            return this;
        }

        public Builder targetIsSsl(boolean val) {
            this.targetIsSsl = val;
            return this;
        }

        public Builder reuseSessions(boolean val) {
            this.reuseSessions = val;
            return this;
        }

        public ProxySslConfig build() {
            ProxySslConfig result = new ProxySslConfig(this);
            return result;
        }
    }
}

