/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.proxy;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.Group;
import brooklyn.entity.annotation.Effector;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.MethodEffector;
import brooklyn.entity.trait.Startable;
import brooklyn.entity.webapp.WebAppService;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.BasicAttributeSensorAndConfigKey;
import brooklyn.event.basic.BasicConfigKey;
import brooklyn.event.basic.PortAttributeSensorAndConfigKey;
import brooklyn.event.basic.Sensors;
import brooklyn.util.flags.SetFromFlag;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.util.Map;

public interface LoadBalancer
extends Entity,
Startable {
    @SetFromFlag(value="serverPool")
    public static final ConfigKey<Group> SERVER_POOL = new BasicConfigKey(Group.class, "loadbalancer.serverpool", "The default servers to route messages to");
    @SetFromFlag(value="urlMappings")
    public static final ConfigKey<Group> URL_MAPPINGS = new BasicConfigKey(Group.class, "loadbalancer.urlmappings", "Special mapping rules (e.g. for domain/path matching, rewrite, etc); not supported by all load balancers");
    @SetFromFlag(value="portNumberSensor")
    public static final BasicAttributeSensorAndConfigKey<AttributeSensor<Integer>> PORT_NUMBER_SENSOR = new BasicAttributeSensorAndConfigKey((TypeToken)new TypeToken<AttributeSensor<Integer>>(){}, "member.sensor.portNumber", "Port number sensor on members (defaults to http.port; not supported in all implementations)", (Object)Attributes.HTTP_PORT);
    @SetFromFlag(value="hostnameSensor")
    public static final BasicAttributeSensorAndConfigKey<AttributeSensor<String>> HOSTNAME_SENSOR = new BasicAttributeSensorAndConfigKey((TypeToken)new TypeToken<AttributeSensor<String>>(){}, "member.sensor.hostname", "Hostname/IP sensor on members (defaults to host.subnet.hostname; not supported in all implementations)", (Object)Attributes.SUBNET_HOSTNAME);
    @SetFromFlag(value="hostAndPortSensor")
    public static final BasicAttributeSensorAndConfigKey<AttributeSensor<String>> HOST_AND_PORT_SENSOR = new BasicAttributeSensorAndConfigKey((TypeToken)new TypeToken<AttributeSensor<String>>(){}, "member.sensor.hostandport", "host:port sensor on members (invalid to configure this and the portNumber or hostname sensors)", null);
    @SetFromFlag(value="port")
    public static final PortAttributeSensorAndConfigKey PROXY_HTTP_PORT = new PortAttributeSensorAndConfigKey("proxy.http.port", "Main port where this proxy listens if using HTTP", (Object)ImmutableList.of((Object)8000, (Object)"8001+"));
    @SetFromFlag(value="httpsPort")
    public static final PortAttributeSensorAndConfigKey PROXY_HTTPS_PORT = new PortAttributeSensorAndConfigKey("proxy.https.port", "Main port where this proxy listens if using HTTPS", (Object)ImmutableList.of((Object)8443, (Object)"8443+"));
    @SetFromFlag(value="protocol")
    public static final BasicAttributeSensorAndConfigKey<String> PROTOCOL = new BasicAttributeSensorAndConfigKey(String.class, "proxy.protocol", "Main URL protocol this proxy answers (typically http or https)", null);
    public static final AttributeSensor<String> HOSTNAME = Attributes.HOSTNAME;
    public static final AttributeSensor<URI> MAIN_URI = Attributes.MAIN_URI;
    public static final AttributeSensor<String> ROOT_URL = WebAppService.ROOT_URL;
    public static final AttributeSensor<Map<Entity, String>> SERVER_POOL_TARGETS = Sensors.newSensor((TypeToken)new TypeToken<Map<Entity, String>>(){}, (String)"proxy.serverpool.targets", (String)"The downstream targets in the server pool");
    public static final MethodEffector<Void> RELOAD = new MethodEffector(LoadBalancer.class, "reload");
    public static final MethodEffector<Void> UPDATE = new MethodEffector(LoadBalancer.class, "update");

    @Effector(description="Forces reload of the configuration")
    public void reload();

    @Effector(description="Updates the entities configuration, and then forces reload of that configuration")
    public void update();

    public void bind(Map<?, ?> var1);
}

