/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.proxy;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.Group;
import brooklyn.entity.basic.AbstractEntity;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.group.AbstractMembershipTrackingPolicy;
import brooklyn.entity.group.Cluster;
import brooklyn.entity.proxy.AbstractNonProvisionedController;
import brooklyn.entity.trait.Startable;
import brooklyn.event.AttributeSensor;
import brooklyn.event.feed.ConfigToAttributes;
import brooklyn.location.Location;
import brooklyn.policy.Policy;
import brooklyn.policy.PolicySpec;
import brooklyn.util.JavaGroovyEquivalents;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.guava.Maybe;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNonProvisionedControllerImpl
extends AbstractEntity
implements AbstractNonProvisionedController {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNonProvisionedControllerImpl.class);
    protected volatile boolean isActive;
    protected volatile boolean updateNeeded = true;
    protected AbstractMembershipTrackingPolicy serverPoolMemberTrackerPolicy;
    protected Set<String> serverPoolAddresses = Sets.newLinkedHashSet();
    protected Map<Entity, String> serverPoolTargets = Maps.newLinkedHashMap();

    public AbstractNonProvisionedControllerImpl() {
        this((Map)MutableMap.of(), null, null);
    }

    public AbstractNonProvisionedControllerImpl(Map properties) {
        this(properties, null, null);
    }

    public AbstractNonProvisionedControllerImpl(Entity parent) {
        this((Map)MutableMap.of(), parent, null);
    }

    public AbstractNonProvisionedControllerImpl(Map properties, Entity parent) {
        this(properties, parent, null);
    }

    public AbstractNonProvisionedControllerImpl(Entity parent, Cluster cluster) {
        this((Map)MutableMap.of(), parent, cluster);
    }

    public AbstractNonProvisionedControllerImpl(Map properties, Entity parent, Cluster cluster) {
    }

    @Override
    public void bind(Map<?, ?> flags) {
        if (flags.containsKey("serverPool")) {
            this.setConfigEvenIfOwned(SERVER_POOL, (Group)flags.get("serverPool"));
        }
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    public void start(Collection<? extends Location> locations) {
        this.preStart();
    }

    public void stop() {
        this.preStop();
    }

    protected void preStart() {
        AttributeSensor hostAndPortSensor = (AttributeSensor)this.getConfig((ConfigKey.HasConfigKey)HOST_AND_PORT_SENSOR);
        Maybe hostnameSensor = this.getConfigRaw((ConfigKey.HasConfigKey)HOSTNAME_SENSOR, true);
        Maybe portSensor = this.getConfigRaw((ConfigKey.HasConfigKey)PORT_NUMBER_SENSOR, true);
        if (hostAndPortSensor != null) {
            Preconditions.checkState((!hostnameSensor.isPresent() && !portSensor.isPresent() ? 1 : 0) != 0, (String)"Must not set %s and either of %s or %s", (Object[])new Object[]{HOST_AND_PORT_SENSOR, HOSTNAME_SENSOR, PORT_NUMBER_SENSOR});
        }
        ConfigToAttributes.apply((EntityLocal)this);
        this.addServerPoolMemberTrackerPolicy();
    }

    protected void preStop() {
        this.removeServerPoolMemberTrackerPolicy();
    }

    protected void addServerPoolMemberTrackerPolicy() {
        Group serverPool = this.getServerPool();
        if (serverPool != null) {
            this.serverPoolMemberTrackerPolicy = (AbstractMembershipTrackingPolicy)this.addPolicy(((PolicySpec)PolicySpec.create(MemberTrackingPolicy.class).displayName("Controller targets tracker")).configure((CharSequence)"group", (Object)serverPool));
            LOG.info("Added policy {} to {}, during start", (Object)this.serverPoolMemberTrackerPolicy, (Object)this);
            this.serverPoolAddresses.clear();
            this.serverPoolTargets.clear();
            for (Entity member : this.getServerPool().getMembers()) {
                if (!this.belongsInServerPool(member)) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Done {} checkEntity {}", (Object)this, (Object)member);
                }
                String address = this.getAddressOfEntity(member);
                this.serverPoolTargets.put(member, address);
                if (address == null) continue;
                this.serverPoolAddresses.add(address);
            }
            LOG.info("Resetting {}, members {} with addresses {}", new Object[]{this, this.serverPoolTargets, this.serverPoolAddresses});
            this.setAttribute(SERVER_POOL_TARGETS, this.serverPoolTargets);
        }
    }

    protected void removeServerPoolMemberTrackerPolicy() {
        if (this.serverPoolMemberTrackerPolicy != null) {
            this.removePolicy((Policy)this.serverPoolMemberTrackerPolicy);
        }
    }

    protected abstract void reconfigureService();

    @Override
    public synchronized void update() {
        if (!this.isActive()) {
            this.updateNeeded = true;
        } else {
            this.updateNeeded = false;
            LOG.debug("Updating {} in response to changes", (Object)this);
            this.reconfigureService();
            LOG.debug("Reloading {} in response to changes", (Object)this);
            this.invoke((Effector)RELOAD);
        }
        this.setAttribute(SERVER_POOL_TARGETS, this.serverPoolTargets);
    }

    protected synchronized void onServerPoolMemberChanged(Entity member) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("For {}, considering membership of {} which is in locations {}", new Object[]{this, member, member.getLocations()});
        }
        if (this.belongsInServerPool(member)) {
            this.addServerPoolMember(member);
        } else {
            this.removeServerPoolMember(member);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Done {} checkEntity {}", (Object)this, (Object)member);
        }
    }

    protected boolean belongsInServerPool(Entity member) {
        if (!JavaGroovyEquivalents.groovyTruth((Object)member.getAttribute(Startable.SERVICE_UP))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Members of {}, checking {}, eliminating because not up", (Object)this, (Object)member);
            }
            return false;
        }
        if (!this.getServerPool().getMembers().contains(member)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Members of {}, checking {}, eliminating because not member", (Object)this, (Object)member);
            }
            return false;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Members of {}, checking {}, approving", (Object)this, (Object)member);
        }
        return true;
    }

    private Group getServerPool() {
        return (Group)this.getConfig(SERVER_POOL);
    }

    protected AttributeSensor<Integer> getPortNumberSensor() {
        return (AttributeSensor)this.getAttribute((AttributeSensor)PORT_NUMBER_SENSOR);
    }

    protected AttributeSensor<String> getHostnameSensor() {
        return (AttributeSensor)this.getAttribute((AttributeSensor)HOSTNAME_SENSOR);
    }

    protected AttributeSensor<String> getHostAndPortSensor() {
        return (AttributeSensor)this.getAttribute((AttributeSensor)HOST_AND_PORT_SENSOR);
    }

    protected synchronized void addServerPoolMember(Entity member) {
        if (this.serverPoolTargets.containsKey(member)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("For {}, not adding as already have member {}", new Object[]{this, member});
            }
            return;
        }
        String address = this.getAddressOfEntity(member);
        if (address != null) {
            this.serverPoolAddresses.add(address);
        }
        LOG.info("Adding to {}, new member {} with address {}", new Object[]{this, member, address});
        this.update();
        this.serverPoolTargets.put(member, address);
    }

    protected synchronized void removeServerPoolMember(Entity member) {
        if (!this.serverPoolTargets.containsKey(member)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("For {}, not removing as don't have member {}", new Object[]{this, member});
            }
            return;
        }
        String address = this.serverPoolTargets.get(member);
        if (address != null) {
            this.serverPoolAddresses.remove(address);
        }
        LOG.info("Removing from {}, member {} with address {}", new Object[]{this, member, address});
        this.update();
        this.serverPoolTargets.remove(member);
    }

    protected String getAddressOfEntity(Entity member) {
        AttributeSensor<String> hostAndPortSensor = this.getHostAndPortSensor();
        if (hostAndPortSensor != null) {
            String result = (String)member.getAttribute(hostAndPortSensor);
            if (result != null) {
                return result;
            }
            LOG.error("No host:port set for {} (using attribute {}); skipping in {}", new Object[]{member, hostAndPortSensor, this});
            return null;
        }
        String ip = (String)member.getAttribute(this.getHostnameSensor());
        Integer port = (Integer)member.getAttribute(this.getPortNumberSensor());
        if (ip != null && port != null) {
            return ip + ":" + port;
        }
        LOG.error("Unable to construct hostname:port representation for {} ({}:{}); skipping in {}", new Object[]{member, ip, port, this});
        return null;
    }

    public static class MemberTrackingPolicy
    extends AbstractMembershipTrackingPolicy {
        protected void onEntityEvent(AbstractMembershipTrackingPolicy.EventType type, Entity member) {
            ((AbstractNonProvisionedControllerImpl)this.entity).onServerPoolMemberChanged(member);
        }
    }
}

