/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.proxy;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.Group;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.entity.basic.ServiceStateLogic;
import brooklyn.entity.basic.SoftwareProcessImpl;
import brooklyn.entity.group.AbstractMembershipTrackingPolicy;
import brooklyn.entity.group.Cluster;
import brooklyn.entity.proxy.AbstractController;
import brooklyn.entity.proxy.ProxySslConfig;
import brooklyn.entity.trait.Startable;
import brooklyn.event.AttributeSensor;
import brooklyn.event.feed.ConfigToAttributes;
import brooklyn.location.access.BrooklynAccessUtils;
import brooklyn.location.basic.Machines;
import brooklyn.management.Task;
import brooklyn.management.TaskAdaptable;
import brooklyn.policy.Policy;
import brooklyn.policy.PolicySpec;
import brooklyn.util.JavaGroovyEquivalents;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.guava.Maybe;
import brooklyn.util.task.Tasks;
import brooklyn.util.text.Strings;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.net.HostAndPort;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractControllerImpl
extends SoftwareProcessImpl
implements AbstractController {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractControllerImpl.class);
    protected volatile boolean isActive;
    protected volatile boolean updateNeeded = true;
    protected AbstractMembershipTrackingPolicy serverPoolMemberTrackerPolicy;
    protected Set<String> serverPoolAddresses = Sets.newLinkedHashSet();
    protected Map<Entity, String> serverPoolTargets = Maps.newLinkedHashMap();

    public AbstractControllerImpl() {
        this((Map<?, ?>)MutableMap.of(), null, null);
    }

    public AbstractControllerImpl(Map<?, ?> properties) {
        this(properties, null, null);
    }

    public AbstractControllerImpl(Entity parent) {
        this((Map<?, ?>)MutableMap.of(), parent, null);
    }

    public AbstractControllerImpl(Map<?, ?> properties, Entity parent) {
        this(properties, parent, null);
    }

    public AbstractControllerImpl(Entity parent, Cluster cluster) {
        this((Map<?, ?>)MutableMap.of(), parent, cluster);
    }

    public AbstractControllerImpl(Map<?, ?> properties, Entity parent, Cluster cluster) {
        super(properties, parent);
    }

    public void init() {
        super.init();
        this.setAttribute(SERVER_POOL_TARGETS, ImmutableMap.of());
    }

    protected void addServerPoolMemberTrackingPolicy() {
        Group serverPool = this.getServerPool();
        if (serverPool == null) {
            return;
        }
        if (this.serverPoolMemberTrackerPolicy != null) {
            LOG.debug("Call to addServerPoolMemberTrackingPolicy when serverPoolMemberTrackingPolicy already exists, removing and re-adding, in {}", (Object)this);
            this.removeServerPoolMemberTrackingPolicy();
        }
        for (Policy p : this.getPolicies()) {
            if (!(p instanceof ServerPoolMemberTrackerPolicy)) continue;
            LOG.info(this + " picking up " + p + " as the tracker (already set, often due to rebind)");
            this.serverPoolMemberTrackerPolicy = (ServerPoolMemberTrackerPolicy)p;
            return;
        }
        AttributeSensor hostAndPortSensor = (AttributeSensor)this.getConfig((ConfigKey.HasConfigKey)HOST_AND_PORT_SENSOR);
        AttributeSensor hostnameSensor = (AttributeSensor)this.getConfig((ConfigKey.HasConfigKey)HOSTNAME_SENSOR);
        AttributeSensor portSensor = (AttributeSensor)this.getConfig((ConfigKey.HasConfigKey)PORT_NUMBER_SENSOR);
        ImmutableSet sensorsToTrack = hostAndPortSensor != null ? ImmutableSet.of((Object)hostAndPortSensor) : ImmutableSet.of((Object)hostnameSensor, (Object)portSensor);
        this.serverPoolMemberTrackerPolicy = (AbstractMembershipTrackingPolicy)this.addPolicy(((PolicySpec)PolicySpec.create(ServerPoolMemberTrackerPolicy.class).displayName("Controller targets tracker")).configure((CharSequence)"group", (Object)serverPool).configure((CharSequence)"sensorsToTrack", (Object)sensorsToTrack));
        LOG.info("Added policy {} to {}", (Object)this.serverPoolMemberTrackerPolicy, (Object)this);
        LinkedHashMap serverPoolTargets = Maps.newLinkedHashMap();
        for (Entity member : this.getServerPool().getMembers()) {
            if (!this.belongsInServerPool(member)) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Done {} checkEntity {}", (Object)this, (Object)member);
            }
            String address = this.getAddressOfEntity(member);
            serverPoolTargets.put(member, address);
        }
        LOG.info("Resetting {}, server pool targets {}", new Object[]{this, serverPoolTargets});
        this.setAttribute(SERVER_POOL_TARGETS, serverPoolTargets);
    }

    protected void removeServerPoolMemberTrackingPolicy() {
        if (this.serverPoolMemberTrackerPolicy != null) {
            this.removePolicy((Policy)this.serverPoolMemberTrackerPolicy);
        }
    }

    @Override
    public Set<String> getServerPoolAddresses() {
        return ImmutableSet.copyOf((Iterable)Iterables.filter(((Map)this.getAttribute(SERVER_POOL_TARGETS)).values(), (Predicate)Predicates.notNull()));
    }

    @Override
    public void bind(Map<?, ?> flags) {
        if (flags.containsKey("serverPool")) {
            this.setConfigEvenIfOwned(SERVER_POOL, (Group)flags.get("serverPool"));
        }
    }

    public void onManagementNoLongerMaster() {
        super.onManagementNoLongerMaster();
        this.isActive = false;
        this.removeServerPoolMemberTrackingPolicy();
    }

    private Group getServerPool() {
        return (Group)this.getConfig(SERVER_POOL);
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public boolean isSsl() {
        return this.getSslConfig() != null;
    }

    @Override
    public ProxySslConfig getSslConfig() {
        return (ProxySslConfig)this.getConfig(SSL_CONFIG);
    }

    @Override
    public String getProtocol() {
        return (String)this.getAttribute((AttributeSensor)PROTOCOL);
    }

    @Override
    public String getDomain() {
        return (String)this.getAttribute((AttributeSensor)DOMAIN_NAME);
    }

    @Override
    public Integer getPort() {
        if (this.isSsl()) {
            return (Integer)this.getAttribute((AttributeSensor)PROXY_HTTPS_PORT);
        }
        return (Integer)this.getAttribute((AttributeSensor)PROXY_HTTP_PORT);
    }

    @Override
    public String getUrl() {
        return Strings.toString((Object)this.getAttribute(MAIN_URI));
    }

    @Override
    public AttributeSensor<Integer> getPortNumberSensor() {
        return (AttributeSensor)this.getAttribute((AttributeSensor)PORT_NUMBER_SENSOR);
    }

    @Override
    public AttributeSensor<String> getHostnameSensor() {
        return (AttributeSensor)this.getAttribute((AttributeSensor)HOSTNAME_SENSOR);
    }

    @Override
    public AttributeSensor<String> getHostAndPortSensor() {
        return (AttributeSensor)this.getAttribute((AttributeSensor)HOST_AND_PORT_SENSOR);
    }

    @Override
    public abstract void reload();

    protected String inferProtocol() {
        return this.isSsl() ? "https" : "http";
    }

    protected String inferUrl(boolean requireManagementAccessible) {
        HostAndPort accessible;
        String protocol = (String)Preconditions.checkNotNull((Object)this.getProtocol(), (Object)"no protocol configured");
        String domain = this.getDomain();
        if (domain != null && domain.startsWith("*.")) {
            domain = domain.replace("*.", "");
        }
        Integer port = (Integer)Preconditions.checkNotNull((Object)this.getPort(), (Object)"no port configured (the requested port may be in use)");
        if (requireManagementAccessible && (accessible = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)this, (int)port)) != null) {
            domain = accessible.getHostText();
            port = accessible.getPort();
        }
        if (domain == null) {
            domain = (String)Machines.findSubnetHostname((Entity)this).orNull();
        }
        if (domain == null) {
            return null;
        }
        return protocol + "://" + domain + ":" + port + "/" + (String)this.getConfig(SERVICE_UP_URL_PATH);
    }

    protected String inferUrl() {
        return this.inferUrl(false);
    }

    protected Collection<Integer> getRequiredOpenPorts() {
        Collection result = super.getRequiredOpenPorts();
        if (JavaGroovyEquivalents.groovyTruth((Object)this.getAttribute((AttributeSensor)PROXY_HTTP_PORT))) {
            result.add(this.getAttribute((AttributeSensor)PROXY_HTTP_PORT));
        }
        if (JavaGroovyEquivalents.groovyTruth((Object)this.getAttribute((AttributeSensor)PROXY_HTTPS_PORT))) {
            result.add(this.getAttribute((AttributeSensor)PROXY_HTTPS_PORT));
        }
        return result;
    }

    protected void preStart() {
        super.preStart();
        this.computePortsAndUrls();
    }

    protected void computePortsAndUrls() {
        AttributeSensor hostAndPortSensor = (AttributeSensor)this.getConfig((ConfigKey.HasConfigKey)HOST_AND_PORT_SENSOR);
        Maybe hostnameSensor = this.config().getRaw((ConfigKey.HasConfigKey)HOSTNAME_SENSOR);
        Maybe portSensor = this.config().getRaw((ConfigKey.HasConfigKey)PORT_NUMBER_SENSOR);
        if (hostAndPortSensor != null) {
            Preconditions.checkState((!hostnameSensor.isPresent() && !portSensor.isPresent() ? 1 : 0) != 0, (String)"Must not set %s and either of %s or %s", (Object[])new Object[]{HOST_AND_PORT_SENSOR, HOSTNAME_SENSOR, PORT_NUMBER_SENSOR});
        }
        ConfigToAttributes.apply((EntityLocal)this);
        this.setAttribute((AttributeSensor)PROTOCOL, this.inferProtocol());
        this.setAttribute(MAIN_URI, URI.create(this.inferUrl()));
        this.setAttribute(ROOT_URL, this.inferUrl());
        Preconditions.checkNotNull(this.getPortNumberSensor(), (Object)"no sensor configured to infer port number");
    }

    protected void connectSensors() {
        super.connectSensors();
        this.addServerPoolMemberTrackingPolicy();
    }

    protected void postStart() {
        super.postStart();
        this.isActive = true;
        this.update();
    }

    protected void postRebind() {
        super.postRebind();
        Lifecycle state = (Lifecycle)this.getAttribute(SERVICE_STATE_ACTUAL);
        if (state != null && state == Lifecycle.RUNNING) {
            this.isActive = true;
            this.updateNeeded();
        }
    }

    protected void preStop() {
        super.preStop();
        this.removeServerPoolMemberTrackingPolicy();
    }

    protected abstract void reconfigureService();

    public synchronized void updateNeeded() {
        if (this.updateNeeded) {
            return;
        }
        this.updateNeeded = true;
        LOG.debug("queueing an update-needed task for " + this + "; update will occur shortly");
        Entities.submit((Entity)this, (TaskAdaptable)Tasks.builder().name("update-needed").body(new Runnable(){

            @Override
            public void run() {
                if (AbstractControllerImpl.this.updateNeeded) {
                    AbstractControllerImpl.this.update();
                }
            }
        }).build());
    }

    @Override
    public void update() {
        try {
            Task<?> task = this.updateAsync();
            if (task != null) {
                task.getUnchecked();
            }
            ServiceStateLogic.ServiceProblemsLogic.clearProblemsIndicator((EntityLocal)this, (String)"update");
        }
        catch (Exception e) {
            ServiceStateLogic.ServiceProblemsLogic.updateProblemsIndicator((EntityLocal)this, (String)"update", (Object)("update failed with: " + Exceptions.collapseText((Throwable)e)));
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public synchronized Task<?> updateAsync() {
        Task result = null;
        if (!this.isActive()) {
            this.updateNeeded = true;
        } else {
            this.updateNeeded = false;
            LOG.debug("Updating {} in response to changes", (Object)this);
            LOG.info("Updating {}, server pool targets {}", new Object[]{this, this.getAttribute(SERVER_POOL_TARGETS)});
            this.reconfigureService();
            LOG.debug("Reloading {} in response to changes", (Object)this);
            result = this.invoke((Effector)RELOAD);
        }
        return result;
    }

    protected synchronized void onServerPoolMemberChanged(Entity member) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("For {}, considering membership of {} which is in locations {}", new Object[]{this, member, member.getLocations()});
        }
        if (this.belongsInServerPool(member)) {
            this.addServerPoolMember(member);
        } else {
            this.removeServerPoolMember(member);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Done {} checkEntity {}", (Object)this, (Object)member);
        }
    }

    protected boolean belongsInServerPool(Entity member) {
        if (!JavaGroovyEquivalents.groovyTruth((Object)member.getAttribute(Startable.SERVICE_UP))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Members of {}, checking {}, eliminating because not up", (Object)this, (Object)member);
            }
            return false;
        }
        if (!this.getServerPool().getMembers().contains(member)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Members of {}, checking {}, eliminating because not member", (Object)this, (Object)member);
            }
            return false;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Members of {}, checking {}, approving", (Object)this, (Object)member);
        }
        return true;
    }

    protected synchronized void addServerPoolMember(Entity member) {
        String oldAddress = (String)((Map)this.getAttribute(SERVER_POOL_TARGETS)).get(member);
        String newAddress = this.getAddressOfEntity(member);
        if (Objects.equal((Object)newAddress, (Object)oldAddress)) {
            if (LOG.isTraceEnabled() && LOG.isTraceEnabled()) {
                LOG.trace("Ignoring unchanged address {}", (Object)oldAddress);
            }
            return;
        }
        if (newAddress == null) {
            LOG.info("Removing from {}, member {} with old address {}, because inferred address is now null", new Object[]{this, member, oldAddress});
        } else if (oldAddress != null) {
            LOG.info("Replacing in {}, member {} with old address {}, new address {}", new Object[]{this, member, oldAddress, newAddress});
        } else {
            LOG.info("Adding to {}, new member {} with address {}", new Object[]{this, member, newAddress});
        }
        if (Objects.equal((Object)oldAddress, (Object)newAddress)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("For {}, ignoring change in member {} because address still {}", new Object[]{this, member, newAddress});
            }
            return;
        }
        MapAttribute.put(this, SERVER_POOL_TARGETS, member, newAddress);
        this.updateAsync();
    }

    protected synchronized void removeServerPoolMember(Entity member) {
        if (!((Map)this.getAttribute(SERVER_POOL_TARGETS)).containsKey(member)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("For {}, not removing as don't have member {}", new Object[]{this, member});
            }
            return;
        }
        String address = (String)MapAttribute.remove(this, SERVER_POOL_TARGETS, member);
        LOG.info("Removing from {}, member {} with address {}", new Object[]{this, member, address});
        this.updateAsync();
    }

    protected String getAddressOfEntity(Entity member) {
        AttributeSensor<String> hostAndPortSensor = this.getHostAndPortSensor();
        if (hostAndPortSensor != null) {
            String result = (String)member.getAttribute(hostAndPortSensor);
            if (result != null) {
                return result;
            }
            LOG.error("No host:port set for {} (using attribute {}); skipping in {}", new Object[]{member, hostAndPortSensor, this});
            return null;
        }
        String ip = (String)member.getAttribute(this.getHostnameSensor());
        Integer port = (Integer)member.getAttribute(this.getPortNumberSensor());
        if (ip != null && port != null) {
            return ip + ":" + port;
        }
        LOG.error("Unable to construct hostname:port representation for {} ({}:{}); skipping in {}", new Object[]{member, ip, port, this});
        return null;
    }

    private static class MapAttribute {
        private MapAttribute() {
        }

        public static <K, V> V put(Entity entity, AttributeSensor<Map<K, V>> attribute, K key, V value) {
            Map oldMap = (Map)entity.getAttribute(attribute);
            MutableMap newMap = MutableMap.copyOf((Map)oldMap);
            V oldVal = newMap.put(key, value);
            ((EntityInternal)entity).setAttribute(attribute, (Object)newMap);
            return oldVal;
        }

        public static <K, V> V remove(Entity entity, AttributeSensor<Map<K, V>> attribute, K key) {
            Map oldMap = (Map)entity.getAttribute(attribute);
            MutableMap newMap = MutableMap.copyOf((Map)oldMap);
            Object oldVal = newMap.remove(key);
            ((EntityInternal)entity).setAttribute(attribute, (Object)newMap);
            return oldVal;
        }
    }

    public static class ServerPoolMemberTrackerPolicy
    extends AbstractMembershipTrackingPolicy {
        protected void onEntityEvent(AbstractMembershipTrackingPolicy.EventType type, Entity entity) {
            ((AbstractControllerImpl)this.entity).onServerPoolMemberChanged(entity);
        }
    }
}

